/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tasks;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXEngine;
import org.nuiton.jaxx.compiler.tasks.JAXXEngineTask;

public class FinalizeTask
extends JAXXEngineTask {
    private static final Logger log = LogManager.getLogger(FinalizeTask.class);
    public static final String TASK_NAME = "Finalize";

    public FinalizeTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        JAXXCompilerFile[] files;
        boolean success = true;
        boolean isVerbose = engine.getConfiguration().isVerbose();
        this.checkAllFilesCompiled(engine);
        for (JAXXCompilerFile jaxxFile : files = engine.getCompiledFiles()) {
            if (isVerbose) {
                log.info("start " + jaxxFile.getClassName());
            }
            JAXXCompiler compiler = jaxxFile.getCompiler();
            this.addStartProfileTime(engine, compiler);
            compiler.finalizeCompiler();
            this.addEndProfileTime(engine, compiler);
            if (!compiler.isFailed()) continue;
            success = false;
        }
        if (engine.getConfiguration().isI18nable()) {
            engine.flushI18nGetterFile();
        }
        return success;
    }
}

