/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import java.io.IOException;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.DefaultObjectHandler;
import org.nuiton.jaxx.compiler.tags.swing.JTabbedPaneHandler;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import org.w3c.dom.Element;

public class TabHandler
extends DefaultObjectHandler {
    public static final String TAG_NAME = "tab";
    public static final String ATTRIBUTE_TAB_COMPONENT = "tabComponent";

    public TabHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, TabInfo.class);
    }

    @Override
    protected CompiledObject createCompiledObject(String id, JAXXCompiler compiler) {
        return new CompiledTabbedTab(id, this.getBeanClass(), compiler);
    }

    @Override
    protected CompiledObject getSafeCompiledObject(Element tag, JAXXCompiler compiler) {
        CompiledObject compiledObject = super.getSafeCompiledObject(tag, compiler);
        if (!(compiledObject instanceof CompiledTabbedTab)) {
            String message = String.format("Should have found a tab compiled object, but found: %s", compiledObject);
            compiler.reportError(tag, message);
            throw new IllegalStateException(message);
        }
        ((JTabbedPaneHandler.CompiledTabbedPane)compiler.getOpenComponent()).tabInfo = ((CompiledTabbedTab)compiledObject).tabInfo;
        return compiledObject;
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        CompiledObject openComponent = compiler.getOpenComponent();
        if (!(openComponent instanceof JTabbedPaneHandler.CompiledTabbedPane)) {
            compiler.reportError(tag, "tab tag may only appear within JTabbedPane tag, but found: " + openComponent);
            return;
        }
        super.compileSecondPass(tag, compiler);
        ((JTabbedPaneHandler.CompiledTabbedPane)openComponent).tabInfo = null;
    }

    @Override
    public void setAttribute(CompiledObject object, String propertyName, String stringValue, boolean inline, JAXXCompiler compiler) {
        if (propertyName.equals(ATTRIBUTE_TAB_COMPONENT)) {
            ((CompiledTabbedTab)object).tabInfo.setTabComponentStr(TypeManager.getJavaCode(stringValue));
        }
        super.setAttribute(object, propertyName, stringValue, inline, compiler);
    }

    public static class CompiledTabbedTab
    extends CompiledObject {
        final TabInfo tabInfo;

        public CompiledTabbedTab(String id, ClassDescriptor objectClass, JAXXCompiler compiler) {
            super(id, objectClass, compiler);
            this.tabInfo = new TabInfo(id);
            this.setConstructorParams("\"" + id + "\"");
        }
    }
}

