/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.tags.TagHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ImportHandler
implements TagHandler {
    protected static final Logger log = LogManager.getLogger(ImportHandler.class);
    public static final String TAG_NAME = "import";

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws IOException {
        StringBuilder script = new StringBuilder();
        NodeList children = tag.getChildNodes();
        block9: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    compiler.reportError("<import> tag may not contain child elements: " + tag);
                }
                case 3: 
                case 4: {
                    String txt = ((Text)child).getData();
                    if (log.isDebugEnabled()) {
                        log.debug("Will treate imports  :[\n" + txt + "\n]");
                    }
                    String eol = JAXXCompiler.getLineSeparator();
                    try (LineNumberReader reader = new LineNumberReader(new StringReader(txt.trim()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).isEmpty()) continue;
                            script.append("import ").append(line);
                            if (!line.endsWith(";")) {
                                script.append(';');
                            }
                            script.append(eol);
                        }
                        continue block9;
                    }
                }
            }
        }
        String scriptString = script.toString().trim();
        if (!scriptString.isEmpty()) {
            compiler.registerScript(script.toString());
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) {
    }
}

