/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.script;

import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaConstructor;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.parser.JavaParser;
import org.nuiton.jaxx.compiler.java.parser.JavaParserTreeConstants;
import org.nuiton.jaxx.compiler.java.parser.SimpleNode;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.FieldDescriptor;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.script.ScriptInitializer;
import org.nuiton.jaxx.compiler.tags.TagManager;

public class ScriptManager {
    private final JAXXCompiler compiler;
    private static final Logger log = LogManager.getLogger(ScriptManager.class);

    public ScriptManager(JAXXCompiler compiler) {
        this.compiler = compiler;
    }

    public String trimScript(String script) {
        return this.trimScript(script, true);
    }

    public String trimScript(String script, boolean warn) {
        if ((script = script.trim()).startsWith("{") && script.endsWith("}")) {
            if (warn) {
                this.compiler.reportWarning("curly braces are unnecessary for script '" + script + "'");
            }
            script = script.substring(1, script.length() - 1);
        }
        return script;
    }

    public void checkParse(String script) throws CompilerException {
        script = this.trimScript(script);
        JavaParser p = new JavaParser(new StringReader(script));
        while (!p.Line()) {
        }
    }

    public String preprocessScript(String script) throws CompilerException {
        script = this.trimScript(script);
        StringBuilder result = new StringBuilder();
        JavaParser p = new JavaParser(new StringReader(script));
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (node == null) continue;
            this.preprocessScriptNode(node, false);
            result.append(node.getText());
        }
        return result.toString();
    }

    private void scanCompoundSymbol(String symbol) {
        String[] tokens = symbol.split("\\.");
        StringBuilder currentSymbol = new StringBuilder();
        for (String token : tokens) {
            if (currentSymbol.length() > 0) {
                currentSymbol.append('.');
            }
            currentSymbol.append(token.trim());
            String contextClass = TagManager.resolveClassName(currentSymbol.toString(), this.compiler);
            if (contextClass == null) continue;
            this.compiler.addDependencyClass(contextClass);
        }
    }

    private void preprocessScriptNode(SimpleNode node, boolean staticContext) throws CompilerException {
        if (node.getId() == 22) {
            if (node.getParent().getChild(0).getText().contains("static")) {
                staticContext = true;
            }
        } else if (node.getId() == 28 && node.getText().trim().startsWith("static")) {
            staticContext = true;
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            this.preprocessScriptNode(node.getChild(i), staticContext);
        }
        int id = node.getId();
        if (id == 37 || id == 31) {
            this.scanCompoundSymbol(node.getText());
        }
    }

    private int getLineType(SimpleNode line) {
        if (line.jjtGetNumChildren() == 1) {
            SimpleNode node = line.getChild(0);
            if (node.getId() == 77) {
                if (node.jjtGetNumChildren() == 1) {
                    return node.getChild(0).getId();
                }
            } else if (node.getId() == 16) {
                int id = node.getChild(0).getId();
                if (id == 4) {
                    return node.getChild(1).getId();
                }
                if (id == 28) {
                    return id;
                }
            }
            return node.getId();
        }
        return 0;
    }

    private SimpleNode findExplicitConstructorInvocation(SimpleNode parent) {
        if (parent.getId() == 27) {
            return parent;
        }
        int count = parent.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            SimpleNode result = this.findExplicitConstructorInvocation(parent.getChild(i));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void processConstructor(String modifiers, SimpleNode node) {
        assert (node.getId() == 26) : "expected node to be ConstructorDeclaration, found " + JavaParserTreeConstants.jjtNodeName[node.getId()] + " instead";
        assert (node.getChild(0).getId() == 24) : "expected node 0 to be FormalParameters, found " + JavaParserTreeConstants.jjtNodeName[node.getChild(1).getId()] + " instead";
        Object code = "";
        if (node.getChild(0).jjtGetNumChildren() == 0) {
            this.compiler.reportError("The default no-argument constructor may not be redefined");
        } else {
            SimpleNode explicitConstructorInvocation = this.findExplicitConstructorInvocation(node);
            if (explicitConstructorInvocation == null || explicitConstructorInvocation.getText().trim().startsWith("super(")) {
                code = "$initialize();" + JAXXCompiler.getLineSeparator();
                if (explicitConstructorInvocation == null) {
                    node.getChild((int)1).firstToken.image = node.getChild((int)1).firstToken.image;
                } else {
                    explicitConstructorInvocation.lastToken.image = explicitConstructorInvocation.lastToken.image + (String)code;
                }
            }
        }
        this.compiler.appendBodyCode(modifiers + " " + node.getText().substring(0, node.getText().length() - 1) + (String)code + "}");
    }

    private void processConstructor(SimpleNode mainNode) {
        this.compiler.registerInitializer(new RegisterConstructor(mainNode));
    }

    private void scanScriptNode(SimpleNode node) throws CompilerException {
        Object text;
        int nodeType = this.getLineType(node);
        if (nodeType == 3) {
            text = node.getChild(0).getText().trim();
            if (((String)text).startsWith("import")) {
                text = ((String)text).substring("import".length()).trim();
            }
            if (((String)text).endsWith(";")) {
                text = ((String)text).substring(0, ((String)text).length() - 1);
            }
            this.compiler.addImport((String)text);
        }
        this.preprocessScriptNode(node, false);
        if (nodeType != 3) {
            if (nodeType == 22) {
                String returnType = null;
                String name = null;
                ArrayList<String> parameterTypes = new ArrayList<String>();
                SimpleNode methodDeclaration = node.getChild(0).getChild(1);
                assert (methodDeclaration.getId() == 22);
                for (int i = 0; i < methodDeclaration.jjtGetNumChildren(); ++i) {
                    SimpleNode child = methodDeclaration.getChild(i);
                    int type = child.getId();
                    if (type == 36) {
                        String rawReturnType = child.getText().trim();
                        returnType = TagManager.resolveClassName(rawReturnType, this.compiler);
                        continue;
                    }
                    if (type != 23) continue;
                    name = child.firstToken.image.trim();
                    SimpleNode formalParameters = child.getChild(0);
                    assert (formalParameters.getId() == 24);
                    for (int j = 0; j < formalParameters.jjtGetNumChildren(); ++j) {
                        SimpleNode parameter = formalParameters.getChild(j);
                        String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                        String parameterType = TagManager.resolveClassName(rawParameterType, this.compiler);
                        parameterTypes.add(parameterType);
                    }
                }
                this.compiler.appendBodyCode(node.getText());
                this.compiler.addScriptMethod(new MethodDescriptor(name, 1, returnType, parameterTypes.toArray(new String[parameterTypes.size()]), this.compiler.getClassLoader()));
            } else if (nodeType == 6 || nodeType == 28) {
                Object str = node.getText().trim();
                if (((String)str).endsWith(";")) {
                    str = (String)str + ";";
                }
                this.compiler.appendBodyCode((String)str);
            } else if (nodeType == 26) {
                this.processConstructor(node);
            } else if (nodeType == 78 || nodeType == 17) {
                String type;
                text = node.getText().trim();
                if (!((String)text).endsWith(";")) {
                    text = (String)text + ";";
                }
                String declaration = text;
                int equals = ((String)text).indexOf("=");
                if (equals != -1) {
                    declaration = declaration.substring(0, equals);
                }
                if ((declaration = declaration.trim()).contains("<")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Found a declaration with generics : " + declaration);
                    }
                    int last = declaration.lastIndexOf(62);
                    Object newDeclaration = declaration.substring(0, declaration.indexOf(60));
                    if (last < declaration.length()) {
                        newDeclaration = (String)newDeclaration + declaration.substring(last + 1);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("==> declaration without generics : " + (String)newDeclaration);
                    }
                    declaration = newDeclaration;
                }
                Object[] declarationTokens = declaration.split("\\s");
                boolean isFinal = Arrays.asList(declarationTokens).contains("final");
                boolean isStatic = Arrays.asList(declarationTokens).contains("static");
                String name = declarationTokens[declarationTokens.length - 1];
                if (name.endsWith(";")) {
                    name = name.substring(0, name.length() - 1).trim();
                }
                String className = declarationTokens[declarationTokens.length - 2];
                if (log.isDebugEnabled()) {
                    log.debug("Found type : " + className + " : " + Arrays.toString(declarationTokens));
                }
                if ((type = TagManager.resolveClassName(className, this.compiler)) == null) {
                    throw new CompilerException("Could not find type of " + className + " for expression " + (String)text);
                }
                this.compiler.addScriptField(new FieldDescriptor(name, 1, type, this.compiler.getClassLoader()));
                if (equals != -1 && !isFinal && !isStatic) {
                    this.compiler.appendBodyCode(((String)text).substring(0, equals).trim() + ";");
                    Object initializer = ((String)text).substring(equals + 1).trim();
                    if (type.endsWith("[]")) {
                        initializer = "new " + type + " " + (String)initializer;
                    }
                    String finalInitializer = name + " = " + (String)initializer;
                    this.compiler.registerInitializer(() -> this.compiler.registerCompiledObject(new ScriptInitializer(finalInitializer, this.compiler)));
                } else {
                    this.compiler.appendBodyCode((String)text);
                }
                this.compiler.appendBodyCode("\n");
            } else {
                text = node.getText().trim();
                if (((String)text).length() > 0) {
                    if (!((String)text).endsWith(";")) {
                        text = (String)text + ";";
                    }
                    this.compiler.appendInitializerCode((String)text);
                }
            }
        }
    }

    public void registerScript(String script) throws CompilerException {
        JavaParser p = new JavaParser(new StringReader(script));
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (node == null) continue;
            this.scanScriptNode(node);
        }
    }

    class RegisterConstructor
    implements Runnable {
        final SimpleNode mainNode;

        public RegisterConstructor(SimpleNode mainNode) {
            this.mainNode = mainNode;
        }

        @Override
        public void run() {
            String className = this.mainNode.getChild((int)0).getChild((int)1).firstToken.image;
            String modifiers = this.mainNode.getChild(0).getChild(0).getText();
            SimpleNode node = this.mainNode.getChild(0).getChild(1);
            int nbArguments = node.getChild(0).jjtGetNumChildren();
            if (log.isDebugEnabled()) {
                log.debug("Constructor found with " + nbArguments + " arguments : " + node.getText());
            }
            assert (node.getId() == 26) : "expected node to be ConstructorDeclaration, found " + JavaParserTreeConstants.jjtNodeName[node.getId()] + " instead";
            assert (node.getChild(0).getId() == 24) : "expected node 0 to be FormalParameters, found " + JavaParserTreeConstants.jjtNodeName[node.getChild(1).getId()] + " instead";
            SimpleNode params = node.getChild(0);
            StringBuilder bodyC = new StringBuilder();
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                bodyC.append(node.getChild(i).getText());
            }
            Object bodyContent = bodyC.toString().trim();
            JavaArgument[] arguments = new JavaArgument[nbArguments];
            for (int i = 0; i < nbArguments; ++i) {
                JavaArgument arg;
                SimpleNode param = params.getChild(i);
                Object[] paramType = param.getChild((int)0).firstToken.image;
                ClassDescriptor type = TagManager.resolveClass((String)paramType, ScriptManager.this.compiler);
                String paramName = param.getChild((int)2).firstToken.image;
                if (log.isDebugEnabled()) {
                    log.debug("Parameter n\u00b0" + i + " --> [" + type + " : " + paramName + "]");
                }
                arguments[i] = arg = JavaElementFactory.newArgument(type.getName(), paramName);
            }
            Object[] modifierSplit = modifiers.trim().split("\\s");
            if (log.isDebugEnabled()) {
                log.debug("Modifiers = " + Arrays.toString(modifierSplit));
            }
            int finalModifiers = 0;
            for (Object mod : modifierSplit) {
                if ("public".equals(mod = ((String)mod).trim())) {
                    finalModifiers = 1;
                    break;
                }
                if ("protected".equals(mod)) {
                    finalModifiers = 4;
                    break;
                }
                if (!"private".equals(mod)) continue;
                finalModifiers = 2;
                break;
            }
            if (!((String)bodyContent).endsWith("$initialize();")) {
                bodyContent = (String)bodyContent + JAXXCompiler.getLineSeparator() + "    $initialize();";
            }
            if (log.isDebugEnabled()) {
                log.debug("Final modifier to use : " + Modifier.toString(finalModifiers));
                log.debug("Constructor body :\n" + (String)bodyContent);
            }
            JavaConstructor constructorMethod = JavaElementFactory.newConstructor(finalModifiers, className, (String)bodyContent, arguments);
            ScriptManager.this.compiler.getJavaFile().addConstructor(constructorMethod);
        }
    }
}

