/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.reflect.resolvers;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorResolver;
import org.nuiton.jaxx.compiler.reflect.FieldDescriptor;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;

public class ClassDescriptorResolverFromJavaClass
extends ClassDescriptorResolver {
    private static final Logger log = LogManager.getLogger(ClassDescriptorResolverFromJavaClass.class);

    public ClassDescriptorResolverFromJavaClass() {
        super(ClassDescriptorHelper.ResolverType.JAVA_CLASS);
    }

    @Override
    public ClassDescriptor resolveDescriptor(String className, URL source) throws ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("for source " + className);
        }
        Class<?> javaClass = ClassDescriptorHelper.getClass(className, this.getClassLoader());
        String name = javaClass.getName();
        Package p = javaClass.getPackage();
        String packageName = p != null ? p.getName() : null;
        Class<?> superclass = javaClass.getSuperclass();
        String superclassName = superclass != null ? superclass.getName() : null;
        Class<?>[] interfaces = javaClass.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        boolean isInterface = javaClass.isInterface();
        boolean isArray = javaClass.isArray();
        String componentTypeName = isArray ? javaClass.getComponentType().getName() : null;
        ClassLoader classLoader = javaClass.getClassLoader();
        Constructor<?>[] javaConstructors = javaClass.getConstructors();
        MethodDescriptor[] constructors = new MethodDescriptor[javaConstructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            constructors[i] = ClassDescriptorHelper.createMethodDescriptor(javaConstructors[i], javaClass.getClassLoader());
        }
        Method[] javaMethods = javaClass.getMethods();
        MethodDescriptor[] methods = new MethodDescriptor[javaMethods.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = ClassDescriptorHelper.createMethodDescriptor(javaMethods[i], javaClass.getClassLoader());
        }
        ImmutableSet.Builder fieldsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder declaredFieldsBuilder = ImmutableSet.builder();
        Set<Class<?>> pathFromRoot = this.pathFromRoot(javaClass);
        for (Class<?> aClass : pathFromRoot) {
            fieldsBuilder.addAll(Arrays.asList(aClass.getFields()));
            declaredFieldsBuilder.addAll(Arrays.asList(aClass.getDeclaredFields()));
        }
        ImmutableSet javaFields = fieldsBuilder.build();
        FieldDescriptor[] fields = new FieldDescriptor[javaFields.size()];
        int i = 0;
        for (Field javaField : javaFields) {
            fields[i++] = ClassDescriptorHelper.createFieldDescriptor(javaField, javaClass.getClassLoader());
        }
        ImmutableSet javaDeclaredFields = declaredFieldsBuilder.build();
        FieldDescriptor[] declaredFields = new FieldDescriptor[javaDeclaredFields.size()];
        i = 0;
        for (Field javaDeclaredField : javaDeclaredFields) {
            declaredFields[i++] = ClassDescriptorHelper.createFieldDescriptor(javaDeclaredField, javaClass.getClassLoader());
        }
        JAXXObjectDescriptor jaxxObjectDescriptor = ClassDescriptorHelper.getJAXXObjectDescriptor(javaClass);
        LinkedHashMap<String, String> typeParameters = new LinkedHashMap<String, String>();
        for (TypeVariable<Class<?>> typeParameter : javaClass.getTypeParameters()) {
            typeParameters.put(typeParameter.getName(), typeParameter.getBounds()[0].getTypeName());
        }
        return new JavaClassClassDescriptor(javaClass, typeParameters, name, packageName, superclassName, interfaceNames, isInterface, isArray, componentTypeName, jaxxObjectDescriptor, classLoader, constructors, methods, fields, declaredFields);
    }

    private Set<Class<?>> pathFromRoot(Class<?> type) {
        LinkedList result = new LinkedList();
        while (type != null && type != Object.class) {
            result.add(type);
            type = type.getSuperclass();
        }
        Collections.reverse(result);
        return new LinkedHashSet(result);
    }

    private class JavaClassClassDescriptor
    extends ClassDescriptor {
        private final Class<?> javaClass;
        private final Map<String, String> typeParameters;

        public JavaClassClassDescriptor(Class<?> javaClass, Map<String, String> typeParameters, String name, String packageName, String superclassName, String[] interfaceNames, boolean anInterface, boolean array, String componentTypeName, JAXXObjectDescriptor jaxxObjectDescriptor, ClassLoader classLoader, MethodDescriptor[] constructors, MethodDescriptor[] methods, FieldDescriptor[] fields, FieldDescriptor[] declaredFields) {
            super(ClassDescriptorResolverFromJavaClass.this.getResolverType(), name, packageName, superclassName, interfaceNames, anInterface, array, componentTypeName, jaxxObjectDescriptor, classLoader, constructors, methods, fields, declaredFields);
            this.javaClass = javaClass;
            this.typeParameters = typeParameters;
        }

        @Override
        public Map<String, String> getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
            try {
                Class[] parameterTypeClasses = new Class[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameterTypeClasses[i] = Class.forName(parameterTypes[i].getName());
                }
                return ClassDescriptorHelper.createMethodDescriptor(this.javaClass.getDeclaredMethod(name, parameterTypeClasses), this.javaClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Optional<MethodDescriptor> tryToGetDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) {
            try {
                Class[] parameterTypeClasses = new Class[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameterTypeClasses[i] = Class.forName(parameterTypes[i].getName());
                }
                return Optional.of(ClassDescriptorHelper.createMethodDescriptor(this.javaClass.getDeclaredMethod(name, parameterTypeClasses), this.javaClass.getClassLoader()));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }
}

