/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.binding;

import java.beans.Introspector;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.binding.DataSource;
import org.nuiton.jaxx.compiler.java.parser.JavaParser;
import org.nuiton.jaxx.compiler.java.parser.JavaParserConstants;
import org.nuiton.jaxx.compiler.java.parser.JavaParserTreeConstants;
import org.nuiton.jaxx.compiler.java.parser.SimpleNode;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.FieldDescriptor;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.tags.TagManager;

public class TypeParser {
    private static final Logger log = LogManager.getLogger(TypeParser.class);
    private final JAXXCompiler compiler;

    public TypeParser(JAXXCompiler compiler) {
        this.compiler = compiler;
    }

    public ClassDescriptor parseType(String source) {
        JavaParser p = new JavaParser(new StringReader(source + ";"));
        p.Statement();
        SimpleNode node = p.popNode();
        this.scanNode(node);
        return node.getJavaType();
    }

    private void scanNode(SimpleNode node) throws CompilerException {
        log.trace(node.getText());
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            this.scanNode(node.getChild(i));
        }
        ClassDescriptor type = null;
        if (node.jjtGetNumChildren() == 1) {
            type = node.getChild(0).getJavaType();
        }
        switch (node.getId()) {
            case 31: {
                type = TagManager.resolveClass(node.getText().trim(), this.compiler);
                break;
            }
            case 62: {
                type = this.determineExpressionType(node);
                break;
            }
            case 66: {
                type = TypeParser.determineLiteralType(node);
                break;
            }
            case 71: {
                type = node.getChild(0).getJavaType();
                break;
            }
            case 61: {
                type = TagManager.resolveClass(node.getChild(0).getText(), this.compiler);
                break;
            }
            default: {
                log.trace(String.format("On node type: %d - `%s`", node.getId(), node));
            }
        }
        node.setJavaType(type);
    }

    private ClassDescriptor determineExpressionType(SimpleNode expression) {
        assert (expression.getId() == 62);
        SimpleNode prefix = expression.getChild(0);
        if (log.isDebugEnabled()) {
            log.debug("for expression " + expression.getText() + " - prefix " + prefix + " - nb childrens of prefix: " + prefix.jjtGetNumChildren() + ", nb childrens of expression : " + expression.jjtGetNumChildren());
        }
        if (prefix.jjtGetNumChildren() == 1) {
            int type = prefix.getChild(0).getId();
            if (type == 66 || type == 39) {
                prefix.setJavaType(prefix.getChild(0).getJavaType());
            } else if (type == 37 && expression.jjtGetNumChildren() == 1) {
                ClassDescriptor classDescriptor = this.scanCompoundSymbol(prefix.getText().trim(), this.compiler.getRootObject().getObjectClass(), false);
                log.trace("scanCompoundSymbol result for node " + prefix.getText().trim() + " = " + classDescriptor);
                prefix.setJavaType(classDescriptor);
            } else if (type == 37 && expression.jjtGetNumChildren() == 2) {
                ClassDescriptor classDescriptor = this.scanMethodInvocation(prefix.getText().trim(), this.compiler.getRootObject().getObjectClass(), expression);
                log.trace("scanMethodInvocation result for node " + prefix.getText().trim() + " = " + classDescriptor);
                prefix.setJavaType(classDescriptor);
                return classDescriptor;
            }
        }
        if (expression.jjtGetNumChildren() == 1) {
            return prefix.getJavaType();
        }
        ClassDescriptor contextClass = prefix.getJavaType();
        if (contextClass == null) {
            contextClass = this.compiler.getRootObject().getObjectClass();
        }
        String lastNode = prefix.getText().trim();
        for (int i = 1; i < expression.jjtGetNumChildren(); ++i) {
            SimpleNode suffix;
            block25: {
                suffix = expression.getChild(i);
                if (suffix.jjtGetNumChildren() == 1 && suffix.getChild(0).getId() == 69 && suffix.getChild(0).jjtGetNumChildren() == 0) {
                    contextClass = this.scanCompoundSymbol(lastNode, contextClass, true);
                    if (log.isTraceEnabled()) {
                        log.trace("scanCompoundSymbol result for node " + lastNode + " = " + contextClass);
                    }
                    if (contextClass == null) {
                        return null;
                    }
                    int dotPos = lastNode.lastIndexOf(".");
                    Object code = dotPos == -1 ? "" : lastNode.substring(0, dotPos);
                    for (int j = i - 2; j >= 0; --j) {
                        code = expression.getChild(j).getText() + (String)code;
                    }
                    if (((String)code).length() == 0) {
                        code = this.compiler.getRootObject().getJavaCode();
                    }
                    String methodName = lastNode.substring(dotPos + 1).trim();
                    if (log.isTraceEnabled()) {
                        log.trace("try to find type for method " + methodName + ", code : " + (String)code);
                    }
                    try {
                        MethodDescriptor method = contextClass.getMethodDescriptor(methodName, new ClassDescriptor[0]);
                        log.debug("Will trackMemberIfPossible from method " + method.getName() + " with objectCode = " + (String)code);
                        log.trace("method found = " + method);
                        return this.getMethodReturnType(contextClass, method);
                    }
                    catch (NoSuchMethodException e) {
                        MethodDescriptor newMethod;
                        if (log.isDebugEnabled()) {
                            log.info("Could not find method " + methodName + ", code : " + (String)code + " on : " + contextClass);
                            if (log.isDebugEnabled()) {
                                for (MethodDescriptor descriptor : contextClass.getMethodDescriptors()) {
                                    log.debug(" - " + Modifier.toString(descriptor.getModifiers()) + " " + descriptor.getName() + "(...) : " + descriptor.getReturnType());
                                }
                            }
                        }
                        String propertyName = null;
                        if (methodName.startsWith("is")) {
                            propertyName = Introspector.decapitalize(methodName.substring("is".length()));
                        } else if (methodName.startsWith("get")) {
                            propertyName = Introspector.decapitalize(methodName.substring("get".length()));
                        }
                        if (propertyName == null || (newMethod = this.compiler.getScriptMethod(methodName)) == null) break block25;
                        String bindingId = this.compiler.getRootObject().getId() + "." + propertyName;
                        log.debug("detect a dependency [" + bindingId + "] from a script method " + newMethod.getName() + ", will try to add a listener in method is part of javaBean ...");
                        contextClass = newMethod.getReturnType();
                    }
                }
            }
            if (!(lastNode = suffix.getText().trim()).startsWith(".")) continue;
            lastNode = lastNode.substring(1);
        }
        return null;
    }

    private static ClassDescriptor determineLiteralType(SimpleNode node) {
        assert (node.getId() == 66);
        if (node.jjtGetNumChildren() == 1) {
            int childId = node.getChild(0).getId();
            if (childId == 67) {
                return ClassDescriptorHelper.getClassDescriptor(Boolean.TYPE);
            }
            if (childId == 68) {
                return ClassDescriptorHelper.getClassDescriptor(DataSource.NULL.class);
            }
            throw new RuntimeException("Expected BooleanLiteral or NullLiteral, found " + JavaParserTreeConstants.jjtNodeName[childId]);
        }
        int nodeId = node.firstToken.kind;
        switch (nodeId) {
            case 61: {
                if (node.firstToken.image.toLowerCase().endsWith("l")) {
                    return ClassDescriptorHelper.getClassDescriptor(Long.TYPE);
                }
                return ClassDescriptorHelper.getClassDescriptor(Integer.TYPE);
            }
            case 70: {
                return ClassDescriptorHelper.getClassDescriptor(Character.TYPE);
            }
            case 65: {
                if (node.firstToken.image.toLowerCase().endsWith("f")) {
                    return ClassDescriptorHelper.getClassDescriptor(Float.TYPE);
                }
                return ClassDescriptorHelper.getClassDescriptor(Double.TYPE);
            }
            case 71: {
                return ClassDescriptorHelper.getClassDescriptor(String.class);
            }
        }
        throw new RuntimeException("Expected literal token, found " + JavaParserConstants.tokenImage[nodeId]);
    }

    private ClassDescriptor scanCompoundSymbol(String symbol, ClassDescriptor contextClass, boolean isMethod) {
        Object[] tokens = symbol.split("\\s*\\.\\s*");
        if (log.isDebugEnabled()) {
            log.debug("for symbol " + symbol + ", contextClass " + contextClass + ", isMethod " + isMethod);
            log.debug("tokens " + Arrays.toString(tokens));
        }
        StringBuilder currentSymbol = new StringBuilder();
        StringBuilder tokensSeenSoFar = new StringBuilder();
        boolean recognizeClassNames = true;
        for (int j = 0; j < tokens.length - (isMethod ? 1 : 0); ++j) {
            boolean accepted;
            block17: {
                accepted = false;
                if (tokensSeenSoFar.length() > 0) {
                    tokensSeenSoFar.append('.');
                }
                tokensSeenSoFar.append((String)tokens[j]);
                if (currentSymbol.length() > 0) {
                    currentSymbol.append('.');
                }
                currentSymbol.append((String)tokens[j]);
                if (log.isTraceEnabled()) {
                    log.trace("try to find type for " + currentSymbol);
                }
                if (currentSymbol.indexOf(".") == -1) {
                    String memberName = currentSymbol.toString();
                    try {
                        FieldDescriptor field = contextClass.getFieldDescriptor(memberName);
                        try {
                            contextClass = field.getType();
                        }
                        catch (Exception e) {
                            log.warn("could not find type for field " + field);
                            throw new NoSuchFieldException(e.getMessage());
                        }
                        currentSymbol.setLength(0);
                        accepted = true;
                        recognizeClassNames = false;
                    }
                    catch (NoSuchFieldException e) {
                        FieldDescriptor newField;
                        CompiledObject object = this.compiler.getCompiledObject(memberName);
                        if (object != null) {
                            if (log.isTraceEnabled()) {
                                log.trace("detected an object " + object);
                            }
                            contextClass = object.getObjectClass();
                            currentSymbol.setLength(0);
                            accepted = true;
                            recognizeClassNames = false;
                        }
                        if (j != 0 && (j != 1 || !((String)tokens[0]).equals(this.compiler.getRootObject().getId())) || (newField = this.compiler.getScriptField(memberName)) == null) break block17;
                        contextClass = newField.getType();
                        assert (contextClass != null) : "script field '" + memberName + "' is defined, but has type null";
                        currentSymbol.setLength(0);
                        accepted = true;
                        recognizeClassNames = false;
                    }
                }
            }
            if (currentSymbol.length() > 0 && recognizeClassNames) {
                if (log.isDebugEnabled()) {
                    log.debug("Try to recognizeClassNames for symbol " + currentSymbol);
                }
                if ((contextClass = TagManager.resolveClass(currentSymbol.toString(), this.compiler)) != null) {
                    currentSymbol.setLength(0);
                    accepted = true;
                    recognizeClassNames = false;
                }
            }
            if (accepted) continue;
            if (log.isDebugEnabled()) {
                log.debug("symbol " + symbol + " was not accepted.");
            }
            return null;
        }
        return contextClass;
    }

    private ClassDescriptor scanMethodInvocation(String symbol, ClassDescriptor contextClass, SimpleNode expression) {
        Object[] tokens = symbol.split("\\s*\\.\\s*");
        if (log.isDebugEnabled()) {
            log.debug("for method invocation " + symbol + ", contextClass " + contextClass);
            log.debug("tokens " + Arrays.toString(tokens));
        }
        StringBuilder currentSymbol = new StringBuilder();
        StringBuilder tokensSeenSoFar = new StringBuilder();
        boolean recognizeClassNames = true;
        for (int j = 0; j < tokens.length; ++j) {
            boolean accepted;
            block22: {
                accepted = false;
                if (tokensSeenSoFar.length() > 0) {
                    tokensSeenSoFar.append('.');
                }
                tokensSeenSoFar.append((String)tokens[j]);
                if (currentSymbol.length() > 0) {
                    currentSymbol.append('.');
                }
                currentSymbol.append((String)tokens[j]);
                if (log.isTraceEnabled()) {
                    log.trace("try to find type for " + currentSymbol);
                }
                if (currentSymbol.indexOf(".") == -1) {
                    String memberName = currentSymbol.toString();
                    CompiledObject object = this.compiler.getCompiledObject(memberName);
                    if (object != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("detected an object " + object);
                        }
                        contextClass = object.getObjectClass();
                        currentSymbol.setLength(0);
                        accepted = true;
                        recognizeClassNames = false;
                    } else {
                        try {
                            FieldDescriptor field = contextClass.getFieldDescriptor(memberName);
                            try {
                                contextClass = field.getType();
                            }
                            catch (Exception e) {
                                log.warn("could not find type for field " + field);
                                throw new NoSuchFieldException(e.getMessage());
                            }
                            currentSymbol.setLength(0);
                            accepted = true;
                            recognizeClassNames = false;
                        }
                        catch (NoSuchFieldException e) {
                            FieldDescriptor newField;
                            if (j != 0 && (j != 1 || !((String)tokens[0]).equals(this.compiler.getRootObject().getId())) || (newField = this.compiler.getScriptField(memberName)) == null) break block22;
                            contextClass = newField.getType();
                            assert (contextClass != null) : "script field '" + memberName + "' is defined, but has type null";
                            currentSymbol.setLength(0);
                            accepted = true;
                            recognizeClassNames = false;
                        }
                    }
                }
            }
            if (currentSymbol.length() > 0) {
                if (recognizeClassNames) {
                    if (log.isDebugEnabled()) {
                        log.debug("Try to recognizeClassNames for symbol " + currentSymbol);
                    }
                    if ((contextClass = TagManager.resolveClass(currentSymbol.toString(), this.compiler)) != null) {
                        currentSymbol.setLength(0);
                        accepted = true;
                        recognizeClassNames = false;
                    }
                } else {
                    String methodName = currentSymbol.toString();
                    for (MethodDescriptor methodDescriptor : contextClass.getMethodDescriptors()) {
                        int numChildren;
                        Object[] parameterTypes;
                        if (!methodName.equals(methodDescriptor.getName()) || (parameterTypes = methodDescriptor.getParameterTypes()).length != (numChildren = expression.jjtGetNumChildren()) - 1) continue;
                        Object[] actual = new ClassDescriptor[numChildren - 1];
                        for (int i = 1; i < numChildren; ++i) {
                            actual[i - 1] = expression.getChild(i).getJavaType();
                        }
                        if (!Arrays.equals(parameterTypes, actual)) continue;
                        return this.getMethodReturnType(contextClass, methodDescriptor);
                    }
                }
            }
            if (accepted) continue;
            if (log.isDebugEnabled()) {
                log.debug("symbol " + symbol + " was not accepted.");
            }
            return null;
        }
        return contextClass;
    }

    private ClassDescriptor getMethodReturnType(ClassDescriptor contextClass, MethodDescriptor method) {
        ClassDescriptor returnType = method.getReturnType();
        if (returnType == null && contextClass.equals(this.compiler.getRootObject().getObjectClass()) && (method = this.compiler.getScriptMethod(method.getName())) != null) {
            returnType = method.getReturnType();
        }
        return returnType;
    }
}

