/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jaxx.compiler.BeanScope;
import org.nuiton.jaxx.compiler.CompiledObjectDecorator;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.EventHandler;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.tags.DefaultComponentHandler;
import org.nuiton.jaxx.compiler.tags.DefaultObjectHandler;
import org.nuiton.jaxx.compiler.tags.TagManager;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.JAXXUtil;

public class CompiledObject {
    private final String id;
    private final String javaCode;
    private final ClassDescriptor objectClass;
    private String styleClass;
    private Set<String> styleClasses;
    private CompiledObject parent;
    private boolean override;
    private boolean forceOverride;
    private String simpleType;
    private String constructorParams;
    private final StringBuilder initializationCode = new StringBuilder();
    private StringBuilder additionCode = new StringBuilder();
    private final List<EventHandler> eventHandlers = new ArrayList<EventHandler>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private String[] genericTypes;
    private boolean javaBean;
    private String javaBeanInitCode;
    private ClassDescriptor overrideType;
    private CompiledObjectDecorator decorator;
    private Map<String, String> clientProperties;
    private String initializer;
    private String i18nProperty;
    private BeanScope beanScope;
    private boolean addToContainer;
    private List<ChildRef> childs;

    public String getSimpleType() {
        return this.simpleType;
    }

    public Optional<BeanScope> getBeanScope() {
        return Optional.ofNullable(this.beanScope);
    }

    public void setBeanScope(BeanScope beanScope) {
        this.beanScope = Objects.requireNonNull(beanScope);
    }

    public void setAddToContainer(boolean addToContainer) {
        this.addToContainer = addToContainer;
    }

    public boolean isAddToContainer() {
        return this.addToContainer;
    }

    public CompiledObject(String id, ClassDescriptor objectClass, JAXXCompiler compiler) {
        this(id, objectClass, compiler, false);
    }

    public CompiledObject(String id, ClassDescriptor objectClass, JAXXCompiler compiler, boolean force) {
        this(id, id, objectClass, compiler, force);
    }

    public CompiledObject(String id, String javaCode, ClassDescriptor objectClass, JAXXCompiler compiler, boolean force) throws CompilerException {
        if (!force && !CompiledObject.isValidID(id)) {
            compiler.reportError("the id '" + id + "' is not a valid Java identifier");
        }
        this.id = id;
        this.javaCode = javaCode;
        if (objectClass == null) {
            throw new NullPointerException();
        }
        this.objectClass = objectClass;
        this.childs = new ArrayList<ChildRef>();
    }

    public static boolean isValidID(String id) {
        boolean valid = true;
        if (id.length() == 0) {
            valid = false;
        }
        if (valid) {
            if (!Character.isJavaIdentifierStart(id.charAt(0))) {
                valid = false;
            }
            if (valid) {
                for (int i = 1; i < id.length(); ++i) {
                    if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
                    valid = false;
                    break;
                }
            }
        }
        return valid;
    }

    public boolean isOverride() {
        return this.override;
    }

    public boolean isForceOverride() {
        return this.forceOverride;
    }

    public void setForceOverride(boolean forceOverride) {
        this.forceOverride = forceOverride;
    }

    public boolean isOverrideType() {
        return this.isOverride() && !this.getObjectClass().equals(this.getOverrideType());
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public void setSimpleType(String simpleType) {
        this.simpleType = simpleType;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public Set<String> getStyleClasses() {
        return this.styleClasses == null ? (this.styleClasses = this.styleClass == null ? Set.of() : new LinkedHashSet<String>(Arrays.asList(this.styleClass.trim().split("\\s")))) : this.styleClasses;
    }

    public boolean matchStyleClass(String styleClass) {
        return styleClass == null || this.getStyleClasses().contains(styleClass);
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
        this.styleClasses = null;
    }

    public CompiledObject getParent() {
        return this.parent;
    }

    public void setParent(CompiledObject parent) throws IllegalArgumentException {
        if (!ClassDescriptorHelper.getClassDescriptor(Container.class).isAssignableFrom(parent.getObjectClass())) {
            throw new IllegalArgumentException("parent must descend from java.awt.Container");
        }
        this.parent = parent;
    }

    public String getCreationMethodName() {
        return "create" + StringUtils.capitalize((String)this.getId());
    }

    public String getAdditionMethodName() {
        return "addChildrenTo" + StringUtils.capitalize((String)this.getId());
    }

    public ClassDescriptor getObjectClass() {
        return this.objectClass;
    }

    public String getId() {
        return this.id;
    }

    public String getJavaCode() {
        Object result = this.javaCode;
        if (this.isOverride()) {
            result = this.simpleType == null ? this.javaCode : "((" + this.simpleType + ") " + this.javaCode + ")";
        }
        return result;
    }

    public String getJavaCodeForProperty(String property) {
        if (!this.isOverride() || this.simpleType == null) {
            return this.javaCode;
        }
        Object result = "((" + this.simpleType + ") " + this.javaCode + ")";
        String methodName = StringUtils.capitalize((String)property);
        try {
            MethodDescriptor methodDescriptor = this.overrideType.getMethodDescriptor("get" + methodName, new ClassDescriptor[0]);
            if (methodDescriptor != null && this.overrideType.getMethodDescriptor("set" + methodName, methodDescriptor.getReturnType()) != null) {
                result = this.javaCode;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    public String getConstructorParams() {
        return this.constructorParams;
    }

    public void setConstructorParams(String constructorParams) {
        this.constructorParams = constructorParams;
    }

    public String getInitializer() {
        return this.initializer;
    }

    public void setInitializer(String initializer) {
        this.initializer = initializer;
    }

    public String getInitializationCode(JAXXCompiler compiler) {
        StringBuilder result = new StringBuilder(this.initializationCode.toString());
        Iterator<EventHandler> iterator = this.eventHandlers.iterator();
        while (iterator.hasNext()) {
            EventHandler eventHandler;
            EventHandler handler = eventHandler = iterator.next();
            result.append(this.getInitializationCode(handler, compiler));
        }
        return result.toString();
    }

    protected String getInitializationCode(EventHandler handler, JAXXCompiler compiler) {
        MethodDescriptor addMethod = handler.getAddMethod();
        ClassDescriptor listenerClass = addMethod.getParameterTypes()[0];
        String type = compiler.getImportedType(listenerClass.getName());
        String prefix = compiler.getImportedType(JAXXUtil.class);
        return this.getJavaCode() + "." + addMethod.getName() + "(" + prefix + ".getEventListener(" + type + ".class, " + TypeManager.getJavaCode(handler.getListenerMethod().getName()) + ", this, " + TypeManager.getJavaCode(compiler.getEventHandlerMethodName(handler)) + "));" + JAXXCompiler.getLineSeparator();
    }

    public String getAdditionCode() {
        return this.additionCode.toString();
    }

    public void appendInitializationCode(String code) {
        if (!code.isEmpty()) {
            this.initializationCode.append(code);
            this.initializationCode.append(JAXXCompiler.getLineSeparator());
        }
    }

    public void appendAdditionCode(String code) {
        if (!code.isEmpty()) {
            this.additionCode.append(code);
            this.additionCode.append(JAXXCompiler.getLineSeparator());
        }
    }

    public void addProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public boolean hasClientProperties() {
        return this.clientProperties != null && !this.clientProperties.isEmpty();
    }

    public void addClientProperty(String property, String value) {
        this.getClientProperties().put(property, value);
    }

    public String getClientProperty(String key) {
        if (!this.hasClientProperties()) {
            return null;
        }
        return this.clientProperties.get(key);
    }

    public Map<String, String> getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new HashMap<String, String>();
        }
        return this.clientProperties;
    }

    public Map<?, ?> getProperties() {
        return this.properties;
    }

    public void addEventHandler(String eventId, MethodDescriptor addMethod, MethodDescriptor listenerMethod, String code, JAXXCompiler compiler) {
        EventHandler handler = new EventHandler(this.getId() + "." + eventId, this.getJavaCode(), addMethod, addMethod.getParameterTypes()[0], listenerMethod, code);
        compiler.registerEventHandler(handler);
        this.eventHandlers.add(handler);
        if (this.getJavaCode().contains(".")) {
            compiler.appendInitializerCode(this.getInitializationCode(handler, compiler));
        }
    }

    public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
        DefaultComponentHandler tagHandler = null;
        if (!child.isOverride() || child.isAddToContainer()) {
            DefaultObjectHandler tagHandler1 = TagManager.getTagHandler(this.getObjectClass());
            if (!(tagHandler1 instanceof DefaultComponentHandler)) {
                compiler.reportError("component parent " + tagHandler1 + " is not a component");
                return;
            }
            tagHandler = (DefaultComponentHandler)tagHandler1;
            if (!tagHandler.isContainer()) {
                compiler.reportError("component " + this + " may not have children");
                return;
            }
        }
        this.addChild(child, constraints, compiler, tagHandler);
    }

    public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler, DefaultComponentHandler tagHandler) throws CompilerException {
        try {
            if (constraints != null) {
                constraints = compiler.checkJavaCode(constraints);
            }
        }
        catch (CompilerException e) {
            compiler.reportError("While parsing 'constraints' attribute: " + e.getMessage());
        }
        if (!child.isOverride() || child.isAddToContainer()) {
            String containerDelegate = tagHandler.getContainerDelegate();
            Object delegateCode = containerDelegate != null ? "." + containerDelegate + "()" : "";
            child.setParent(this);
            ChildRef ref = this.newChildRef(child, constraints, (String)delegateCode);
            this.childs.add(ref);
        }
    }

    protected ChildRef newChildRef(CompiledObject child, String constraints, String delegateCode) {
        return new ChildRef(child, constraints, child.getJavaCode(), delegateCode);
    }

    public String toString() {
        return this.getObjectClass().getName() + "[id='" + this.id + "']";
    }

    public String getGenericTypes() {
        if (this.getGenericTypesLength() == 0) {
            return "";
        }
        Object result = "";
        int j = this.getGenericTypesLength();
        for (int i = 0; i < j; ++i) {
            result = (String)result + ", " + this.genericTypes[i];
        }
        return "< " + ((String)result).substring(2) + " >";
    }

    public void setGenericTypes(String ... genericTypes) {
        if (genericTypes == null) {
            this.genericTypes = null;
            return;
        }
        this.genericTypes = new String[genericTypes.length];
        int j = genericTypes.length;
        for (int i = 0; i < j; ++i) {
            this.genericTypes[i] = genericTypes[i].trim();
        }
    }

    public boolean isJavaBean() {
        return this.javaBean;
    }

    public void setJavaBean(boolean javaBean) {
        this.javaBean = javaBean;
    }

    public ClassDescriptor getOverrideType() {
        return this.overrideType;
    }

    public void setOverrideType(ClassDescriptor overrideType) {
        this.overrideType = overrideType;
    }

    public String getJavaBeanInitCode() {
        return this.javaBeanInitCode;
    }

    public void setJavaBeanInitCode(String javaBeanInitCode) {
        this.javaBeanInitCode = javaBeanInitCode;
    }

    public List<ChildRef> getChilds() {
        return this.childs;
    }

    public CompiledObjectDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(CompiledObjectDecorator decorator) {
        this.decorator = decorator;
    }

    public void finalizeCompiler(JAXXCompiler compiler) {
        List<ChildRef> refList = this.getChilds();
        StringBuilder buffer = new StringBuilder();
        if (this.isForceOverride()) {
            buffer.append(String.format("super.%s();%s", this.getAdditionMethodName(), JAXXCompiler.getLineSeparator()));
        }
        if (refList != null && !refList.isEmpty()) {
            for (ChildRef childRef : refList) {
                childRef.addToAdditionCode(buffer, this.equals(compiler.getRootObject()));
            }
            this.additionCode = buffer.append((CharSequence)this.additionCode);
        }
    }

    public int getGenericTypesLength() {
        return this.genericTypes == null ? 0 : this.genericTypes.length;
    }

    public String getGetterName() {
        return "get" + StringUtils.capitalize((String)this.id);
    }

    public String getSetterName() {
        return "set" + StringUtils.capitalize((String)this.id);
    }

    public boolean isUseComputeI18n() {
        return this.i18nProperty != null && !"skip".equals(this.i18nProperty);
    }

    public String getI18nProperty() {
        return this.i18nProperty;
    }

    public void setI18nProperty(String i18nProperty) {
        this.i18nProperty = i18nProperty;
    }

    public class ChildRef {
        final CompiledObject child;
        final String constraints;
        String childJavaCode;
        private final String delegateCode;

        public ChildRef(CompiledObject child, String constraints, String childJavaCode, String delegateCode) {
            this.child = child;
            this.constraints = constraints;
            this.childJavaCode = childJavaCode;
            this.delegateCode = delegateCode;
        }

        public String getConstraints() {
            return this.constraints;
        }

        public String getDelegateCode() {
            return this.delegateCode;
        }

        public CompiledObject getChild() {
            return this.child;
        }

        public String getChildJavaCode() {
            return this.childJavaCode;
        }

        public void setChildJavaCode(String childJavaCode) {
            this.childJavaCode = childJavaCode;
        }

        public void addToAdditionCode(StringBuilder buffer, boolean isRootObject) {
            Object prefix = isRootObject ? "" : CompiledObject.this.javaCode + this.delegateCode + ".";
            if (this.constraints != null) {
                buffer.append((String)prefix);
                buffer.append("add(");
                buffer.append(this.childJavaCode);
                buffer.append(", ");
                buffer.append(this.constraints);
                buffer.append(");");
            } else {
                buffer.append((String)prefix);
                buffer.append("add(");
                buffer.append(this.childJavaCode);
                buffer.append(");");
            }
            buffer.append(JAXXCompiler.getLineSeparator());
        }
    }
}

