/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;

public class ClassMap<T>
extends HashMap<ClassDescriptor, T> {
    private static final long serialVersionUID = 5149779660675529037L;
    protected static final Logger log = LogManager.getLogger(ClassMap.class);
    private final List<ClassDescriptor> autoKeys = new ArrayList<ClassDescriptor>();

    @Override
    public T get(Object key) {
        ClassDescriptor c;
        T result = null;
        for (c = (ClassDescriptor)key; c != null && (result = (T)super.get(c)) == null; c = c.getSuperclass()) {
        }
        if (result == null && ((ClassDescriptor)key).isInterface()) {
            result = this.get(ClassDescriptorHelper.getClassDescriptor(Object.class));
        }
        if (c != key && result != null) {
            this.put((ClassDescriptor)key, result);
            this.autoKeys.add((ClassDescriptor)key);
        }
        return result;
    }

    @Override
    public T put(ClassDescriptor key, T value) {
        if (this.autoKeys.size() > 0) {
            Iterator<ClassDescriptor> i = this.autoKeys.iterator();
            while (i.hasNext()) {
                ClassDescriptor auto = i.next();
                if (!key.isAssignableFrom(auto)) continue;
                i.remove();
                this.remove(auto);
            }
        }
        return super.put(key, value);
    }
}

