/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tasks;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXEngine;
import org.nuiton.jaxx.compiler.tasks.JAXXEngineTask;

public class StyleSheetTask
extends JAXXEngineTask {
    private static final Logger log = LogManager.getLogger(StyleSheetTask.class);
    public static final String TASK_NAME = "StyleSheet";

    public StyleSheetTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) {
        JAXXCompilerFile[] files;
        this.checkAllFilesCompiled(engine);
        boolean success = true;
        boolean isVerbose = engine.getConfiguration().isVerbose();
        for (JAXXCompilerFile jaxxFile : files = engine.getCompiledFiles()) {
            String className = jaxxFile.getClassName();
            if (isVerbose) {
                log.info("start " + className);
            }
            JAXXCompiler compiler = jaxxFile.getCompiler();
            this.addStartProfileTime(engine, compiler);
            compiler.applyStylesheets();
            this.addEndProfileTime(engine, compiler);
            if (!compiler.isFailed()) continue;
            success = false;
        }
        return success;
    }
}

