/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import java.awt.event.ContainerListener;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.DefaultComponentHandler;
import org.nuiton.jaxx.runtime.swing.TabInfo;

public class JTabbedPaneHandler
extends DefaultComponentHandler {
    public JTabbedPaneHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, JTabbedPane.class);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledTabbedPane(id, this.getBeanClass(), compiler);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("getSelectedIndex", ChangeListener.class);
        this.addProxyEventInfo("getSelectedComponent", ChangeListener.class);
        this.addProxyEventInfo("getTabCount", ContainerListener.class);
    }

    public class CompiledTabbedPane
    extends CompiledObject {
        int tabCount;
        TabInfo tabInfo;

        public CompiledTabbedPane(String id, ClassDescriptor objectClass, JAXXCompiler compiler) throws CompilerException {
            super(id, objectClass, compiler);
        }

        @Override
        public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
            if (constraints != null) {
                compiler.reportError("JTabbedPane tabs may not have constraints");
            }
            super.addChild(child, constraints, compiler, JTabbedPaneHandler.this);
            if (this.tabInfo == null) {
                compiler.reportError("JTabbedPaneHandler may only have 'tab' tags as children (found " + child.getObjectClass() + ")");
                return;
            }
            int tabIndex = ++this.tabCount - 1;
            this.appendAdditionCode(String.format("%s.install(%s, %d);", this.tabInfo.getId(), this.getId(), tabIndex));
            this.tabInfo = null;
        }
    }
}

