/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.I18nHelper;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.DefaultObjectHandler;
import org.nuiton.jaxx.compiler.tags.swing.JTabbedPaneHandler;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import org.nuiton.jaxx.validator.swing.tab.TabInfoWithValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TabWithValidatorHandler
extends DefaultObjectHandler {
    public static final String TAG_NAME = "tabWithValidator";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_TITLE = "title";
    public static final String ATTRIBUTE_TOOL_TIP_TEXT = "toolTipText";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_ENABLED = "enabled";
    public static final String ATTRIBUTE_DISABLED_ICON = "disabledIcon";
    public static final String ATTRIBUTE_MNEMONIC = "mnemonic";
    public static final String ATTRIBUTE_DISPLAYED_MNEMONIC_INDEX = "displayedMnemonicIndex";
    public static final String ATTRIBUTE_FOREGROUND = "foreground";
    public static final String ATTRIBUTE_BACKGROUND = "background";
    public static final String ATTRIBUTE_TAB_COMPONENT = "tabComponent";
    public static final String ATTRIBUTE_VALIDATOR_ID = "validatorId";
    protected static final Map<JAXXCompiler, List<TabInfoWithValidator>> tabs = new HashMap<JAXXCompiler, List<TabInfoWithValidator>>();

    public TabWithValidatorHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, TabInfoWithValidator.class);
    }

    public static void setAttribute(CompiledObject compiledTabInfo, TabInfoWithValidator tabInfo, String name, String value, JAXXCompiler compiler) throws CompilerException {
        value = value.trim();
        String id = tabInfo.getId();
        String binding = compiler.processDataBindings(value);
        if (binding != null) {
            compiler.getBindingHelper().registerDataBinding(id + "." + name, binding, id + ".set" + StringUtils.capitalize((String)name) + "(" + binding + ");");
            return;
        }
        String valueCode = TypeManager.getJavaCode(value);
        if (name.equals("i18nProperty")) {
            if ("skip".equals(value)) {
                return;
            }
            compiledTabInfo.setI18nProperty(StringUtils.isEmpty((CharSequence)value) ? id : value);
            String i18nKey = compiler.computeI18nProperty(compiledTabInfo);
            String i18nProperty = compiler.getI18nProperty(compiledTabInfo);
            TabWithValidatorHandler.setAttribute(compiledTabInfo, tabInfo, i18nProperty, i18nKey, compiler);
            return;
        }
        if (I18nHelper.isI18nableAttribute(name, compiler)) {
            value = valueCode = I18nHelper.addI18nInvocation(id, name, valueCode, compiler);
        }
        if (!name.equals(ATTRIBUTE_ID)) {
            if (name.equals(ATTRIBUTE_TITLE)) {
                tabInfo.setTitle(value);
                compiledTabInfo.appendInitializationCode(id + ".setTitle(" + valueCode + ");");
            } else if (name.equals(ATTRIBUTE_TOOL_TIP_TEXT)) {
                tabInfo.setToolTipText(value);
                compiledTabInfo.appendInitializationCode(id + ".setToolTipText(" + valueCode + ");");
            } else if (name.equals(ATTRIBUTE_ICON)) {
                Icon icon = (Icon)TypeManager.convertFromString(value, Icon.class);
                tabInfo.setIcon(icon);
                compiledTabInfo.appendInitializationCode(id + ".setIcon(" + TypeManager.getJavaCode(icon) + ");");
            } else if (name.equals(ATTRIBUTE_ENABLED)) {
                boolean enabled = (Boolean)TypeManager.convertFromString(value, Boolean.class);
                tabInfo.setEnabled(enabled);
                compiledTabInfo.appendInitializationCode(id + ".setEnabled(" + enabled + ");");
            } else if (name.equals(ATTRIBUTE_DISABLED_ICON)) {
                Icon disabledIcon = (Icon)TypeManager.convertFromString(value, Icon.class);
                tabInfo.setDisabledIcon(disabledIcon);
                compiledTabInfo.appendInitializationCode(id + ".setDisabledIcon(" + TypeManager.getJavaCode(disabledIcon) + ");");
            } else if (name.equals(ATTRIBUTE_MNEMONIC)) {
                char mnemonic = ((Character)TypeManager.convertFromString(value, Character.TYPE)).charValue();
                tabInfo.setMnemonic((int)mnemonic);
                compiledTabInfo.appendInitializationCode(id + ".setMnemonic(" + mnemonic + ");");
            } else if (name.equals(ATTRIBUTE_DISPLAYED_MNEMONIC_INDEX)) {
                int displayedMnemonicIndex = (Integer)TypeManager.convertFromString(value, Integer.TYPE);
                tabInfo.setDisplayedMnemonicIndex(displayedMnemonicIndex);
                compiledTabInfo.appendInitializationCode(id + ".setDisplayedMnemonicIndex(" + displayedMnemonicIndex + ");");
            } else if (name.equals(ATTRIBUTE_FOREGROUND)) {
                Color foreground = (Color)TypeManager.convertFromString(value, Color.class);
                tabInfo.setForeground(foreground);
                compiledTabInfo.appendInitializationCode(id + ".setForeground(" + TypeManager.getJavaCode(foreground) + ");");
            } else if (name.equals(ATTRIBUTE_BACKGROUND)) {
                Color background = (Color)TypeManager.convertFromString(value, Color.class);
                tabInfo.setBackground(background);
                compiledTabInfo.appendInitializationCode(id + ".setBackground(" + TypeManager.getJavaCode(background) + ");");
            } else if (name.equals(ATTRIBUTE_TAB_COMPONENT)) {
                tabInfo.setTabComponentStr(TypeManager.getJavaCode(value));
                compiledTabInfo.appendInitializationCode(id + ".setTabComponent(" + TypeManager.getJavaCode(value) + ");");
            } else if (name.equals(ATTRIBUTE_VALIDATOR_ID)) {
                tabInfo.setValidatorId(value);
                compiledTabInfo.appendInitializationCode(id + ".setValidatorId(\"" + value + "\");");
            } else {
                compiler.reportError("The <tabWithValidator> tag does not support the attribute '" + name + "'");
            }
        }
    }

    public static List<TabInfoWithValidator> getTabs(JAXXCompiler compiler) {
        return tabs.getOrDefault(compiler, Collections.emptyList());
    }

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    protected CompiledObject createCompiledObject(String id, JAXXCompiler compiler) {
        return new CompiledObject(id, this.getBeanClass(), compiler){

            @Override
            public void finalizeCompiler(JAXXCompiler compiler) {
                TabInfoWithValidator tabInfo = Objects.requireNonNull(TabWithValidatorHandler.this.getTabInfoWithValidator(this, compiler));
                if (tabInfo.getValidatorId() == null) {
                    compiler.reportError("tabWithValidator " + this.getId() + "requires a validatorId value");
                }
                super.finalizeCompiler(compiler);
            }
        };
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (!ClassDescriptorHelper.getClassDescriptor(JTabbedPane.class).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError("tab tag may only appear within JTabbedPane tag");
            return;
        }
        JTabbedPaneHandler.CompiledTabbedPane tabs = (JTabbedPaneHandler.CompiledTabbedPane)compiler.getOpenComponent();
        CompiledObject compiledTabInfo = (CompiledObject)objectMap.get(tag);
        String id = tag.getAttribute(ATTRIBUTE_ID);
        if (id == null || id.length() == 0) {
            id = compiler.getAutoId(TabInfo.class.getSimpleName());
        }
        TabInfoWithValidator tabInfo = new TabInfoWithValidator(id);
        compiledTabInfo.setConstructorParams("\"" + id + "\"");
        compiler.appendLateInitializer(id + ".init(this, " + tabs.getId() + ");" + JAXXCompiler.getLineSeparator());
        List list = TabWithValidatorHandler.tabs.getOrDefault(compiler, new LinkedList());
        list.add(tabInfo);
        TabWithValidatorHandler.tabs.put(compiler, list);
        this.setAttributes(compiledTabInfo, (TabInfo)tabInfo, tag, compiler);
        this.compileChildrenSecondPass(tag, compiler);
    }

    @Override
    public void setAttribute(CompiledObject object, String propertyName, String stringValue, boolean inline, JAXXCompiler compiler) {
        TabInfoWithValidator tabInfo = this.getTabInfoWithValidator(object, compiler);
        if (tabInfo == null) {
            return;
        }
        TabWithValidatorHandler.setAttribute(object, tabInfo, propertyName, stringValue, compiler);
    }

    private TabInfoWithValidator getTabInfoWithValidator(CompiledObject object, JAXXCompiler compiler) {
        List<TabInfoWithValidator> list = tabs.get(compiler);
        TabInfoWithValidator tabInfo = null;
        for (TabInfoWithValidator tabInfoWithValidator : list) {
            if (!object.getId().equals(tabInfoWithValidator.getId())) continue;
            tabInfo = tabInfoWithValidator;
            break;
        }
        if (tabInfo == null) {
            compiler.reportError("Can't find tabInfoWithValidator with id: " + object.getId());
            return null;
        }
        return tabInfo;
    }

    public void setAttributes(CompiledObject compiledTabInfo, TabInfo tabInfo, Element tag, JAXXCompiler compiler) throws CompilerException {
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            Attr attribute = (Attr)children.item(i);
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            TabWithValidatorHandler.setAttribute(compiledTabInfo, (TabInfoWithValidator)tabInfo, name, value, compiler);
        }
    }

    @Override
    protected void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagFirstPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    @Override
    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    @Override
    protected void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    @Override
    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }
}

