/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.finalizers;

import com.google.auto.service.AutoService;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.finalizers.AbstractFinalizer;
import org.nuiton.jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.JavaField;
import org.nuiton.jaxx.compiler.java.JavaFile;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.tags.swing.TabWithValidatorHandler;
import org.nuiton.jaxx.compiler.tags.validator.BeanValidatorHandler;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.ValidatorField;
import org.nuiton.jaxx.validator.swing.tab.TabInfoWithValidator;

@Component(hint="validators", role=JAXXCompilerFinalizer.class)
@AutoService(value={JAXXCompilerFinalizer.class})
public class ValidatorFinalizer
extends AbstractFinalizer {
    protected static final JavaField VALIDATOR_IDS_FIELD = JavaElementFactory.newField(4, List.class.getName() + "<String>", "validatorIds", true);
    protected static final JavaField VALIDATOR_EDITORS_FIELD = JavaElementFactory.newField(4, String.format("%s<%s, %s>", ArrayListMultimap.class.getName(), JComponent.class.getName(), ValidatorField.class.getName()), "validatorEditors", true);

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return BeanValidatorHandler.hasValidator(compiler);
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        for (CompiledObject object : compiler.getObjects().values()) {
            List<CompiledObject.ChildRef> children = object.getChilds();
            if (children == null || children.isEmpty()) continue;
            for (CompiledObject.ChildRef child : children) {
                boolean found = BeanValidatorHandler.isComponentUsedByValidator(compiler, child.getChild().getId());
                if (!found) continue;
                String type = compiler.getImportedType(SwingUtil.class);
                String javaCode = child.getChildJavaCode();
                child.setChildJavaCode((String)type + ".boxComponentWithJxLayer(" + javaCode + ")");
            }
        }
        String eol = JAXXCompiler.getLineSeparator();
        List<BeanValidatorHandler.CompiledBeanValidator> validators = BeanValidatorHandler.getValidators(compiler);
        StringBuilder createValidatorEditorsContent = new StringBuilder();
        compiler.addImport(LinkedList.class);
        createValidatorEditorsContent.append("ArrayListMultimap<JComponent, ValidatorField> editors = ArrayListMultimap.create();").append(eol);
        String fieldType = compiler.getImportedType(ValidatorField.class);
        int fieldCount = 0;
        LinkedList<String> validatorIds = new LinkedList<String>();
        for (BeanValidatorHandler.CompiledBeanValidator validator : validators) {
            String validatorId = TypeManager.getJavaCode(validator.getId());
            validatorIds.add(validatorId);
            fieldCount += this.registerValidatorFields(validator, compiler, validatorId, fieldType, createValidatorEditorsContent, eol);
        }
        createValidatorEditorsContent.append("return editors;");
        javaFile.addMethod(JavaElementFactory.newMethod(1, "ArrayListMultimap<JComponent, ValidatorField>", "createValidatorEditors", createValidatorEditorsContent.toString(), true, new JavaArgument[0]));
        StringBuilder builder = new StringBuilder();
        builder.append(eol).append("// register ").append(validatorIds.size()).append(" validator(s)").append(eol);
        builder.append("validatorIds = List.of(").append(Joiner.on((String)", ").join(validatorIds)).append(");").append(eol);
        builder.append("// register ").append(fieldCount).append(" validator fields(s)").append(eol);
        builder.append("validatorEditors = createValidatorEditors();").append(eol);
        builder.append("installValidationUI();").append(eol);
        List<TabInfoWithValidator> tabs = TabWithValidatorHandler.getTabs(compiler);
        if (!tabs.isEmpty()) {
            for (TabInfoWithValidator tab : tabs) {
                builder.append("installTabUI(this, ").append(tab.getId()).append(");").append(eol);
            }
        }
        compiler.appendLateInitializer(builder.toString());
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        ClassDescriptor validatorClass = compiler.getEngine().getValidatorFactoryClass();
        Class<JAXXValidator> validatorInterface = JAXXValidator.class;
        boolean parentIsValidator = compiler.isSuperClassAware(validatorInterface);
        if (!parentIsValidator) {
            javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface));
        }
        this.addField(javaFile, VALIDATOR_IDS_FIELD);
        this.addField(javaFile, VALIDATOR_EDITORS_FIELD);
        String type = compiler.getImportedType(validatorClass.getName());
        String initializer = String.format("return (%s<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);", type);
        javaFile.addMethod(JavaElementFactory.newMethod(1, type + "<?>", "getValidator", initializer, true, JavaElementFactory.newArgument("String", "validatorId")));
    }

    public int registerValidatorFields(BeanValidatorHandler.CompiledBeanValidator validator, JAXXCompiler compiler, String validatorId, String fieldType, StringBuilder createValidatorEditorsContent, String eol) {
        int fieldCount = 0;
        for (String component : validator.getFieldEditors()) {
            Collection<String> propertyNames = validator.getFieldPropertyNames(component);
            ArrayList<String> keyCodes = new ArrayList<String>(propertyNames.size());
            for (String propertyName : propertyNames) {
                if (!validator.checkBeanProperty(compiler, propertyName)) continue;
                String keyCode = TypeManager.getJavaCode(propertyName);
                keyCodes.add(keyCode);
            }
            if (keyCodes.isEmpty()) continue;
            String keyCode = Joiner.on((String)", ").join(keyCodes);
            String editorCode = TypeManager.getJavaCode(component);
            String editorGetter = "get" + StringUtils.capitalize((String)component);
            String annotation = String.format("new %s( %s,  %s,  %s)", fieldType, validatorId, editorCode, keyCode);
            createValidatorEditorsContent.append(String.format("editors.put(%s(), %s);", editorGetter, annotation)).append(eol);
            ++fieldCount;
        }
        return fieldCount;
    }
}

