/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.ClassMap;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.DefaultObjectHandler;
import org.nuiton.jaxx.compiler.tags.TagHandler;

public class TagManager {
    protected static final Logger log = LogManager.getLogger(TagManager.class);
    private static final Map<String, String> defaultNamespaces = new HashMap<String, String>();
    private static final Map<QName, TagHandler> registeredTags = new HashMap<QName, TagHandler>();
    private static final Map<String, Boolean> classExistenceCache = new HashMap<String, Boolean>();
    private static final ClassMap<Class<? extends TagHandler>> registeredBeans = new ClassMap();

    private TagManager() {
    }

    public static void reset() {
        registeredBeans.clear();
        registeredTags.clear();
        defaultNamespaces.clear();
    }

    public static <T extends TagHandler> void registerBean(ClassDescriptor beanClass, Class<T> handler) {
        if (!DefaultObjectHandler.class.isAssignableFrom(handler)) {
            throw new IllegalArgumentException("handler class must be a subclass of DefaultObjectHandler");
        }
        registeredBeans.put(beanClass, handler);
        if (log.isDebugEnabled()) {
            log.debug(beanClass + " : " + handler);
        }
        String name = beanClass.getName();
        int dotPos = name.lastIndexOf(".");
        String namespace = name.substring(0, dotPos + 1) + "*";
        name = name.substring(dotPos + 1);
        TagManager.registerDefaultNamespace(name, namespace);
    }

    public static void registerDefaultNamespace(String tag, String namespace) {
        if (defaultNamespaces.containsKey(tag) && !namespace.equals(defaultNamespaces.get(tag))) {
            defaultNamespaces.put(tag, null);
        } else {
            defaultNamespaces.put(tag, namespace);
        }
    }

    public static <T extends TagHandler> void registerTag(String namespace, String tag, T handler) {
        if (namespace == null) {
            namespace = "*";
        }
        if (log.isDebugEnabled()) {
            log.debug(tag + " : " + handler);
        }
        registeredTags.put(new QName(namespace, tag), handler);
        TagManager.registerDefaultNamespace(tag, namespace);
    }

    public static TagHandler getTagHandler(String namespace, String tag, JAXXCompiler compiler) throws CompilerException {
        return TagManager.getTagHandler(namespace, tag, false, compiler);
    }

    private static String getNamespace(ClassDescriptor beanClass) {
        String packageName = beanClass.getPackageName();
        return packageName != null ? packageName + ".*" : "*";
    }

    private static String getSimpleName(ClassDescriptor beanClass) {
        String packageName = beanClass.getPackageName();
        if (packageName != null) {
            assert (beanClass.getName().startsWith(packageName));
            return beanClass.getName().substring(packageName.length() + 1);
        }
        return beanClass.getName();
    }

    public static DefaultObjectHandler getTagHandler(Class<?> klass) throws CompilerException {
        ClassDescriptor beanClass = ClassDescriptorHelper.getClassDescriptor(klass);
        return TagManager.getTagHandler(beanClass);
    }

    public static DefaultObjectHandler getTagHandler(ClassDescriptor beanClass) throws CompilerException {
        try {
            String tag;
            if (beanClass == null) {
                throw new NullPointerException("beanClass parameter can not be null");
            }
            if (beanClass.getName() == null) {
                throw new NullPointerException("beanClass name can not be null : " + beanClass);
            }
            String namespace = TagManager.getNamespace(beanClass);
            DefaultObjectHandler handler = (DefaultObjectHandler)registeredTags.get(new QName(namespace, tag = TagManager.getSimpleName(beanClass)));
            if (handler == null) {
                Class<? extends TagHandler> handlerClass = registeredBeans.get(beanClass);
                if (handlerClass == null) {
                    if (beanClass.isInterface()) {
                        return null;
                    }
                    throw new CompilerException("unable to find handler for " + beanClass);
                }
                Constructor<? extends TagHandler> constructor = handlerClass.getConstructor(ClassDescriptor.class);
                handler = (DefaultObjectHandler)constructor.newInstance(beanClass);
                TagManager.registerTag(namespace, tag, handler);
            }
            return handler;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean classExists(String className, JAXXCompiler compiler) {
        if (classExistenceCache.containsKey(className)) {
            return classExistenceCache.get(className);
        }
        boolean found = false;
        ClassLoader classLoader = compiler.getClassLoader();
        try {
            Class.forName(className, true, classLoader);
            found = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        if (!found) {
            URL javaURL = classLoader.getResource(className.replace('.', '/') + ".java");
            boolean bl = found = javaURL != null;
        }
        if (!found) {
            URL jaxxURL = classLoader.getResource(className.replace('.', '/') + ".jaxx");
            found = jaxxURL != null;
        }
        classExistenceCache.put(className, found);
        return found;
    }

    private static String determinePackage(String simpleClassName, String defaultPackage, JAXXCompiler compiler) {
        String namespace = null;
        Set<String> classes = compiler.getImportedClasses();
        for (String className : classes) {
            if (!className.equals(simpleClassName) && !className.endsWith("." + simpleClassName)) continue;
            namespace = className.substring(0, className.lastIndexOf(".") + 1) + "*";
        }
        if (namespace == null) {
            Set<String> searchList = compiler.getImportedPackages();
            if (defaultPackage != null) {
                if (!defaultPackage.endsWith("*")) {
                    throw new IllegalArgumentException("defaultPackage must end in '*', found '" + defaultPackage + "'");
                }
                String fqn = defaultPackage.substring(0, defaultPackage.length() - 1) + simpleClassName;
                if (TagManager.classExists(fqn, compiler)) {
                    return defaultPackage;
                }
            }
            for (String currentPackage : searchList) {
                String className = currentPackage + simpleClassName;
                if (!TagManager.classExists(className, compiler)) continue;
                if (namespace != null) {
                    compiler.reportError("symbol '" + simpleClassName + "' is ambiguous, found matching classes " + namespace.substring(0, namespace.length() - 1) + simpleClassName + " and " + currentPackage + simpleClassName + ".  Use fully-qualified name to disambiguate.");
                    return null;
                }
                namespace = currentPackage + "*";
            }
        }
        return namespace;
    }

    public static TagHandler getTagHandler(String namespace, String tag, boolean namespacePrefix, JAXXCompiler compiler) throws CompilerException {
        TagHandler handler;
        String className;
        if (tag == null) {
            throw new NullPointerException("tag parameter can not be null");
        }
        if (namespace == null && namespace == null && defaultNamespaces.containsKey(tag) && (namespace = defaultNamespaces.get(tag)) == null) {
            String packageName = compiler.getJavaFile().getPackageName();
            className = TagManager.resolveClassName(packageName + "." + tag, compiler);
            if (className != null) {
                namespace = packageName + ".*";
            } else {
                String fqn = compiler.getImportedTypeForSimpleName(tag);
                if (fqn != null) {
                    namespace = fqn.substring(0, fqn.indexOf(tag)) + "*";
                } else {
                    compiler.reportError("tag '" + tag + "' is ambiguous; specify fully-qualified name (package and class) to disambiguate");
                    return null;
                }
            }
        }
        if ((handler = registeredTags.get(new QName((String)namespace, tag))) == null && (namespace == null || ((String)namespace).endsWith("*"))) {
            int dotPos;
            if (namespace != null) {
                className = TagManager.resolveClassName(((String)namespace).substring(0, ((String)namespace).length() - 1) + tag, compiler);
                if (className == null) {
                    className = TagManager.resolveClassName(tag, compiler);
                    if (namespacePrefix && !className.startsWith(((String)namespace).substring(0, ((String)namespace).length() - 1))) {
                        className = null;
                    }
                }
            } else {
                className = TagManager.resolveClassName(tag, compiler);
            }
            if (className != null && (handler = registeredTags.get(new QName((String)(namespace = className.substring(0, (dotPos = className.lastIndexOf(".")) + 1) + "*"), tag = className.substring(dotPos + 1)))) == null) {
                try {
                    ClassDescriptor beanClass = ClassDescriptorHelper.getClassDescriptor(className, compiler.getClassLoader());
                    handler = TagManager.getTagHandler(beanClass);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)e);
                }
            }
        }
        return handler;
    }

    public static String resolveClassName(String name, JAXXCompiler compiler) {
        if (name.endsWith("[]")) {
            return TagManager.resolveClassName(name.substring(0, name.length() - 2), compiler) + "[]";
        }
        if (name.contains("<")) {
            name = name.substring(0, name.indexOf("<"));
        }
        if ((name = name.intern()).equals("boolean") || name.equals("byte") || name.equals("short") || name.equals("int") || name.equals("long") || name.equals("float") || name.equals("double") || name.equals("char")) {
            return name;
        }
        Object result = null;
        String originalName = name;
        Object defaultNamespace = null;
        if (defaultNamespaces.containsKey(name) && (defaultNamespace = defaultNamespaces.get(name)) == null) {
            String packageName = compiler.getJavaFile().getPackageName();
            String className = TagManager.resolveClassName(packageName + "." + name, compiler);
            if (className != null) {
                defaultNamespace = packageName + ".";
            } else {
                String fqn = compiler.getImportedTypeForSimpleName(name);
                if (fqn != null) {
                    defaultNamespace = fqn.substring(0, fqn.indexOf(name));
                } else {
                    compiler.reportError("class '" + name + "' is ambiguous; specify fully-qualified name (package and class) to disambiguate");
                    return null;
                }
            }
        }
        if (defaultNamespace != null && ((String)defaultNamespace).endsWith("*")) {
            result = ((String)defaultNamespace).substring(0, ((String)defaultNamespace).length() - 1) + name;
        }
        if (result == null) {
            int dotPos = originalName.lastIndexOf(46);
            while (true) {
                String namespace = dotPos != -1 ? originalName.substring(0, dotPos) + ".*" : "*";
                name = originalName.substring(dotPos + 1).replace('.', '$');
                String packageName = TagManager.determinePackage(name, namespace, compiler);
                if (packageName != null) {
                    assert (packageName.endsWith("*"));
                    if (packageName.equals(namespace) || namespace.equals("*")) {
                        TagHandler handler = registeredTags.get(new QName(namespace, name));
                        if (handler != null) {
                            ClassDescriptor alias = ((DefaultObjectHandler)handler).getBeanClass();
                            assert (alias.getPackageName() != null && alias.getPackageName().length() > 0) : "aliasing with no package name has not been implemented";
                            registeredTags.put(new QName(alias.getPackageName() + ".*", alias.getName().substring(alias.getPackageName().length() + 1)), handler);
                            result = alias.getName();
                            break;
                        }
                        result = packageName.substring(0, packageName.length() - 1) + name;
                        break;
                    }
                }
                if (dotPos <= 0) break;
                dotPos = originalName.lastIndexOf(46, dotPos - 1);
            }
        }
        if (result != null && !((String)result).equals(originalName)) {
            result = TagManager.resolveClassName((String)result, compiler);
        }
        return result;
    }

    public static ClassDescriptor resolveClass(String className, JAXXCompiler compiler) {
        try {
            className = TagManager.resolveClassName(className, compiler);
            if (className == null) {
                return null;
            }
            return ClassDescriptorHelper.getClassDescriptor(className, compiler.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static class QName {
        private String namespaceURI;
        private String localPart;

        public QName(String namespaceURI, String localPart) {
            if (localPart == null) {
                throw new NullPointerException();
            }
            this.namespaceURI = namespaceURI;
            this.localPart = localPart;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof QName)) {
                return false;
            }
            QName qname = (QName)o;
            return qname.getNamespaceURI().equals(this.getNamespaceURI()) && qname.getLocalPart().equals(this.getLocalPart());
        }

        public int hashCode() {
            return (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0) ^ this.getLocalPart().hashCode();
        }
    }
}

