/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.binding;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.java.parser.SimpleNode;

public class JavaParserUtil {
    private static final Logger log = LogManager.getLogger(JavaParserUtil.class);
    private static final Comparator<String> STRING_LENGTH_COMPARATOR = Comparator.comparingInt(String::length);

    public static void getExpressions(SimpleNode node, Map<SimpleNode, List<SimpleNode>> store, List<SimpleNode> literals, Map<SimpleNode, List<SimpleNode>> casts) {
        if (node.getId() == 22 || node.getId() == 17) {
            return;
        }
        if (node.getId() == 62) {
            JavaParserUtil.scanForExpressions(node, null, store, literals, casts);
            return;
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            JavaParserUtil.getExpressions(node.getChild(i), store, literals, casts);
        }
    }

    public static void removeLiteralExpressions(Map<SimpleNode, List<SimpleNode>> store, List<SimpleNode> literalExpressions) {
        for (SimpleNode n : literalExpressions) {
            if (log.isDebugEnabled()) {
                log.debug("Reject literal expression " + n.getText());
            }
            for (List<SimpleNode> dependencies : store.values()) {
                dependencies.remove(n);
            }
            store.remove(n);
        }
    }

    public static void removeNoneStandaloneExpressions(Map<SimpleNode, List<SimpleNode>> store, Map<SimpleNode, List<SimpleNode>> castsExpressions) {
        ArrayList<SimpleNode> rejectedExpressions = new ArrayList<SimpleNode>();
        for (Map.Entry<SimpleNode, List<SimpleNode>> e : store.entrySet()) {
            List<SimpleNode> dependencies = e.getValue();
            SimpleNode node = e.getKey();
            if (castsExpressions.containsKey(node) || dependencies.isEmpty()) continue;
            rejectedExpressions.add(node);
            if (!log.isDebugEnabled()) continue;
            log.debug("Reject expression " + node.getText() + " with " + dependencies.size() + " dependencies");
            for (SimpleNode n : dependencies) {
                log.debug("  " + n.getText());
            }
        }
        for (SimpleNode node : rejectedExpressions) {
            store.remove(node);
        }
        rejectedExpressions.clear();
    }

    /*
     * WARNING - void declaration
     */
    public static Set<String> getRequired(Set<SimpleNode> store, Map<SimpleNode, List<SimpleNode>> casts) {
        if (store.isEmpty()) {
            return null;
        }
        LinkedHashSet<SimpleNode> castCodes = new LinkedHashSet<SimpleNode>();
        for (List<SimpleNode> list : casts.values()) {
            for (SimpleNode simpleNode : list) {
                castCodes.add(simpleNode);
                if (!log.isDebugEnabled()) continue;
                log.debug("cast = " + simpleNode.getText().trim());
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (SimpleNode node : store) {
            void var6_11;
            String string = node.getText().trim();
            if (result.contains(string)) continue;
            for (SimpleNode castCode : castCodes) {
                String str = castCode.getText().trim();
                int index = var6_11.indexOf(str);
                if (index <= -1) continue;
                if (log.isDebugEnabled()) {
                    log.debug("got a cast in expresion " + (String)var6_11 + " = " + castCode);
                }
                Object tmp = "";
                if (index > 1) {
                    tmp = var6_11.substring(0, index - 1);
                }
                tmp = (String)tmp + ((SimpleNode)castCode.jjtGetChild(1)).getText().trim() + var6_11.substring(index + str.length() + 1);
                if (log.isDebugEnabled()) {
                    log.debug("REMOVED CAST : " + (String)tmp);
                }
                Object object = tmp;
            }
            if (!var6_11.contains(".")) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Reject simple expression " + (String)var6_11);
                continue;
            }
            if (!var6_11.contains("(")) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Reject constant or static expression " + (String)var6_11);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Keep expression " + (String)var6_11);
            }
            result.add(var6_11);
        }
        if (result.isEmpty()) {
            return null;
        }
        result.sort(STRING_LENGTH_COMPARATOR);
        if (log.isDebugEnabled()) {
            log.debug("======= start with values : " + result);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : result) {
            String s;
            String args;
            String args2;
            LinkedHashSet<String> tmp = new LinkedHashSet<String>();
            Object[] paths = string.split("\\s*\\.\\s*");
            if (paths.length < 2) continue;
            if (log.isDebugEnabled()) {
                log.debug("Expression to treate : " + string + " :: " + Arrays.toString(paths));
            }
            StringBuilder buffer = new StringBuilder();
            String last = ((String)paths[0]).trim();
            if (last.contains("(") && ((args2 = JavaParserUtil.getMethodInvocationParameters(last)) == null || !args2.isEmpty())) continue;
            buffer.append(last);
            tmp.add(buffer.toString());
            int max = paths.length - 1;
            for (int i = 1; i < max && (args = JavaParserUtil.getMethodInvocationParameters(s = ((String)paths[i]).trim())) != null && args.isEmpty(); ++i) {
                buffer.append(".").append(s);
                last = buffer.toString();
                tmp.add(last);
            }
            linkedHashSet.addAll(tmp);
        }
        if (log.isDebugEnabled()) {
            log.debug("Detected requirements : " + linkedHashSet);
        }
        return linkedHashSet;
    }

    public static String getMethodInvocationParameters(String code) {
        int openIndex = code.indexOf("(");
        int closeIndex = code.lastIndexOf(")");
        if (openIndex > -1 && closeIndex > -1) {
            if (closeIndex == openIndex + 1) {
                return "";
            }
            return code.substring(openIndex + 1, closeIndex - 1).trim();
        }
        return null;
    }

    public static String getPropertyNameFromMethod(String code) {
        int openIndex = code.indexOf("(");
        if (openIndex != -1) {
            code = code.substring(0, openIndex);
        }
        int index = 3;
        if (code.startsWith("is")) {
            index = 2;
        }
        code = code.substring(index);
        code = Introspector.decapitalize(code);
        return code;
    }

    public static void scanForExpressions(SimpleNode node, SimpleNode lastExpressionNode, Map<SimpleNode, List<SimpleNode>> store, List<SimpleNode> literals, Map<SimpleNode, List<SimpleNode>> casts) {
        List<SimpleNode> simpleNodeList;
        String nodeExpression = node.getText().trim();
        if (log.isTraceEnabled()) {
            log.trace("node " + node.getId() + " nbChilds : " + node.jjtGetNumChildren() + " : " + nodeExpression);
        }
        if (node.getId() == 66) {
            if (log.isDebugEnabled()) {
                log.debug("detected literal " + nodeExpression + " for last expression " + lastExpressionNode.getText());
            }
            literals.add(lastExpressionNode);
            return;
        }
        if (node.getId() == 61) {
            if (log.isDebugEnabled()) {
                log.debug("detected cast " + nodeExpression + " for last expression " + lastExpressionNode.getText());
            }
            simpleNodeList = casts.computeIfAbsent(lastExpressionNode, k -> new ArrayList());
            simpleNodeList.add(node);
        }
        if (node.getId() == 62) {
            store.computeIfAbsent(node, k -> new ArrayList());
            if (lastExpressionNode != null) {
                simpleNodeList = store.get(lastExpressionNode);
                if (simpleNodeList == null) {
                    simpleNodeList = new ArrayList<SimpleNode>();
                    store.put(node, simpleNodeList);
                }
                simpleNodeList.add(node);
            }
            lastExpressionNode = node;
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            JavaParserUtil.scanForExpressions(node.getChild(i), lastExpressionNode, store, literals, casts);
        }
    }
}

