/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import io.ultreia.java4all.i18n.spi.builder.I18nKeySet;
import io.ultreia.java4all.i18n.spi.builder.I18nModuleNotInitializedException;
import io.ultreia.java4all.lang.Strings;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompiledObjectDecorator;
import org.nuiton.jaxx.compiler.CompilerConfiguration;
import org.nuiton.jaxx.compiler.DefaultCompilerConfiguration;
import org.nuiton.jaxx.compiler.I18nHelper;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXProfile;
import org.nuiton.jaxx.compiler.finalizers.I18nKeysFileModel;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.FieldDescriptor;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.tasks.CompileFirstPassTask;
import org.nuiton.jaxx.compiler.tasks.CompileSecondPassTask;
import org.nuiton.jaxx.compiler.tasks.FinalizeTask;
import org.nuiton.jaxx.compiler.tasks.GenerateConstructorsTask;
import org.nuiton.jaxx.compiler.tasks.GenerateMissingRulesTask;
import org.nuiton.jaxx.compiler.tasks.GenerateTask;
import org.nuiton.jaxx.compiler.tasks.InitTask;
import org.nuiton.jaxx.compiler.tasks.JAXXEngineTask;
import org.nuiton.jaxx.compiler.tasks.ProfileTask;
import org.nuiton.jaxx.compiler.tasks.StyleSheetTask;

public class JAXXEngine {
    private static final Logger log = LogManager.getLogger(JAXXEngine.class);
    protected final CompilerConfiguration configuration;
    protected final JAXXCompilerFile[] incomingFiles;
    protected final List<JAXXCompilerFile> compilingFiles;
    protected final List<String> warnings;
    protected final List<String> errors;
    private final I18nKeySet getterFile;
    private final Map<String, String> i18nPropertyMapping;
    private final Map<String, I18nKeysFileModel> i18nKeys = new TreeMap<String, I18nKeysFileModel>();
    protected JAXXEngineTask[] tasks;
    protected JAXXEngineTask currentTask;
    protected JAXXProfile profiler;
    private Class<?> validatorFactory;
    private ClassDescriptor validatorFactoryClass;

    protected JAXXEngine(CompilerConfiguration configuration, File base, String ... relativePaths) {
        if (configuration == null) {
            configuration = new DefaultCompilerConfiguration();
        }
        this.configuration = configuration;
        this.warnings = new ArrayList<String>();
        this.errors = new ArrayList<String>();
        this.compilingFiles = new ArrayList<JAXXCompilerFile>();
        this.i18nPropertyMapping = new TreeMap<String, String>();
        if (configuration.isShowClassDescriptorLoading()) {
            ClassDescriptorHelper.setShowLoading(true);
        }
        for (String relativePath : relativePaths) {
            JAXXCompilerFile compilerFile = new JAXXCompilerFile(base, new File(base, relativePath), configuration.getCssExtension());
            this.addFileToCompile(compilerFile);
        }
        if (configuration.getI18nModule() != null) {
            try {
                this.getterFile = configuration.getI18nModule().getModuleKeySet("jaxx");
            }
            catch (I18nModuleNotInitializedException e) {
                throw new RuntimeException("No i18n configuration found, please invoke mojo i18n:init");
            }
        } else {
            this.getterFile = null;
        }
        this.incomingFiles = this.compilingFiles.toArray(new JAXXCompilerFile[0]);
        JAXXCompiler.commonCssDetectedCount = 0;
    }

    public JAXXEngineTask[] getTasks() {
        if (this.tasks == null) {
            ArrayList<JAXXEngineTask> tasks = new ArrayList<JAXXEngineTask>();
            tasks.add(new InitTask());
            tasks.add(new CompileFirstPassTask());
            tasks.add(new CompileSecondPassTask());
            tasks.add(new StyleSheetTask());
            tasks.add(new FinalizeTask());
            tasks.add(new GenerateConstructorsTask());
            tasks.add(new GenerateTask());
            if (this.getConfiguration().isGenerateMissingIdsAndStyleClassesInCss()) {
                tasks.add(new GenerateMissingRulesTask());
            }
            if (this.getConfiguration().isProfile()) {
                tasks.add(new ProfileTask());
            }
            this.tasks = tasks.toArray(new JAXXEngineTask[0]);
        }
        return this.tasks;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public JAXXProfile getProfiler() {
        if (this.profiler == null && this.getConfiguration().isProfile()) {
            this.profiler = new JAXXProfile();
        }
        return this.profiler;
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public JAXXCompilerFile[] getFilesToCompile() {
        ArrayList<JAXXCompilerFile> files = new ArrayList<JAXXCompilerFile>();
        for (JAXXCompilerFile file : this.compilingFiles) {
            if (file.getCompiler() != null) continue;
            files.add(file);
        }
        return files.toArray(new JAXXCompilerFile[0]);
    }

    public JAXXCompilerFile[] getCompiledFiles() {
        ArrayList<JAXXCompilerFile> files = new ArrayList<JAXXCompilerFile>();
        for (JAXXCompilerFile file : this.compilingFiles) {
            if (file.getCompiler() == null) continue;
            files.add(file);
        }
        return files.toArray(new JAXXCompilerFile[0]);
    }

    public boolean containsJaxxFileClassName(String className) {
        for (JAXXCompilerFile file : this.compilingFiles) {
            if (!className.equals(file.getClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean isCompileFirstPassTask() {
        return this.currentTask != null && "CompileFirstPass".equals(this.currentTask.getName());
    }

    protected void reset(boolean cleanReports) {
        for (JAXXCompilerFile compilerFile : this.compilingFiles) {
            compilerFile.clear();
        }
        this.compilingFiles.clear();
        if (this.profiler != null) {
            this.profiler.clear();
            this.profiler = null;
        }
        if (cleanReports) {
            this.clearReports();
        }
        ClassDescriptorHelper.setShowLoading(false);
    }

    public void clearReports() {
        this.getWarnings().clear();
        this.getErrors().clear();
    }

    public String getVersion() {
        return "2.4";
    }

    public JAXXCompilerFile getJAXXCompilerFile(String className) {
        for (JAXXCompilerFile compilingFile : this.compilingFiles) {
            if (!className.equals(compilingFile.getClassName())) continue;
            return compilingFile;
        }
        return null;
    }

    public JAXXCompiler getJAXXCompiler(String className) {
        JAXXCompilerFile compilerFile = this.getJAXXCompilerFile(className);
        if (compilerFile == null) {
            return null;
        }
        return compilerFile.getCompiler();
    }

    public CompiledObjectDecorator getDecorator(String name) throws IllegalArgumentException {
        Map<String, CompiledObjectDecorator> decorators = this.getConfiguration().getDecorators();
        CompiledObjectDecorator decorator = decorators.get(name);
        if (decorator == null) {
            throw new IllegalArgumentException("could not find decorator with key " + name + " (known decorators : " + decorators.keySet() + ")");
        }
        return decorator;
    }

    public CompiledObjectDecorator getDecorator(Class<?> type) {
        Map<String, CompiledObjectDecorator> decorators = this.getConfiguration().getDecorators();
        for (CompiledObjectDecorator decorator : decorators.values()) {
            if (!decorator.getClass().equals(type)) continue;
            return decorator;
        }
        return null;
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        try {
            boolean success = true;
            for (JAXXEngineTask task : this.getTasks()) {
                if (!success) break;
                this.currentTask = task;
                long t0 = System.nanoTime();
                if (this.isVerbose()) {
                    log.info("Start task '" + task.getName() + "' on " + this.compilingFiles.size() + " file(s)");
                }
                success = task.perform(this);
                if (!this.isVerbose()) continue;
                log.info("task '" + task.getName() + "' done in " + Strings.convertTime((long)(System.nanoTime() - t0)));
            }
            int n = success ? this.compilingFiles.size() : -1;
            return n;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            int n = -1;
            return n;
        }
        finally {
            if (this.configuration.isResetAfterCompile()) {
                this.reset(false);
            }
        }
    }

    public void addFileToCompile(JAXXCompilerFile file) {
        if (this.isVerbose()) {
            log.info("register jaxx file " + file.getJaxxFile());
        }
        this.compilingFiles.add(file);
    }

    public void addFileToCompile(File jaxxFile, String jaxxClassName) {
        if (log.isDebugEnabled()) {
            log.debug("file = " + jaxxFile + ", fqn = " + jaxxClassName);
        }
        JAXXCompilerFile file = new JAXXCompilerFile(jaxxFile, jaxxClassName, this.configuration.getCssExtension());
        this.addFileToCompile(file);
    }

    public JAXXCompiler newCompiler(JAXXCompilerFile jaxxFile) throws Exception {
        Class<? extends JAXXCompiler> compilerClass = this.getConfiguration().getCompilerClass();
        if (compilerClass == null) {
            throw new NullPointerException("Configuration compilerClass is null");
        }
        Constructor<? extends JAXXCompiler> cons = compilerClass.getConstructor(JAXXEngine.class, JAXXCompilerFile.class, List.class);
        JAXXCompiler jaxxCompiler = cons.newInstance(this, jaxxFile, Arrays.asList("java.awt.*", "java.lang.*", "javax.swing.*", "javax.swing.border.*", "org.nuiton.jaxx.runtime.swing.*"));
        jaxxFile.setCompiler(jaxxCompiler);
        return jaxxCompiler;
    }

    public boolean isVerbose() {
        return this.getConfiguration().isVerbose();
    }

    public void addProfileTime(JAXXCompiler compiler, String key) {
        JAXXProfile profiler = this.getProfiler();
        if (profiler != null) {
            profiler.addTime(compiler, key);
        }
    }

    String getI18nProperty(ClassDescriptor objectClass) {
        String className = objectClass.getName();
        String result = this.i18nPropertyMapping.get(className);
        if (result == null) {
            String i18nAttribute;
            Optional<Object> field = Optional.empty();
            Iterator<String> iterator = I18nHelper.I18N_ATTRIBUTES.iterator();
            while (iterator.hasNext() && !(field = objectClass.tryToGetFieldDescriptor(i18nAttribute = iterator.next())).isPresent()) {
            }
            if (field.isPresent()) {
                result = ((FieldDescriptor)field.get()).getName();
                if (this.isVerbose()) {
                    log.info(String.format("Discover i18n property: %s for %s", result, className));
                }
                this.i18nPropertyMapping.put(className, result);
            } else {
                String i18nAttribute2;
                Optional<Object> method = Optional.empty();
                Iterator<String> iterator2 = I18nHelper.I18N_ATTRIBUTES.iterator();
                while (iterator2.hasNext() && !(method = objectClass.tryToGetSetterMethodDescriptor(i18nAttribute2 = iterator2.next())).isPresent()) {
                }
                if (method.isPresent()) {
                    result = Introspector.decapitalize(StringUtils.removeStart((String)((MethodDescriptor)method.get()).getName(), (String)"set"));
                    if (this.isVerbose()) {
                        log.info(String.format("Discover i18n property: %s for %s", result, className));
                    }
                    this.i18nPropertyMapping.put(className, result);
                } else {
                    throw new IllegalStateException(String.format("Can't find i18n property for type: %s", className));
                }
            }
        }
        return result;
    }

    public void registerI18nKey(String key) {
        this.getterFile.addKey(key);
    }

    public void flushI18nGetterFile() throws IOException {
        if (this.getterFile != null) {
            this.configuration.getI18nModule().storeModuleKeySet(this.getterFile);
        }
    }

    public Class<?> getValidatorFactory() {
        try {
            return this.validatorFactory == null ? (this.validatorFactory = Class.forName(this.getConfiguration().getValidatorFactoryFQN(), false, this.getConfiguration().getClassLoader())) : this.validatorFactory;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Can't find validator class", e);
        }
    }

    public ClassDescriptor getValidatorFactoryClass() {
        try {
            return this.validatorFactoryClass == null ? (this.validatorFactoryClass = ClassDescriptorHelper.getClassDescriptor(this.getConfiguration().getValidatorFactoryFQN(), this.getConfiguration().getClassLoader())) : this.validatorFactoryClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public I18nKeysFileModel getI18nKeysFileModel(String fqn, boolean loadIfNotFound) {
        I18nKeysFileModel result = this.i18nKeys.get(fqn);
        if (result == null && loadIfNotFound && (result = I18nKeysFileModel.of(this.getConfiguration().getClassLoader(), fqn, this.getConfiguration().isVerbose())) != null) {
            this.i18nKeys.put(fqn, result);
        }
        return result;
    }
}

