/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.finalizers;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.finalizers.AbstractFinalizer;
import org.nuiton.jaxx.compiler.finalizers.I18nKeysFileModel;
import org.nuiton.jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import org.nuiton.jaxx.compiler.java.JavaFile;

@Component(hint="i18n-detect-keys-file", role=JAXXCompilerFinalizer.class)
@AutoService(value={JAXXCompilerFinalizer.class})
public class DetectI18nKeyFilesFinalizer
extends AbstractFinalizer {
    private static final Logger log = LogManager.getLogger(DetectI18nKeyFilesFinalizer.class);

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return compiler.getConfiguration().isGenerateI18nHelper() && compiler.getI18nKeysFileModel(true) != null;
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws IOException {
        I18nKeysFileModel keysFileModel = compiler.getI18nKeysFileModel(false);
        if (keysFileModel == null) {
            return;
        }
        Path targetRoot = compiler.getEngine().getConfiguration().getTargetDirectory().toPath();
        File file = keysFileModel.generateI18nJavaFile(targetRoot);
        log.info(String.format("Generate i18n helper file (with %d key(s)): %s", keysFileModel.getKeys().size(), file));
    }
}

