/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.decorators;

import com.google.auto.service.AutoService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompiledObjectDecorator;
import org.nuiton.jaxx.compiler.CompilerConfiguration;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.decorators.DefaultCompiledObjectDecorator;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.JavaFile;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.runtime.swing.help.JAXXHelpUI;

@Component(hint="help", role=CompiledObjectDecorator.class)
@AutoService(value={CompiledObjectDecorator.class})
public class HelpRootCompiledObjectDecorator
extends DefaultCompiledObjectDecorator {
    protected static final Set<String> helpIds = new HashSet<String>();

    @Override
    public String getName() {
        return "help";
    }

    protected String getBrokerFQN(JAXXCompiler compiler) {
        return compiler.getConfiguration().getHelpBrokerFQN();
    }

    protected String getHelpId(CompiledObject o) {
        String helpID = null;
        if (o.hasClientProperties()) {
            helpID = o.getClientProperty("help");
        }
        return helpID;
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) throws ClassNotFoundException {
        super.finalizeCompiler(compiler, root, object, javaFile, packageName, className, fullClassName);
        CompilerConfiguration options = compiler.getConfiguration();
        if (options.isGenerateHelp()) {
            Class<JAXXHelpUI> validatorInterface = JAXXHelpUI.class;
            String helpBrokerFQN = this.getBrokerFQN(compiler);
            boolean needInterface = this.isNeedInterface(compiler, validatorInterface);
            if (needInterface) {
                if (log.isDebugEnabled()) {
                    log.debug("Add " + validatorInterface + " on " + javaFile.getName() + " : parent " + JAXXCompiler.getCanonicalName(compiler.getRootObject()));
                }
                javaFile.addInterface(validatorInterface.getName() + "<" + helpBrokerFQN + ">");
            }
            javaFile.addMethod(JavaElementFactory.newMethod(1, "void", "registerHelpId", "broker.installUI(component, helpId);", true, JavaElementFactory.newArgument(helpBrokerFQN, "broker"), JavaElementFactory.newArgument(java.awt.Component.class.getName(), "component"), JavaElementFactory.newArgument("String", "helpId")));
            javaFile.addMethod(JavaElementFactory.newMethod(1, "void", "showHelp", "getBroker().showHelp(this, helpId);", true, JavaElementFactory.newArgument("String", "helpId")));
            StringBuilder buffer = new StringBuilder();
            String eol = JAXXCompiler.getLineSeparator();
            Iterator<CompiledObject> itr = compiler.getObjectCreationOrder();
            while (itr.hasNext()) {
                CompiledObject o = itr.next();
                String helpID = this.getHelpId(o);
                if (helpID == null) continue;
                buffer.append(eol);
                buffer.append("registerHelpId(_broker, ");
                buffer.append(o.getJavaCode());
                buffer.append(", ");
                buffer.append(helpID);
                buffer.append(");");
                helpIds.add(helpID);
            }
            if (buffer.length() > 0) {
                String type = compiler.getImportedType(helpBrokerFQN);
                buffer.append(eol).append("_broker.prepareUI(this);");
                buffer.append(eol);
                compiler.appendLateInitializer("// help broker setup" + eol);
                compiler.appendLateInitializer(type + " _broker = getBroker();");
                compiler.appendLateInitializer(buffer.toString());
            }
        }
    }

    protected boolean isNeedInterface(JAXXCompiler compiler, Class<?> validatorInterface) throws ClassNotFoundException {
        if (compiler.isSuperClassAware(validatorInterface)) {
            return false;
        }
        CompiledObject root = compiler.getRootObject();
        ClassDescriptor rootObjectClass = root.getObjectClass();
        String superClassName = JAXXCompiler.getCanonicalName(rootObjectClass);
        JAXXCompiler parentCompiler = compiler.getEngine().getJAXXCompiler(superClassName);
        if (parentCompiler == null) {
            return true;
        }
        CompiledObjectDecorator decorator = parentCompiler.getRootObject().getDecorator();
        if (decorator != null && decorator instanceof HelpRootCompiledObjectDecorator) {
            return false;
        }
        return this.isNeedInterface(parentCompiler, validatorInterface);
    }

    public static Set<String> getHelpIds() {
        return new HashSet<String>(helpIds);
    }
}

