/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.finalizers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompilerException;

public class I18nKeysFileModel {
    private static final Logger log = LogManager.getLogger(I18nKeysFileModel.class);
    private static final String METHOD_PATTERN = "    public static String %1$s(Class<?> type) {\n        return I18n.t(BeanPropertyI18nKeyProducerProvider.get().getDefaultLabelsBuilder().getI18nPropertyKey(type, \"%2$s\"));\n    }\n";
    private static final String FILE_PATTERN = "package %1$s;\n\nimport io.ultreia.java4all.i18n.spi.bean.BeanPropertyI18nKeyProducerProvider;\nimport io.ultreia.java4all.i18n.I18n;\n\nimport javax.annotation.Generated;\n\n@Generated(value = \"org.nuiton.jaxx.plugin.GenerateMojo\", date = \"%2$s\")\npublic class %3$s {\n\n%4$s}";
    private final Set<String> keys;
    private final String javaSimpleName;
    private final String javaPackageName;

    I18nKeysFileModel(String resource, Set<String> keys) {
        String path = resource.replace(".keys", "");
        int endIndex = path.lastIndexOf("/");
        this.javaSimpleName = path.substring(endIndex + 1) + "I18nHelper";
        this.javaPackageName = path.substring(0, endIndex).replaceAll("/", ".");
        this.keys = Objects.requireNonNull(keys);
    }

    public static I18nKeysFileModel of(ClassLoader classLoader, String fqn, boolean verbose) {
        TreeSet<String> result = new TreeSet<String>();
        String resourcePath = fqn.replaceAll("\\.", File.separator) + ".keys";
        URL resource = classLoader.getResource(resourcePath);
        if (resource != null) {
            log.debug(String.format("Found a i18n keys file: %s", resourcePath));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.add(line.trim());
                }
            }
            catch (IOException e) {
                throw new CompilerException("Can't load i18n keys at: " + resourcePath, e);
            }
            if (verbose) {
                log.info(String.format("Found %d i18n key(s) in file: %s", result.size(), resourcePath));
            } else {
                log.debug(String.format("Found %d i18n key(s) in file: %s", result.size(), resourcePath));
            }
            return new I18nKeysFileModel(resourcePath, result);
        }
        return null;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public Path getJavaFile(Path targetRoot) {
        Path result = targetRoot;
        for (String part : this.javaPackageName.split("\\.")) {
            result = result.resolve(part);
        }
        return result.resolve(this.javaSimpleName + ".java");
    }

    public String getJavaFileContent() {
        LinkedList<String> methods = new LinkedList<String>();
        for (String i18nKey : this.getKeys()) {
            StringBuilder methodNameBuilder = new StringBuilder("get");
            for (String keyPart : i18nKey.split("\\.")) {
                methodNameBuilder.append(StringUtils.capitalize((String)keyPart));
            }
            String methodName = methodNameBuilder.toString();
            methods.add(String.format(METHOD_PATTERN, methodName, i18nKey));
        }
        return String.format(FILE_PATTERN, this.javaPackageName, new Date(), this.javaSimpleName, String.join((CharSequence)"\n", methods));
    }

    public File generateI18nJavaFile(Path targetRoot) throws IOException {
        Path javaFile = this.getJavaFile(targetRoot);
        String javaFileContent = this.getJavaFileContent();
        if (Files.notExists(javaFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(javaFile.getParent(), new FileAttribute[0]);
        }
        Files.write(javaFile, javaFileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return javaFile.toFile();
    }
}

