/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tasks;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXEngine;
import org.nuiton.jaxx.compiler.tasks.JAXXEngineTask;

public class GenerateMissingRulesTask
extends JAXXEngineTask {
    private static final Logger log = LogManager.getLogger(GenerateMissingRulesTask.class);
    public static final String TASK_NAME = "GenerateMissingRules";

    public GenerateMissingRulesTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        JAXXCompilerFile[] files;
        boolean success = true;
        boolean isVerbose = engine.getConfiguration().isVerbose();
        for (JAXXCompilerFile jaxxFile : files = engine.getCompiledFiles()) {
            String className = jaxxFile.getClassName();
            if (isVerbose) {
                log.info("start " + className);
            }
            JAXXCompiler compiler = jaxxFile.getCompiler();
            this.addStartProfileTime(engine, compiler);
            if (compiler.isIdentCssFound()) {
                File cssFile = jaxxFile.getCssFile();
                String cssContent = new String(Files.readAllBytes(cssFile.toPath()), StandardCharsets.UTF_8);
                Map<String, CompiledObject> objects = compiler.getObjects();
                LinkedHashSet<String> cssRulesToAdd = new LinkedHashSet<String>();
                for (String id : objects.keySet()) {
                    Pattern classPattern;
                    Matcher classMatcher;
                    Pattern idPattern;
                    Matcher idMatcher;
                    CompiledObject object = objects.get(id);
                    String styleClass = object.getStyleClass();
                    if (isVerbose) {
                        log.info("id : " + id + ", styleClass : " + styleClass);
                    }
                    if (!id.startsWith("$") && !(idMatcher = (idPattern = Pattern.compile("#" + id + "\\s*\\{.*\\}", 32)).matcher(cssContent)).find()) {
                        if (log.isInfoEnabled()) {
                            log.info("add css rule for #" + id + " in " + cssFile.getName());
                        }
                        cssRulesToAdd.add("\n\n/* #" + id + " {} */");
                    }
                    if (styleClass == null || (classMatcher = (classPattern = Pattern.compile("\\." + styleClass + "\\s*\\{.*\\}", 32)).matcher(cssContent)).find()) continue;
                    if (log.isInfoEnabled()) {
                        log.info("add css rule for ." + styleClass + " in " + cssFile.getName());
                    }
                    cssRulesToAdd.add("\n\n/* ." + styleClass + " {} */");
                }
                Files.write(cssFile.toPath(), StringUtils.join(cssRulesToAdd, (String)"").getBytes(), StandardOpenOption.APPEND);
            }
            this.addEndProfileTime(engine, compiler);
            if (!compiler.isFailed()) continue;
            success = false;
        }
        return success;
    }
}

