/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tasks;

import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXEngine;
import org.nuiton.jaxx.compiler.tasks.JAXXEngineTask;

public class CompileFirstPassTask
extends JAXXEngineTask {
    private static final Logger log = LogManager.getLogger(CompileFirstPassTask.class);
    public static final String TASK_NAME = "CompileFirstPass";

    public CompileFirstPassTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;
        JAXXCompilerFile[] undone = engine.getFilesToCompile();
        while (undone.length > 0) {
            for (JAXXCompilerFile jaxxFile : undone) {
                boolean successForFile = this.treatFile(engine, jaxxFile);
                if (successForFile) continue;
                success = false;
            }
            undone = engine.getFilesToCompile();
        }
        return success;
    }

    protected boolean treatFile(JAXXEngine engine, JAXXCompilerFile jaxxFile) throws Exception {
        boolean isVerbose = engine.isVerbose();
        if (isVerbose) {
            log.info("start " + jaxxFile.getClassName());
        }
        boolean success = true;
        JAXXCompiler compiler = engine.newCompiler(jaxxFile);
        this.addStartProfileTime(engine, compiler);
        compiler.detectIdentStyleSheetFile();
        compiler.compileFirstPass();
        URL commonCss = engine.getConfiguration().getCommonCss();
        if (commonCss != null) {
            if (isVerbose) {
                log.info("Import common css: " + commonCss);
            }
            compiler.registerStyleSheetFile(commonCss, false);
        }
        this.addEndProfileTime(engine, compiler);
        if (compiler.isFailed()) {
            success = false;
        }
        return success;
    }
}

