/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.java;

import io.ultreia.java4all.lang.Strings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaConstructor;
import org.nuiton.jaxx.compiler.java.JavaField;
import org.nuiton.jaxx.compiler.java.JavaFile;
import org.nuiton.jaxx.compiler.java.JavaMethod;

public class JavaElementFactory {
    private static final Logger log = LogManager.getLogger(JavaElementFactory.class);

    public static JavaFile newFile(int modifiers, String className) {
        return new JavaFile(modifiers, className);
    }

    public static JavaFile newFile(int modifiers, String packageName, String className) {
        return new JavaFile(modifiers, packageName, className);
    }

    public static JavaArgument newArgument(String type, String name) {
        return JavaElementFactory.newArgument(type, name, false);
    }

    public static JavaArgument newArgument(String type, String name, boolean isFinal) {
        return new JavaArgument(type, name, isFinal);
    }

    public static JavaField newField(int modifiers, String returnType, String name, boolean override) {
        return JavaElementFactory.newField(modifiers, returnType, name, override, null, new String[0]);
    }

    public static JavaField newField(int modifiers, String returnType, String name, boolean override, String initializer, String ... initializerTypes) {
        return new JavaField(modifiers, returnType, name, override, initializer, initializerTypes);
    }

    public static JavaConstructor newConstructor(int modifiers, String name, String body, String[] exceptions, JavaArgument ... arguments) {
        return new JavaConstructor(modifiers, name, arguments, exceptions, body);
    }

    public static JavaConstructor newConstructor(int modifiers, String name, String body, JavaArgument ... arguments) {
        return JavaElementFactory.newConstructor(modifiers, name, body, Strings.EMPTY_STRING_ARRAY, arguments);
    }

    public static JavaMethod newMethod(int modifiers, String returnType, String name, String body, boolean override, String[] exceptions, JavaArgument ... arguments) {
        if (log.isDebugEnabled()) {
            log.debug(name + " returns : " + returnType);
        }
        return new JavaMethod(modifiers, returnType, name, arguments, exceptions, body, override);
    }

    public static JavaMethod newMethod(int modifiers, String returnType, String name, String body, boolean override, JavaArgument ... arguments) {
        return JavaElementFactory.newMethod(modifiers, returnType, name, body, override, Strings.EMPTY_STRING_ARRAY, arguments);
    }

    public static JavaField cloneField(JavaField field) {
        return JavaElementFactory.newField(field.getModifiers(), field.getType(), field.getName(), field.isOverride(), field.getInitializer(), field.getInitializerTypes());
    }

    public static JavaMethod cloneMethod(JavaMethod method) {
        String[] incomingExceptions = method.getExceptions();
        String[] exceptions = new String[incomingExceptions.length];
        System.arraycopy(incomingExceptions, 0, exceptions, 0, exceptions.length);
        JavaArgument[] oldArguments = method.getArguments();
        int nbArguments = oldArguments.length;
        JavaArgument[] arguments = new JavaArgument[nbArguments];
        for (int i = 0; i < nbArguments; ++i) {
            JavaArgument argument = oldArguments[i];
            arguments[i] = JavaElementFactory.cloneArgument(argument);
        }
        return JavaElementFactory.newMethod(method.getModifiers(), method.getReturnType(), method.getName(), method.getBody(), method.isOverride(), exceptions, arguments);
    }

    public static JavaArgument cloneArgument(JavaArgument argument) {
        return JavaElementFactory.newArgument(argument.getType(), argument.getName(), argument.isFinal());
    }
}

