/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.finalizers;

import com.google.auto.service.AutoService;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.finalizers.AbstractFinalizer;
import org.nuiton.jaxx.compiler.finalizers.I18nKeysFileModel;
import org.nuiton.jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import org.nuiton.jaxx.compiler.java.JavaFile;

@Component(hint="i18n-apply-keys-file", role=JAXXCompilerFinalizer.class)
@AutoService(value={JAXXCompilerFinalizer.class})
public class ApplyI18nKeysFileFinalizer
extends AbstractFinalizer {
    @Override
    public boolean accept(JAXXCompiler compiler) {
        return compiler.getConfiguration().isApplyI18nHelper() && compiler.getConfiguration().isI18nable() && compiler.getParentI18nKeysFileModel(true) != null;
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        if (!compiler.isI18nInit()) {
            throw new CompilerException("Jaxx file has not set i18n: " + compiler.getOutputClassName());
        }
        I18nKeysFileModel keysFileModel = compiler.getParentI18nKeysFileModel(false);
        keysFileModel.getKeys().forEach(i18nKey -> compiler.getEngine().registerI18nKey(compiler.computeI18nProperty((String)i18nKey)));
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
    }
}

