/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tasks;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXEngine;
import org.nuiton.jaxx.compiler.tasks.JAXXEngineTask;

public class CompileSecondPassTask
extends JAXXEngineTask {
    private static final Logger log = LogManager.getLogger(CompileSecondPassTask.class);
    public static final String TASK_NAME = "CompileSecondPass";

    public CompileSecondPassTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        JAXXCompilerFile[] files;
        boolean success = true;
        boolean isVerbose = engine.isVerbose();
        this.checkAllFilesCompiled(engine);
        for (JAXXCompilerFile jaxxFile : files = engine.getCompiledFiles()) {
            String className = jaxxFile.getClassName();
            if (isVerbose) {
                log.info("start " + className);
            }
            JAXXCompiler compiler = jaxxFile.getCompiler();
            this.addStartProfileTime(engine, compiler);
            if (log.isDebugEnabled()) {
                log.debug("runInitializers for " + className);
            }
            if (!compiler.isFailed()) {
                compiler.runInitializers();
            }
            if (log.isDebugEnabled()) {
                log.debug("compile second pass for " + className);
            }
            compiler.compileSecondPass();
            this.addEndProfileTime(engine, compiler);
            if (log.isDebugEnabled()) {
                log.debug("done with result [" + !compiler.isFailed() + "] for " + className);
            }
            if (!compiler.isFailed()) continue;
            success = false;
        }
        return success;
    }
}

