/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.swing.AbstractButton;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.binding.TypeParser;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.DefaultComponentHandler;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.swing.action.JAXXObjectActionSupport;
import org.w3c.dom.Element;

public class AbstractButtonHandler
extends DefaultComponentHandler {
    private static final Logger log = LogManager.getLogger(AbstractButtonHandler.class);
    private final Set<ActionCandidateResolver> actionCandidateResolvers;

    public AbstractButtonHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, AbstractButton.class);
        this.actionCandidateResolvers = ImmutableSet.builder().add((packageName, jaxxFileName, objectId) -> packageName + ".actions." + StringUtils.capitalize((String)objectId)).add((packageName, jaxxFileName, objectId) -> packageName + ".actions." + StringUtils.capitalize((String)(objectId + "Action"))).add((packageName, jaxxFileName, objectId) -> packageName + ".actions." + jaxxFileName + StringUtils.capitalize((String)objectId)).add((packageName, jaxxFileName, objectId) -> packageName + ".actions." + jaxxFileName + StringUtils.capitalize((String)(objectId + "Action"))).add((packageName, jaxxFileName, objectId) -> packageName + ".actions." + StringUtils.capitalize((String)objectId.replace("Action", ""))).add((packageName, jaxxFileName, objectId) -> packageName + ".actions." + jaxxFileName + StringUtils.capitalize((String)objectId.replace("Action", ""))).build();
    }

    @Override
    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        super.setDefaults(object, tag, compiler);
        if (compiler.getConfiguration().isDetectAction()) {
            ClassDescriptor classDescriptor = this.getAction(compiler.getJavaFile().getPackageName(), compiler.getJavaFile().getSimpleName(), compiler, object);
            if (!object.isOverride() && classDescriptor == null && compiler.isSuperClassAware(JAXXObject.class)) {
                ClassDescriptor objectClass = compiler.getRootObject().getObjectClass();
                while (objectClass != null && classDescriptor == null) {
                    classDescriptor = this.getAction(objectClass.getPackageName(), objectClass.getSimpleName(), compiler, object);
                    if (classDescriptor != null) continue;
                    objectClass = objectClass.getSuperclass();
                }
            }
            if (classDescriptor != null) {
                if (compiler.getConfiguration().isVerbose()) {
                    log.info(String.format("Detect auto action: %s for %s.%s", classDescriptor.getName(), compiler.getJavaFile().getName(), object.getId()));
                }
                this.addAction(classDescriptor, object, compiler);
            }
        }
    }

    private ClassDescriptor getAction(String packageName, String jaxxFileName, JAXXCompiler compiler, CompiledObject compiledObject) {
        for (ActionCandidateResolver actionCandidateResolver : this.actionCandidateResolvers) {
            ClassDescriptor classDescriptor = actionCandidateResolver.resolve(packageName, jaxxFileName, compiler, compiledObject);
            if (classDescriptor == null) continue;
            return classDescriptor;
        }
        return null;
    }

    @Override
    public void setAttribute(CompiledObject object, String propertyName, String stringValue, boolean inline, JAXXCompiler compiler) {
        ClassDescriptor classDescriptor;
        if (propertyName.equals("action") && compiler.getConfiguration().isDetectAction()) {
            String actionInstance = compiler.checkJavaCode(stringValue, false);
            classDescriptor = new TypeParser(compiler).parseType(actionInstance);
            if (ClassDescriptorHelper.getClassDescriptor(JAXXObjectActionSupport.class).isAssignableFrom(classDescriptor)) {
                if (compiler.getConfiguration().isVerbose()) {
                    log.info(String.format("Detect auto action instance: %s for %s.%s : %s", classDescriptor.getName(), compiler.getJavaFile().getName(), object.getId(), actionInstance));
                }
                this.addActionInstance(classDescriptor, object, compiler, actionInstance);
                return;
            }
        }
        if (propertyName.equals("actionType")) {
            if (compiler.getConfiguration().isDetectAction()) {
                compiler.reportWarning(String.format("Should not used actionType while using detect action mode: %s.%s", compiler.getOutputClassName(), object.getId()));
            }
            String type = compiler.checkJavaCode(stringValue).replace(".class", "");
            try {
                classDescriptor = ClassDescriptorHelper.getClassDescriptor(type, compiler.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                try {
                    String fqn = compiler.getImportedTypeForSimpleName(type);
                    classDescriptor = ClassDescriptorHelper.getClassDescriptor(fqn, compiler.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    compiler.reportError("Can't find class for type: " + type);
                    return;
                }
            }
            if (compiler.getConfiguration().isVerbose()) {
                log.info(String.format("Found action: %s for %s.%s", classDescriptor.getName(), compiler.getJavaFile().getName(), object.getId()));
            }
            this.addAction(classDescriptor, object, compiler);
        } else {
            super.setAttribute(object, propertyName, stringValue, inline, compiler);
        }
    }

    private void addAction(ClassDescriptor classDescriptor, CompiledObject object, JAXXCompiler compiler) {
        compiler.addImport(classDescriptor.getName());
        compiler.appendLateInitializer(JAXXCompiler.getLineSeparator() + String.format("%s.init(this, %s, %s.class);", classDescriptor.getSimpleName(), object.getId(), classDescriptor.getSimpleName()));
    }

    private void addActionInstance(ClassDescriptor classDescriptor, CompiledObject object, JAXXCompiler compiler, String value) {
        compiler.addImport(classDescriptor.getName());
        compiler.appendLateInitializer(JAXXCompiler.getLineSeparator() + String.format("%s.init(this, %s, %s);", classDescriptor.getSimpleName(), object.getId(), value));
    }

    static interface ActionCandidateResolver {
        public String getActionCandidateName(String var1, String var2, String var3);

        default public ClassDescriptor resolve(String packageName, String jaxxFileName, JAXXCompiler compiler, CompiledObject object) {
            String objectId = object.getId();
            String actionCandidateName = this.getActionCandidateName(packageName, jaxxFileName, objectId);
            try {
                return ClassDescriptorHelper.getClassDescriptor(actionCandidateName, compiler.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }
}

