/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.css;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.binding.DataBindingHelper;
import org.nuiton.jaxx.compiler.binding.PseudoClassDataBinding;
import org.nuiton.jaxx.compiler.css.parser.CSSParser;
import org.nuiton.jaxx.compiler.css.parser.SimpleNode;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.tags.DefaultComponentHandler;
import org.nuiton.jaxx.compiler.tags.DefaultObjectHandler;
import org.nuiton.jaxx.compiler.tags.TagManager;
import org.nuiton.jaxx.compiler.tags.swing.TabWithValidatorHandler;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.css.DataBinding;
import org.nuiton.jaxx.runtime.css.Pseudoclasses;
import org.nuiton.jaxx.runtime.css.Rule;
import org.nuiton.jaxx.runtime.css.Selector;
import org.nuiton.jaxx.runtime.css.Stylesheet;

public class StylesheetHelper {
    private static final Logger log = LogManager.getLogger(StylesheetHelper.class);
    static ClassDescriptor mouseListenerDescriptor;
    static ClassDescriptor mouseEventDescriptor;

    public static URL getStyleURL(String attrValue, File baseDirectory, ClassLoader classLoader) throws IOException {
        if (attrValue.startsWith("classpath:/")) {
            URL resource = classLoader.getResource(attrValue.substring("classpath:".length() + 1));
            if (resource == null) {
                throw new IOException("Style not found: " + attrValue);
            }
            return resource;
        }
        if (baseDirectory == null) {
            Path path = Paths.get(attrValue, new String[0]);
            return Files.exists(path, new LinkOption[0]) ? path.toUri().toURL() : URI.create(attrValue).toURL();
        }
        File styleFile = new File(baseDirectory, attrValue.replace('/', File.separatorChar));
        if (!styleFile.exists()) {
            throw new IOException("Style not found: " + attrValue);
        }
        return styleFile.toURI().toURL();
    }

    public static Stylesheet processStylesheet(String stylesheetText) throws CompilerException {
        SimpleNode node;
        CSSParser p = new CSSParser(new StringReader(stylesheetText));
        try {
            node = p.Stylesheet();
        }
        catch (Error e) {
            throw new CompilerException(e);
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode ruleNode = node.getChild(i);
            Rule rule = StylesheetHelper.processRule(ruleNode);
            rules.add(rule);
        }
        Stylesheet stylesheet = new Stylesheet(rules.toArray(new Rule[rules.size()]));
        return stylesheet;
    }

    public static Rule processRule(SimpleNode ruleNode) {
        if (ruleNode.getId() != 1) {
            throw new IllegalArgumentException("argument node is not a Rule");
        }
        SimpleNode selectorsNode = ruleNode.getChild(0);
        assert (selectorsNode.getId() == 2) : "expected node to be of type Selectors";
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        for (int i = 0; i < selectorsNode.jjtGetNumChildren(); ++i) {
            SimpleNode selectorNode = selectorsNode.getChild(i);
            selectors.add(StylesheetHelper.processSelector(selectorNode));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 1; i < ruleNode.jjtGetNumChildren(); ++i) {
            SimpleNode declarationNode = ruleNode.getChild(i);
            if (declarationNode.getId() != 10) continue;
            String key = declarationNode.getChild(0).getText();
            SimpleNode valueNode = declarationNode.getChild(1);
            String value = valueNode.getText();
            if (valueNode.firstToken.kind == 22) {
                value = value.substring(1, value.length() - 1);
            }
            properties.put(key, value);
        }
        Rule rule = new Rule(selectors.toArray(new Selector[selectors.size()]), properties);
        return rule;
    }

    public static Selector processSelector(SimpleNode selector) {
        if (selector.getId() != 3) {
            throw new IllegalArgumentException("argument node is not a Selector");
        }
        String javaClassName = null;
        String styleClass = null;
        String pseudoClass = null;
        String id = null;
        block6: for (int i = 0; i < selector.jjtGetNumChildren(); ++i) {
            SimpleNode child = selector.getChild(i);
            switch (child.getId()) {
                case 4: {
                    if (child.getText().trim().equals("*")) continue block6;
                    javaClassName = child.getText();
                    continue block6;
                }
                case 6: {
                    styleClass = child.getText().substring(1);
                    continue block6;
                }
                case 7: {
                    pseudoClass = child.getText().substring(1);
                    continue block6;
                }
                case 5: {
                    id = child.getText().substring(1);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("unexpected child of Selector node, type=" + child.getId());
                }
            }
        }
        return new Selector(javaClassName, styleClass, pseudoClass, id);
    }

    public static ClassDescriptor getMouseEventDescriptor() {
        if (mouseEventDescriptor == null) {
            mouseEventDescriptor = ClassDescriptorHelper.getClassDescriptor(MouseEvent.class);
        }
        return mouseEventDescriptor;
    }

    public static ClassDescriptor getMouseListenerDescriptor() {
        if (mouseListenerDescriptor == null) {
            mouseListenerDescriptor = ClassDescriptorHelper.getClassDescriptor(MouseListener.class);
        }
        return mouseListenerDescriptor;
    }

    public static MethodDescriptor getAddMouseListenerMethod(CompiledObject object) {
        try {
            return object.getObjectClass().getMethodDescriptor("addMouseListener", StylesheetHelper.getMouseListenerDescriptor());
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("could not find addMouseListener for object " + object);
        }
    }

    public static MethodDescriptor getMouseListenerMethod(CompiledObject object, String property) {
        try {
            return StylesheetHelper.getMouseListenerDescriptor().getMethodDescriptor(property, StylesheetHelper.getMouseEventDescriptor());
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("could not find " + property + " for object " + object);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void applyTo(CompiledObject object, JAXXCompiler compiler, Stylesheet stylesheet, Stylesheet overrides) throws CompilerException {
        Rule[] pseudoClasses;
        Map<String, String> overriddenProperties = overrides != null ? StylesheetHelper.getApplicableProperties(overrides, object) : null;
        Map properties = StylesheetHelper.getApplicableProperties(stylesheet, object);
        if (properties != null) {
            if (overriddenProperties != null) {
                properties.keySet().removeAll(overriddenProperties.keySet());
            }
            DefaultObjectHandler handler = TagManager.getTagHandler(object.getObjectClass());
            if (properties.containsKey("i18nProperty")) {
                String key = "i18nProperty";
                String string = properties.get(key);
                if (handler instanceof DefaultComponentHandler) {
                    handler.setAttribute(object, key, string, false, compiler);
                } else if (handler instanceof TabWithValidatorHandler) {
                    handler.setAttribute(object, key, string, false, compiler);
                } else {
                    handler.setAttributeFromCss(object, key, string, compiler);
                }
            }
            for (Map.Entry entry : properties.entrySet()) {
                String value = (String)entry.getValue();
                if (value.equals("<inline attribute>") || value.equals("<data binding>") || ((String)entry.getKey()).equals("i18nProperty")) continue;
                if (handler instanceof DefaultComponentHandler) {
                    handler.setAttribute(object, (String)entry.getKey(), (String)entry.getValue(), false, compiler);
                    continue;
                }
                if (handler instanceof TabWithValidatorHandler) {
                    handler.setAttribute(object, (String)entry.getKey(), (String)entry.getValue(), false, compiler);
                    continue;
                }
                handler.setAttributeFromCss(object, (String)entry.getKey(), value, compiler);
            }
        }
        if ((pseudoClasses = StylesheetHelper.getApplicablePseudoClasses(stylesheet, object)) != null) {
            LinkedHashMap<String, Map> combinedPseudoClasses = new LinkedHashMap<String, Map>();
            for (Rule pseudoClass1 : pseudoClasses) {
                Selector[] selectors;
                for (Selector selector : selectors = pseudoClass1.getSelectors()) {
                    if (StylesheetHelper.appliesTo(selector, object) != 2) continue;
                    properties = pseudoClass1.getProperties();
                    String pseudoClass = selector.getPseudoClass();
                    Map combinedProperties = combinedPseudoClasses.computeIfAbsent(pseudoClass, k -> new HashMap());
                    combinedProperties.putAll(properties);
                }
            }
            boolean bl = false;
            for (Map.Entry e : combinedPseudoClasses.entrySet()) {
                void var8_13;
                StylesheetHelper.applyPseudoClass((String)e.getKey(), (Map)e.getValue(), object, compiler, (int)(++var8_13));
            }
        }
    }

    public static String unwrap(ClassDescriptor type, String valueCode) {
        if (ClassDescriptorHelper.getClassDescriptor(Boolean.TYPE).equals(type)) {
            return "((Boolean) " + valueCode + ").booleanValue()";
        }
        if (ClassDescriptorHelper.getClassDescriptor(Byte.TYPE).equals(type)) {
            return "((Byte) " + valueCode + ").byteValue()";
        }
        if (ClassDescriptorHelper.getClassDescriptor(Short.TYPE).equals(type)) {
            return "((Short) " + valueCode + ").shortValue()";
        }
        if (ClassDescriptorHelper.getClassDescriptor(Integer.TYPE).equals(type)) {
            return "((Integer) " + valueCode + ").intValue()";
        }
        if (ClassDescriptorHelper.getClassDescriptor(Long.TYPE).equals(type)) {
            return "((Long) " + valueCode + ").longValue()";
        }
        if (ClassDescriptorHelper.getClassDescriptor(Float.TYPE).equals(type)) {
            return "((Float) " + valueCode + ").floatValue()";
        }
        if (ClassDescriptorHelper.getClassDescriptor(Double.TYPE).equals(type)) {
            return "((Double) " + valueCode + ").doubleValue()";
        }
        if (ClassDescriptorHelper.getClassDescriptor(Character.TYPE).equals(type)) {
            return "((Character) " + valueCode + ").charValue()";
        }
        return valueCode;
    }

    public static void applyPseudoClass(String pseudoClass, Map<String, String> properties, CompiledObject object, JAXXCompiler compiler, int priority) throws CompilerException {
        String unwrappedValue;
        Class<?> typeClass;
        org.nuiton.jaxx.compiler.binding.DataBinding binding;
        String code;
        ClassDescriptor type;
        String property;
        if (pseudoClass.contains("[")) {
            pseudoClass = pseudoClass.substring(0, pseudoClass.indexOf("["));
        }
        StringBuilder buffer = new StringBuilder();
        DefaultObjectHandler handler = TagManager.getTagHandler(object.getObjectClass());
        boolean valueDeclared = false;
        String eol = JAXXCompiler.getLineSeparator();
        DataBindingHelper bindingHelper = compiler.getBindingHelper();
        String pseudoClassesPrefix = null;
        String dataBindingPrefix = null;
        if (!properties.isEmpty()) {
            pseudoClassesPrefix = compiler.getImportedType(Pseudoclasses.class);
            dataBindingPrefix = compiler.getImportedType(DataBinding.class);
        }
        String outputClassName = compiler.getImportedType(compiler.getOutputClassName());
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String valueCode;
            property = e.getKey();
            type = handler.getPropertyType(object, property, compiler);
            if (log.isDebugEnabled()) {
                log.debug("will test if databinding : [" + e.getValue() + "] type=" + type);
            }
            String dataBindingCode = compiler.processDataBindings(e.getValue());
            String simpleType = compiler.getImportedType(JAXXCompiler.getCanonicalName(type));
            if (dataBindingCode != null) {
                code = object.getId() + "." + property + "." + priority;
                valueCode = "new " + dataBindingPrefix + "(" + TypeManager.getJavaCode(code) + ")";
                binding = new org.nuiton.jaxx.compiler.binding.DataBinding(code, dataBindingCode, handler.getSetPropertyCode(object.getJavaCode(), property, "(" + simpleType + ") " + dataBindingCode, compiler), false);
                bindingHelper.registerDataBinding(binding);
            } else {
                try {
                    typeClass = type != null ? ClassDescriptorHelper.getClass(type.getName(), type.getClassLoader()) : null;
                    valueCode = TypeManager.getJavaCode(TypeManager.convertFromString(e.getValue(), typeClass));
                }
                catch (ClassNotFoundException ex) {
                    compiler.reportError("could not find class " + type.getName());
                    return;
                }
            }
            if (!valueDeclared) {
                buffer.append("Object ");
                valueDeclared = true;
            }
            buffer.append("value = ");
            buffer.append(pseudoClassesPrefix);
            buffer.append(".applyProperty(");
            buffer.append(outputClassName);
            buffer.append(".this, ");
            buffer.append(object.getJavaCode());
            buffer.append(", ");
            buffer.append(TypeManager.getJavaCode(property));
            buffer.append(", ");
            buffer.append(valueCode);
            buffer.append(", ");
            buffer.append(pseudoClassesPrefix);
            buffer.append(".wrap(");
            buffer.append(handler.getGetPropertyCode(object.getJavaCode(), property, compiler));
            buffer.append("), ");
            buffer.append(priority);
            buffer.append(");");
            buffer.append(eol);
            buffer.append("if (!(value instanceof ");
            buffer.append(dataBindingPrefix);
            buffer.append(")) {");
            buffer.append(eol);
            unwrappedValue = StylesheetHelper.unwrap(type, "value");
            buffer.append("    ");
            buffer.append(handler.getSetPropertyCode(object.getJavaCode(), property, "(" + simpleType + ") " + unwrappedValue, compiler));
            buffer.append(eol);
            buffer.append("}").append(eol);
        }
        try {
            PseudoClassEnum classEnum = PseudoClassEnum.valueOf(pseudoClass);
            pseudoClass = classEnum.getCode();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StylesheetHelper.compilePseudoClass(pseudoClass, object, buffer.toString(), 0, "add", compiler, false);
        buffer.setLength(0);
        valueDeclared = false;
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String valueCode;
            String dataBindingCode;
            property = e.getKey();
            type = handler.getPropertyType(object, property, compiler);
            String simpleType = compiler.getImportedType(JAXXCompiler.getCanonicalName(type));
            if (log.isDebugEnabled()) {
                log.debug("will test if databinding : [" + e.getValue() + "] type=" + type);
            }
            if ((dataBindingCode = compiler.processDataBindings(e.getValue())) != null) {
                code = object.getId() + "." + property + "." + priority;
                valueCode = "new " + dataBindingPrefix + "(" + TypeManager.getJavaCode(code) + ")";
                binding = new org.nuiton.jaxx.compiler.binding.DataBinding(code, dataBindingCode, handler.getSetPropertyCode(object.getJavaCode(), property, "(" + simpleType + ") " + dataBindingCode, compiler), false);
                bindingHelper.registerDataBinding(binding);
            } else {
                try {
                    typeClass = type != null ? ClassDescriptorHelper.getClass(type.getName(), type.getClassLoader()) : null;
                    valueCode = TypeManager.getJavaCode(TypeManager.convertFromString(e.getValue(), typeClass));
                }
                catch (ClassNotFoundException ex) {
                    compiler.reportError("could not find class " + type.getName());
                    return;
                }
            }
            if (!valueDeclared) {
                buffer.append("Object ");
                valueDeclared = true;
            }
            buffer.append("value = ").append(pseudoClassesPrefix).append(".removeProperty(");
            buffer.append(outputClassName);
            buffer.append(".this, ");
            buffer.append(object.getJavaCode());
            buffer.append(", ");
            buffer.append(TypeManager.getJavaCode(property));
            buffer.append(", ");
            buffer.append(valueCode);
            buffer.append(", ").append(pseudoClassesPrefix).append(".wrap(");
            buffer.append(handler.getGetPropertyCode(object.getJavaCode(), property, compiler));
            buffer.append("), ");
            buffer.append(priority);
            buffer.append(");");
            buffer.append(eol);
            buffer.append("if (!(value instanceof ");
            buffer.append(dataBindingPrefix);
            buffer.append(")) {");
            buffer.append(eol);
            unwrappedValue = StylesheetHelper.unwrap(type, "value");
            buffer.append("    ");
            buffer.append(handler.getSetPropertyCode(object.getJavaCode(), property, "(" + simpleType + ") " + unwrappedValue, compiler));
            buffer.append(eol);
            buffer.append("}").append(eol);
        }
        StylesheetHelper.compilePseudoClass(pseudoClass, object, buffer.toString(), 1, "remove", compiler, true);
    }

    public static void compilePseudoClass(String pseudoClass, CompiledObject object, String propertyCode, int pos, String methodName, JAXXCompiler compiler, boolean invertTest) throws CompilerException {
        PseudoClassDataBinding binding = PseudoClassDataBinding.newPseudoClassDataBinding(pseudoClass, object, propertyCode, methodName, invertTest);
        if (binding != null) {
            compiler.getBindingHelper().registerDataBinding(binding);
            return;
        }
        MouseEventEnum constant = MouseEventEnum.valueOf(pseudoClass);
        String property = constant.getProperty(pos);
        MethodDescriptor addMouseListener = StylesheetHelper.getAddMouseListenerMethod(object);
        MethodDescriptor methodDescriptor = StylesheetHelper.getMouseListenerMethod(object, property);
        object.addEventHandler("style." + pseudoClass + "." + methodName, addMouseListener, methodDescriptor, propertyCode, compiler);
    }

    public static Map<String, String> getApplicableProperties(Stylesheet s, CompiledObject object) throws CompilerException {
        DefaultObjectHandler handler = TagManager.getTagHandler(object.getObjectClass());
        HashMap<String, String> result = null;
        for (Rule rule : s.getRules()) {
            int apply = StylesheetHelper.appliesTo(rule, object);
            if (apply != 4 && apply != 3) continue;
            if (result == null) {
                result = new HashMap<String, String>();
            }
            for (Map.Entry entry : rule.getProperties().entrySet()) {
                String property = (String)entry.getKey();
                if (apply != 4 && !handler.isPropertyInherited(property)) continue;
                String ruleValue = ((String)entry.getValue()).replace("%%", object.getId());
                result.put(property, ruleValue);
            }
        }
        return result;
    }

    public static Rule[] getApplicablePseudoClasses(Stylesheet s, CompiledObject object) throws CompilerException {
        ArrayList<Rule> result = null;
        for (Rule rule : s.getRules()) {
            if (StylesheetHelper.appliesTo(rule, object) != 2) continue;
            if (result == null) {
                result = new ArrayList<Rule>();
            }
            result.add(rule);
        }
        return result != null ? result.toArray(new Rule[result.size()]) : null;
    }

    public static Rule inlineAttribute(CompiledObject object, String propertyName, boolean dataBinding) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(propertyName, dataBinding ? "<data binding>" : "<inline attribute>");
        return new Rule(new Selector[]{new Selector(null, null, null, object.getId(), true)}, properties);
    }

    public static int appliesTo(Rule rule, CompiledObject object) throws CompilerException {
        Selector selector;
        int appliesTo = 0;
        Selector[] selectorArray = rule.getSelectors();
        int n = selectorArray.length;
        for (int i = 0; i < n && (appliesTo = Math.max(StylesheetHelper.appliesTo(selector = selectorArray[i], object), appliesTo)) != 4 && appliesTo != 3; ++i) {
        }
        return appliesTo;
    }

    public static int appliesTo(Selector selector, CompiledObject object) {
        boolean inheritOnly = false;
        String javaClassName = selector.getJavaClassName();
        String styleClass = selector.getStyleClass();
        String pseudoClass = selector.getPseudoClass();
        String id = selector.getId();
        for (CompiledObject parent = object; parent != null; parent = parent.getParent()) {
            boolean idMatch;
            boolean classMatch;
            boolean bl = classMatch = javaClassName == null;
            if (!classMatch) {
                ClassDescriptor javaClass = parent.getObjectClass();
                do {
                    String name;
                    if (!(name = javaClass.getName()).equals(javaClassName) && !name.substring(name.lastIndexOf(".") + 1).equals(javaClassName)) continue;
                    classMatch = true;
                    break;
                } while ((javaClass = javaClass.getSuperclass()) != null);
            }
            boolean styleClassMatch = parent.matchStyleClass(styleClass);
            String objectId = parent.getId();
            objectId = objectId.substring(objectId.lastIndexOf(".") + 1);
            boolean bl2 = idMatch = id == null || (' ' + objectId + ' ').contains(' ' + id + ' ');
            if (classMatch && styleClassMatch && idMatch) {
                if (pseudoClass != null) {
                    return inheritOnly ? 1 : 2;
                }
                return inheritOnly ? 3 : 4;
            }
            inheritOnly = true;
        }
        return 0;
    }

    public static enum PseudoClassEnum {
        focused("{ object.hasFocus() }"),
        unfocused("{ !object.hasFocus() }"),
        enabled("{ object.isEnabled() }"),
        disabled("{ !object.isEnabled() }"),
        selected("{ object.isSelected() }"),
        deselected("{ !object.isSelected() }");

        final String code;

        private PseudoClassEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum MouseEventEnum {
        mouseover("mouseEntered", "mouseExited"),
        mouseout("mouseExited", "mouseReleased"),
        mousedown("mousePressed", "mousePressed"),
        mouseup("mouseReleased", "mousePressed");

        final String addMethod;
        final String removeMethod;

        private MouseEventEnum(String addMethod, String removeMethod) {
            this.removeMethod = removeMethod;
            this.addMethod = addMethod;
        }

        public String getProperty(int i) {
            return i == 0 ? this.addMethod : this.removeMethod;
        }
    }
}

