/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import io.ultreia.java4all.i18n.spi.builder.I18nModule;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompiledObjectDecorator;
import org.nuiton.jaxx.compiler.CompilerConfiguration;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import org.nuiton.jaxx.compiler.spi.Initializer;
import org.nuiton.jaxx.runtime.JAXXContext;

public class DefaultCompilerConfiguration
implements CompilerConfiguration {
    private static final Logger log = LogManager.getLogger(DefaultCompilerConfiguration.class);
    private File targetDirectory;
    private boolean optimize;
    private boolean verbose;
    private boolean profile;
    private boolean i18nable;
    private boolean addLogger;
    private boolean resetAfterCompile;
    private boolean detectAction;
    protected Class<? extends JAXXContext> jaxxContextClass;
    protected String[] extraImports;
    private Class<?> defaultErrorUI;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private Class<? extends JAXXCompiler> compilerClass;
    private Class<? extends CompiledObjectDecorator> defaultDecoratorClass;
    private boolean useUIManagerForIcon;
    private boolean generateHelp;
    private String helpBrokerFQN;
    private String validatorFactoryFQN;
    private String encoding;
    private boolean autoRecurseInCss;
    protected Map<String, CompiledObjectDecorator> decorators;
    protected Map<String, JAXXCompilerFinalizer> finalizers;
    protected Map<String, Initializer> initializers;
    private boolean showClassDescriptorLoading;
    private boolean addAutoHandlerUI;
    private boolean generateMissingIdsAndStyleClassesInCss;
    private URL commonCss;
    private I18nModule i18nModule;

    @Override
    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public boolean getOptimize() {
        return this.optimize;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public boolean isShowClassDescriptorLoading() {
        return this.showClassDescriptorLoading;
    }

    @Override
    public boolean isAddAutoHandlerUI() {
        return this.addAutoHandlerUI;
    }

    @Override
    public void setAddAutoHandlerUI(boolean addAutoHandlerUI) {
        this.addAutoHandlerUI = addAutoHandlerUI;
    }

    @Override
    public boolean isGenerateMissingIdsAndStyleClassesInCss() {
        return this.generateMissingIdsAndStyleClassesInCss;
    }

    @Override
    public void setGenerateMissingIdsAndStyleClassesInCss(boolean generateMissingIdsAndStyleClassesInCss) {
        this.generateMissingIdsAndStyleClassesInCss = generateMissingIdsAndStyleClassesInCss;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isI18nable() {
        return this.i18nable;
    }

    @Override
    public boolean isUseUIManagerForIcon() {
        return this.useUIManagerForIcon;
    }

    @Override
    public boolean isAddLogger() {
        return this.addLogger;
    }

    @Override
    public Class<? extends JAXXContext> getJaxxContextClass() {
        return this.jaxxContextClass;
    }

    @Override
    public String[] getExtraImports() {
        return this.extraImports;
    }

    @Override
    public boolean isResetAfterCompile() {
        return this.resetAfterCompile;
    }

    @Override
    public boolean isOptimize() {
        return this.optimize;
    }

    @Override
    public Class<?> getDefaultErrorUI() {
        return this.defaultErrorUI;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Class<? extends JAXXCompiler> getCompilerClass() {
        return this.compilerClass;
    }

    @Override
    public Class<? extends CompiledObjectDecorator> getDefaultDecoratorClass() {
        return this.defaultDecoratorClass;
    }

    @Override
    public boolean isProfile() {
        return this.profile;
    }

    @Override
    public boolean isGenerateHelp() {
        return this.generateHelp;
    }

    @Override
    public String getHelpBrokerFQN() {
        return this.helpBrokerFQN;
    }

    @Override
    public String getValidatorFactoryFQN() {
        return this.validatorFactoryFQN;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Map<String, CompiledObjectDecorator> getDecorators() {
        if (this.decorators == null) {
            this.decorators = new TreeMap<String, CompiledObjectDecorator>();
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            if (log.isInfoEnabled()) {
                log.info("with cl " + classloader);
            }
            ServiceLoader<CompiledObjectDecorator> services = ServiceLoader.load(CompiledObjectDecorator.class, classloader);
            for (CompiledObjectDecorator decorator : services) {
                if (log.isInfoEnabled()) {
                    log.info("detected " + decorator);
                }
                this.decorators.put(decorator.getName(), decorator);
            }
        }
        return this.decorators;
    }

    @Override
    public Map<String, JAXXCompilerFinalizer> getFinalizers() {
        if (this.finalizers == null) {
            this.finalizers = new TreeMap<String, JAXXCompilerFinalizer>();
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            if (log.isInfoEnabled()) {
                log.info("with cl " + classloader);
            }
            ServiceLoader<JAXXCompilerFinalizer> services = ServiceLoader.load(JAXXCompilerFinalizer.class, classloader);
            for (JAXXCompilerFinalizer finalizer : services) {
                if (log.isInfoEnabled()) {
                    log.info("detected " + finalizer);
                }
                this.finalizers.put(finalizer.getClass().getName(), finalizer);
            }
        }
        return this.finalizers;
    }

    @Override
    public Map<String, Initializer> getInitializers() {
        if (this.initializers == null) {
            this.initializers = new TreeMap<String, Initializer>();
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            if (log.isInfoEnabled()) {
                log.info("with cl " + classloader);
            }
            ServiceLoader<Initializer> loader = ServiceLoader.load(Initializer.class, classloader);
            for (Initializer initializer : loader) {
                if (log.isInfoEnabled()) {
                    log.info("detected " + initializer);
                }
                this.initializers.put(initializer.getClass().getName(), initializer);
            }
        }
        return this.initializers;
    }

    @Override
    public URL getCommonCss() {
        return this.commonCss;
    }

    @Override
    public String getCssExtension() {
        return "jcss";
    }

    @Override
    public I18nModule getI18nModule() {
        return this.i18nModule;
    }

    @Override
    public void setI18nModule(I18nModule i18nModule) {
        this.i18nModule = i18nModule;
    }

    public void setCommonCss(URL commonCss) {
        this.commonCss = commonCss;
    }

    @Override
    public boolean isAutoRecurseInCss() {
        return this.autoRecurseInCss;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean isDetectAction() {
        return this.detectAction;
    }

    @Override
    public void setDetectAction(boolean detectAction) {
        this.detectAction = detectAction;
    }
}

