/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.reflect.resolvers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXFactory;
import org.nuiton.jaxx.compiler.java.parser.JavaParser;
import org.nuiton.jaxx.compiler.java.parser.ParseException;
import org.nuiton.jaxx.compiler.java.parser.SimpleNode;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorResolver;
import org.nuiton.jaxx.compiler.reflect.FieldDescriptor;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.tags.TagManager;
import org.nuiton.jaxx.runtime.JAXXUtil;

public class ClassDescriptorResolverFromJavaFile
extends ClassDescriptorResolver {
    private static final Logger log = LogManager.getLogger(ClassDescriptorResolverFromJavaFile.class);
    private final boolean parseMethodBody;

    public ClassDescriptorResolverFromJavaFile() {
        this(false);
    }

    public ClassDescriptorResolverFromJavaFile(boolean parseMethodBody) {
        super(ClassDescriptorHelper.ResolverType.JAVA_FILE);
        this.parseMethodBody = parseMethodBody;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassDescriptor resolvDescriptor(String className, URL source) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClassLoader();
        try (InputStreamReader reader = new InputStreamReader(source.openStream(), "utf-8");){
            String displayName = source.toString();
            if (log.isDebugEnabled()) {
                log.debug("for source " + displayName);
            }
            JavaFileParser parser = new JavaFileParser(classLoader, this.parseMethodBody);
            if (log.isDebugEnabled()) {
                log.debug("starting parsing : " + displayName);
            }
            try {
                parser.doParse(displayName, reader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            JavaFileClassDescriptor javaFileClassDescriptor = new JavaFileClassDescriptor(parser, classLoader);
            return javaFileClassDescriptor;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Could not resolv descriptor from source " + source, e);
        }
    }

    public static class JavaFileParser {
        private static final Logger log = LogManager.getLogger(JavaFileParser.class);
        private final JAXXCompiler compiler;
        private String className;
        private String packageName;
        private String superclass;
        private boolean isEnum;
        private boolean isInterface;
        private final Set<String> interfaces;
        private final List<MethodDescriptor> methods;
        private final List<MethodDescriptor> constructors;
        private final List<FieldDescriptor> fields;
        private final List<FieldDescriptor> declaredFields;
        private String jaxxObjectDescriptorValue;
        public static final String[] EMPTY_STRING_ARRAY = new String[0];
        private final boolean parseMethodBody;
        private boolean firstTypeScanned;
        Map<String, String> typeParameters = new LinkedHashMap<String, String>();

        protected JavaFileParser(ClassLoader classLoader, boolean parseMethodBody) {
            this.parseMethodBody = parseMethodBody;
            this.compiler = JAXXFactory.newDummyCompiler(classLoader);
            this.methods = new ArrayList<MethodDescriptor>();
            this.constructors = new ArrayList<MethodDescriptor>();
            this.interfaces = new HashSet<String>();
            this.fields = new ArrayList<FieldDescriptor>();
            this.declaredFields = new ArrayList<FieldDescriptor>();
            this.superclass = Object.class.getName();
        }

        public void doParse(String className, Reader src) throws ClassNotFoundException {
            this.firstTypeScanned = false;
            try {
                JavaParser p = new JavaParser(src, this.parseMethodBody);
                p.CompilationUnit();
                SimpleNode node = p.popNode();
                if (node != null) {
                    this.scanCompilationUnit(node);
                    if (this.isInterface) {
                        this.superclass = null;
                        if (!this.interfaces.isEmpty()) {
                            for (String anInterface : this.interfaces) {
                                ClassDescriptor superclassDescriptor = ClassDescriptorHelper.getClassDescriptor(anInterface, this.compiler.getClassLoader());
                                this.methods.addAll(Arrays.asList(superclassDescriptor.getMethodDescriptors()));
                                this.fields.addAll(Arrays.asList(superclassDescriptor.getFieldDescriptors()));
                            }
                        }
                    }
                    if (this.isEnum) {
                        this.superclass = Enum.class.getName();
                    }
                    if (this.superclass != null) {
                        ClassDescriptor superclassDescriptor = ClassDescriptorHelper.getClassDescriptor(this.superclass, this.compiler.getClassLoader());
                        this.methods.addAll(Arrays.asList(superclassDescriptor.getMethodDescriptors()));
                        this.fields.addAll(Arrays.asList(superclassDescriptor.getFieldDescriptors()));
                        this.declaredFields.addAll(Arrays.asList(superclassDescriptor.getDeclaredFieldDescriptors()));
                    }
                    return;
                }
                throw new CompilerException("Internal error: null node parsing Java file from " + src);
            }
            catch (ParseException e) {
                throw new CompilerException("Error parsing Java source code " + className + ": " + e.getMessage());
            }
        }

        private void scanCompilationUnit(SimpleNode node) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = node.getChild(i);
                this.scanCompilationUnitChild(child);
            }
        }

        private void scanCompilationUnitChild(SimpleNode child) {
            if (this.firstTypeScanned) {
                if (log.isWarnEnabled()) {
                    log.warn("There is more than one type in current file, skip next type...");
                }
                return;
            }
            int nodeType = child.getId();
            switch (nodeType) {
                case 2: {
                    this.packageName = child.getChild(1).getText().trim();
                    this.compiler.addImport(this.packageName + ".*");
                    this.compiler.addImport("java.lang.*");
                    break;
                }
                case 3: {
                    String text = child.getText().trim();
                    int importIndex = text.indexOf("import");
                    if (importIndex > -1) {
                        text = text.substring(importIndex + "import".length()).trim();
                    }
                    if (text.endsWith(";")) {
                        text = text.substring(0, text.length() - 1);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("import " + text);
                    }
                    this.compiler.addImport(text);
                    break;
                }
                case 5: {
                    this.scanCompilationUnit(child);
                    break;
                }
                case 6: {
                    this.isInterface = child.firstToken.image.equals("interface");
                    this.scanClass(child);
                    break;
                }
                case 9: {
                    this.isEnum = child.firstToken.image.equals("enum");
                    this.scanClass(child);
                }
            }
        }

        private void scanClass(SimpleNode node) {
            this.firstTypeScanned = true;
            this.className = node.firstToken.next.image;
            if (this.packageName != null) {
                this.className = this.packageName + "." + this.className;
            }
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                String rawName;
                SimpleNode child = node.getChild(i);
                int nodeType = child.getId();
                if (nodeType == 12) {
                    for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
                        SimpleNode typeChild = child.getChild(j);
                        String typeTypeName = typeChild.firstToken.next.next.toString();
                        this.typeParameters.put(typeChild.firstToken.toString(), TagManager.resolveClassName(typeTypeName, this.compiler));
                    }
                    continue;
                }
                if (nodeType == 8) {
                    if (log.isDebugEnabled()) {
                        log.debug("[" + this.className + "] Found a implements list " + child + " :: " + child.jjtGetNumChildren());
                    }
                    for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
                        rawName = child.getChild(j).getText().trim();
                        this.addInterface(rawName);
                    }
                    continue;
                }
                if (nodeType == 7) {
                    if (this.isInterface) {
                        for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
                            rawName = child.getChild(j).getText().trim();
                            this.addInterface(rawName);
                        }
                        continue;
                    }
                    assert (child.jjtGetNumChildren() == 1) : "expected ExtendsList to have exactly one child for a non-interface class";
                    String rawName2 = child.getChild(0).getText().trim();
                    this.superclass = TagManager.resolveClassName(rawName2, this.compiler);
                    if (this.superclass == null) {
                        throw new CompilerException("Could not find class: " + rawName2);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Set superClass = " + this.superclass);
                    continue;
                }
                if (nodeType != 15) continue;
                this.scanClassNode(child);
            }
        }

        private void scanClassNode(SimpleNode node) {
            int nodeType = node.getId();
            switch (nodeType) {
                case 6: {
                    break;
                }
                case 26: {
                    this.scanConstructorDeclaration(node);
                    break;
                }
                case 22: {
                    this.scanMethodDeclaration(node);
                    break;
                }
                case 17: {
                    this.scanFieldDeclaration(node);
                    break;
                }
                default: {
                    for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                        SimpleNode child = node.getChild(i);
                        this.scanClassNode(child);
                    }
                }
            }
        }

        protected void scanFieldDeclaration(SimpleNode node) {
            int lastIndexSpace;
            String name;
            String text;
            String declaration = text = node.getText();
            String value = null;
            int equals = text.indexOf("=");
            if (equals != -1) {
                value = declaration.substring(equals + 1).trim();
                declaration = declaration.substring(0, equals);
            }
            declaration = declaration.trim();
            int modifiers = this.isInterface ? 25 : this.getModifiers(node);
            if (log.isDebugEnabled()) {
                log.debug("field [" + declaration + "] modifiers == " + Modifier.toString(modifiers));
            }
            if ((name = declaration.substring(lastIndexSpace = declaration.trim().lastIndexOf(" ")).trim()).endsWith(";")) {
                name = name.substring(0, name.length() - 1).trim();
            }
            String cName = declaration.substring(0, lastIndexSpace).trim();
            String type = this.getType(cName);
            FieldDescriptor descriptor = new FieldDescriptor(name, modifiers, type, this.compiler.getClassLoader());
            if ("$jaxxObjectDescriptor".equals(name) && value != null) {
                int firstIndex = value.indexOf("\"");
                int lastIndex = value.lastIndexOf("\"");
                this.jaxxObjectDescriptorValue = value.substring(firstIndex + 1, lastIndex);
                if (log.isDebugEnabled()) {
                    log.debug("detected a $jaxxObjectDescriptor = " + this.jaxxObjectDescriptorValue);
                }
            }
            if (Modifier.isPublic(modifiers)) {
                this.fields.add(descriptor);
            } else {
                this.declaredFields.add(descriptor);
            }
        }

        protected void scanConstructorDeclaration(SimpleNode node) {
            String name = null;
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = node.getChild(i);
                int type = child.getId();
                if (type == 24 && child.jjtGetNumChildren() > 0) {
                    SimpleNode parameter = child.getChild(0);
                    String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                    String parameterType = this.getType(rawParameterType);
                    if (parameterType == null && JAXXCompiler.STRICT_CHECKS) {
                        throw new CompilerException("could not find class '" + rawParameterType + "'");
                    }
                    parameterTypes.add(parameterType);
                    continue;
                }
                if (type != 23) continue;
                name = child.firstToken.image.trim();
                SimpleNode formalParameters = child.getChild(0);
                assert (formalParameters.getId() == 24);
                for (int j = 0; j < formalParameters.jjtGetNumChildren(); ++j) {
                    SimpleNode parameter = formalParameters.getChild(j);
                    String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                    String parameterType = this.getType(rawParameterType);
                    if (parameterType == null && JAXXCompiler.STRICT_CHECKS) {
                        throw new CompilerException("could not find class '" + rawParameterType + "'");
                    }
                    parameterTypes.add(parameterType);
                }
            }
            int modifiers = this.getModifiers(node);
            if (this.isInterface) {
                modifiers = 1;
            }
            if (log.isDebugEnabled()) {
                log.debug("method [" + name + "] modifiers == " + Modifier.toString(modifiers));
            }
            MethodDescriptor methodDescriptor = new MethodDescriptor(name, modifiers, null, parameterTypes.toArray(new String[parameterTypes.size()]), this.compiler.getClassLoader());
            this.constructors.add(methodDescriptor);
        }

        private String getType(String cName) {
            String result = this.compiler.getImportedTypeForSimpleName(cName);
            if (result == null) {
                result = this.typeParameters.getOrDefault(cName, TagManager.resolveClassName(cName, this.compiler));
            }
            return result;
        }

        protected void scanMethodDeclaration(SimpleNode node) {
            String returnType = null;
            String name = null;
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = node.getChild(i);
                int type = child.getId();
                if (type == 36) {
                    String cName = child.firstToken.image.trim();
                    returnType = this.getType(cName);
                    continue;
                }
                if (type != 23) continue;
                name = child.firstToken.image.trim();
                SimpleNode formalParameters = child.getChild(0);
                assert (formalParameters.getId() == 24);
                for (int j = 0; j < formalParameters.jjtGetNumChildren(); ++j) {
                    SimpleNode parameter = formalParameters.getChild(j);
                    String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                    String parameterType = this.getType(rawParameterType);
                    if (parameterType == null && JAXXCompiler.STRICT_CHECKS) {
                        throw new CompilerException("could not find class '" + rawParameterType + "'");
                    }
                    parameterTypes.add(parameterType);
                }
            }
            int modifiers = this.getModifiers(node);
            if (this.isInterface) {
                modifiers = 1;
            }
            if (log.isDebugEnabled()) {
                log.debug("method [" + name + "] modifiers == " + Modifier.toString(modifiers));
            }
            MethodDescriptor methodDescriptor = new MethodDescriptor(name, modifiers, returnType, parameterTypes.toArray(new String[parameterTypes.size()]), this.compiler.getClassLoader());
            if (Modifier.isPublic(modifiers)) {
                this.methods.add(methodDescriptor);
            }
        }

        protected void addInterface(String rawName) {
            String myInterface;
            if (rawName.contains("<")) {
                rawName = rawName.substring(0, rawName.indexOf("<"));
            }
            if (log.isDebugEnabled()) {
                log.debug("[" + this.className + "]  try to obtain type of interface " + rawName);
            }
            if ((myInterface = this.resolveFullyQualifiedName(rawName)) == null) {
                throw new CompilerException("Could not find interface: " + myInterface);
            }
            if (!this.interfaces.contains(myInterface)) {
                if (log.isDebugEnabled()) {
                    log.debug("[" + this.className + "] add interface " + myInterface);
                }
                this.interfaces.add(myInterface);
            }
        }

        protected String resolveFullyQualifiedName(String rawName) {
            String result;
            String realRawName = null;
            String realParentRawName = null;
            if (rawName.contains(".")) {
                int index = rawName.lastIndexOf(".");
                realParentRawName = rawName.substring(0, index);
                realRawName = rawName.substring(index + 1);
                if (log.isDebugEnabled()) {
                    log.debug("inner class detected ? " + realParentRawName + "//" + realRawName);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("try fqn = " + rawName);
            }
            if ((result = TagManager.resolveClassName(rawName, this.compiler)) != null) {
                return result;
            }
            String suffix = "." + rawName;
            if (realParentRawName != null) {
                suffix = "." + realParentRawName;
            }
            for (String aClass : this.compiler.getImportedClasses()) {
                if (!aClass.endsWith(suffix)) continue;
                if (realRawName != null) {
                    aClass = aClass + "." + realRawName;
                }
                return aClass;
            }
            Set<String> importedPackages = this.compiler.getImportedPackages();
            for (String aClass : importedPackages) {
                String fqn = aClass + rawName;
                if (log.isDebugEnabled()) {
                    log.debug("try fqn = " + fqn);
                }
                if ((result = TagManager.resolveClassName(fqn, this.compiler)) == null) continue;
                return result;
            }
            return null;
        }

        protected int getModifiers(SimpleNode node) {
            SimpleNode parentNode = node.getParent();
            for (int i = 0; i < parentNode.jjtGetNumChildren(); ++i) {
                SimpleNode child = parentNode.getChild(i);
                if (child.getId() != 4) continue;
                String modifiersStr = child.getText().trim();
                return this.scanModifiers(modifiersStr);
            }
            return 0;
        }

        protected int scanModifiers(String modifiersStr) {
            int modifiers = 0;
            if (modifiersStr.contains("public")) {
                modifiers |= 1;
            }
            if (modifiersStr.contains("protected")) {
                modifiers |= 4;
            }
            if (modifiersStr.contains("private")) {
                modifiers |= 2;
            }
            if (modifiersStr.contains("static")) {
                modifiers |= 8;
            }
            if (modifiersStr.contains("final")) {
                modifiers |= 0x10;
            }
            if (modifiersStr.contains("volatile")) {
                modifiers |= 0x40;
            }
            if (modifiersStr.contains("transient")) {
                modifiers |= 0x80;
            }
            if (modifiersStr.contains("synchronized")) {
                modifiers |= 0x20;
            }
            if (modifiersStr.contains("abstract")) {
                modifiers |= 0x400;
            }
            return modifiers;
        }
    }

    private class JavaFileClassDescriptor
    extends ClassDescriptor {
        public JavaFileClassDescriptor(JavaFileParser parser, ClassLoader classLoader) {
            super(ClassDescriptorResolverFromJavaFile.this.getResolverType(), parser.className, parser.packageName, parser.superclass, parser.interfaces.toArray(new String[parser.interfaces.size()]), parser.isInterface, false, null, parser.jaxxObjectDescriptorValue == null ? null : JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)parser.jaxxObjectDescriptorValue), classLoader, parser.constructors.toArray(new MethodDescriptor[parser.constructors.size()]), parser.methods.toArray(new MethodDescriptor[parser.methods.size()]), parser.fields.toArray(new FieldDescriptor[parser.fields.size()]), parser.declaredFields.toArray(new FieldDescriptor[parser.declaredFields.size()]));
        }

        @Override
        public Optional<MethodDescriptor> tryToGetDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) {
            return Optional.empty();
        }

        @Override
        public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
            throw new NoSuchMethodException(name);
        }
    }
}

