/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import java.awt.Color;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.I18nHelper;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.TagHandler;
import org.nuiton.jaxx.compiler.tags.swing.JTabbedPaneHandler;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TabHandler
implements TagHandler {
    public static final String TAG_NAME = "tab";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_TITLE = "title";
    public static final String ATTRIBUTE_TOOL_TIP_TEXT = "toolTipText";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_ENABLED = "enabled";
    public static final String ATTRIBUTE_DISABLED_ICON = "disabledIcon";
    public static final String ATTRIBUTE_MNEMONIC = "mnemonic";
    public static final String ATTRIBUTE_DISPLAYED_MNEMONIC_INDEX = "displayedMnemonicIndex";
    public static final String ATTRIBUTE_FOREGROUND = "foreground";
    public static final String ATTRIBUTE_BACKGROUND = "background";
    public static final String ATTRIBUTE_TAB_COMPONENT = "tabComponent";

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (!ClassDescriptorHelper.getClassDescriptor(JTabbedPane.class).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError("tab tag may only appear within JTabbedPane tag");
            return;
        }
        JTabbedPaneHandler.CompiledTabbedPane tabs = (JTabbedPaneHandler.CompiledTabbedPane)compiler.getOpenComponent();
        String id = tag.getAttribute(ATTRIBUTE_ID);
        if (id == null || id.length() == 0) {
            id = compiler.getAutoId(TabInfo.class.getSimpleName());
        }
        TabInfo tabInfo = new TabInfo(id);
        CompiledObject compiledTabInfo = new CompiledObject(id, ClassDescriptorHelper.getClassDescriptor(TabInfo.class), compiler);
        compiler.registerCompiledObject(compiledTabInfo);
        compiledTabInfo.setConstructorParams("\"" + id + "\"");
        tabs.tabInfo = tabInfo;
        this.setAttributes(compiledTabInfo, tabs, tag, compiler);
        this.compileChildrenSecondPass(tag, compiler);
        tabs.tabInfo = null;
    }

    public static void setAttribute(CompiledObject compiledTabInfo, JTabbedPaneHandler.CompiledTabbedPane tabs, String name, String value, JAXXCompiler compiler) throws CompilerException {
        value = value.trim();
        TabInfo tabInfo = tabs.tabInfo;
        String id = tabInfo.getId();
        String binding = compiler.processDataBindings(value);
        if (binding != null) {
            compiler.getBindingHelper().registerDataBinding(id + "." + name, binding, id + ".set" + StringUtils.capitalize((String)name) + "(" + binding + ");");
            return;
        }
        String valueCode = TypeManager.getJavaCode(value);
        if (name.equals("i18nProperty")) {
            if ("skip".equals(value)) {
                return;
            }
            compiledTabInfo.setI18nProperty(StringUtils.isEmpty((CharSequence)value) ? id : value);
            String i18nKey = compiler.computeI18nProperty(compiledTabInfo);
            String i18nProperty = compiler.getI18nProperty(compiledTabInfo);
            TabHandler.setAttribute(compiledTabInfo, tabs, i18nProperty, i18nKey, compiler);
            return;
        }
        if (I18nHelper.isI18nableAttribute(name, compiler)) {
            value = valueCode = I18nHelper.addI18nInvocation(id, name, valueCode, compiler);
        }
        if (!name.equals(ATTRIBUTE_ID)) {
            if (name.equals(ATTRIBUTE_TITLE)) {
                tabInfo.setTitle(value);
                compiledTabInfo.appendInitializationCode(id + ".setTitle(" + valueCode + ");");
            } else if (name.equals(ATTRIBUTE_TOOL_TIP_TEXT)) {
                tabInfo.setToolTipText(value);
                compiledTabInfo.appendInitializationCode(id + ".setToolTipText(" + valueCode + ");");
            } else if (name.equals(ATTRIBUTE_ICON)) {
                Icon icon = (Icon)TypeManager.convertFromString(value, Icon.class);
                tabInfo.setIcon(icon);
                compiledTabInfo.appendInitializationCode(id + ".setIcon(" + TypeManager.getJavaCode(icon) + ");");
            } else if (name.equals(ATTRIBUTE_ENABLED)) {
                boolean enabled = (Boolean)TypeManager.convertFromString(value, Boolean.class);
                tabInfo.setEnabled(enabled);
                compiledTabInfo.appendInitializationCode(id + ".setEnabled(" + enabled + ");");
            } else if (name.equals(ATTRIBUTE_DISABLED_ICON)) {
                Icon disabledIcon = (Icon)TypeManager.convertFromString(value, Icon.class);
                tabInfo.setDisabledIcon(disabledIcon);
                compiledTabInfo.appendInitializationCode(id + ".setDisabledIcon(" + TypeManager.getJavaCode(disabledIcon) + ");");
            } else if (name.equals(ATTRIBUTE_MNEMONIC)) {
                char mnemonic = ((Character)TypeManager.convertFromString(value, Character.TYPE)).charValue();
                tabInfo.setMnemonic((int)mnemonic);
                compiledTabInfo.appendInitializationCode(id + ".setMnemonic(" + mnemonic + ");");
            } else if (name.equals(ATTRIBUTE_DISPLAYED_MNEMONIC_INDEX)) {
                int displayedMnemonicIndex = (Integer)TypeManager.convertFromString(value, Integer.TYPE);
                tabInfo.setDisplayedMnemonicIndex(displayedMnemonicIndex);
                compiledTabInfo.appendInitializationCode(id + ".setDisplayedMnemonicIndex(" + displayedMnemonicIndex + ");");
            } else if (name.equals(ATTRIBUTE_FOREGROUND)) {
                Color foreground = (Color)TypeManager.convertFromString(value, Color.class);
                tabInfo.setForeground(foreground);
                compiledTabInfo.appendInitializationCode(id + ".setForeground(" + TypeManager.getJavaCode(foreground) + ");");
            } else if (name.equals(ATTRIBUTE_BACKGROUND)) {
                Color background = (Color)TypeManager.convertFromString(value, Color.class);
                tabInfo.setBackground(background);
                compiledTabInfo.appendInitializationCode(id + ".setBackground(" + TypeManager.getJavaCode(background) + ");");
            } else if (name.equals(ATTRIBUTE_TAB_COMPONENT)) {
                tabInfo.setTabComponentStr(TypeManager.getJavaCode(value));
                compiledTabInfo.appendInitializationCode(id + ".setTabComponent(" + TypeManager.getJavaCode(value) + ");");
            } else {
                compiler.reportError("The <tab> tag does not support the attribute '" + name + "'");
            }
        }
    }

    public void setAttributes(CompiledObject compiledTabInfo, JTabbedPaneHandler.CompiledTabbedPane tabs, Element tag, JAXXCompiler compiler) throws CompilerException {
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            Attr attribute = (Attr)children.item(i);
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            TabHandler.setAttribute(compiledTabInfo, tabs, name, value, compiler);
        }
    }

    protected void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagFirstPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    protected void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }
}

