/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.DefaultComponentHandler;

public class JScrollPaneHandler
extends DefaultComponentHandler {
    public JScrollPaneHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, JScrollPane.class);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new JScrollPaneCompiledObject(id, this.getBeanClass(), compiler);
    }

    public static class JScrollPaneCompiledObject
    extends CompiledObject {
        boolean hasChild;
        boolean hasColumnViewHeader;
        public static final String COLUMN_HEADER_VIEW = "columnHeaderView";

        public JScrollPaneCompiledObject(String id, ClassDescriptor beanclass, JAXXCompiler compiler) {
            super(id, beanclass, compiler);
        }

        @Override
        public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
            if (constraints != null) {
                compiler.reportError("JScrollPane does not accept constraints");
            }
            if (!this.hasChild) {
                super.addChild(child, constraints, compiler);
                this.hasChild = true;
                return;
            }
            if (!this.hasColumnViewHeader) {
                String property = (String)this.getProperties().get(COLUMN_HEADER_VIEW);
                if (log.isDebugEnabled()) {
                    log.info("property to match " + property + " against child " + child.getId());
                }
                if (!StringUtils.isEmpty((CharSequence)property) && ("{" + child.getId() + "}").equals(property)) {
                    this.hasColumnViewHeader = true;
                    return;
                }
            }
            compiler.reportError("JScrollPane may only have one child (found another child : " + child.getId() + ").");
        }
    }
}

