/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags;

import java.io.IOException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.UnsupportedAttributeException;
import org.nuiton.jaxx.compiler.css.StylesheetHelper;
import org.nuiton.jaxx.compiler.css.parser.ParseException;
import org.nuiton.jaxx.compiler.tags.TagHandler;
import org.nuiton.jaxx.runtime.css.Stylesheet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StyleHandler
implements TagHandler {
    private static final Logger log = LogManager.getLogger(StyleHandler.class);
    public static final String TAG_NAME = "style";
    public static final String SOURCE_ATTRIBUTE = "source";

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException {
        boolean source = false;
        NamedNodeMap attributes = tag.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getName();
            String attrValue = attribute.getValue();
            if (name.equals(SOURCE_ATTRIBUTE)) {
                source = true;
                try {
                    URL resource = StylesheetHelper.getStyleURL(attrValue, compiler.getBaseDir(), compiler.getClassLoader());
                    if (compiler.getEngine().isVerbose()) {
                        log.info("import css " + resource);
                    }
                    compiler.registerStyleSheetFile(resource, true);
                }
                catch (IOException e) {
                    compiler.reportError(tag, "stylesheet file not found: " + attrValue);
                }
                continue;
            }
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            throw new UnsupportedAttributeException(name);
        }
        StringBuilder style = new StringBuilder();
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    compiler.reportError("<style> tag may not contain child elements: " + tag);
                }
                case 3: 
                case 4: {
                    style.append(((Text)child).getData());
                }
            }
        }
        String styleString = style.toString().trim();
        if (styleString.length() > 0) {
            if (source) {
                compiler.reportError("<style> tag has both a source attribute and an inline stylesheet");
            }
            try {
                Stylesheet stylesheet = StylesheetHelper.processStylesheet(style.toString());
                compiler.registerStylesheet(stylesheet);
            }
            catch (CompilerException e) {
                String message = "Inline Css content is not valid";
                if (e instanceof ParseException) {
                    ParseException parseException = (ParseException)e;
                    message = message + " (line: " + parseException.getLine() + " - col:" + parseException.getColumn() + ") ";
                }
                compiler.reportError(message, e);
            }
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException {
    }
}

