/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXEngine;
import org.nuiton.jaxx.compiler.JAXXFactory;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorResolver;
import org.nuiton.jaxx.compiler.reflect.FieldDescriptor;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.reflect.resolvers.ClassDescriptorResolverFromJavaClass;
import org.nuiton.jaxx.compiler.reflect.resolvers.ClassDescriptorResolverFromJavaFile;
import org.nuiton.jaxx.compiler.reflect.resolvers.ClassDescriptorResolverFromJaxxFile;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;

public class ClassDescriptorHelper {
    private static final Logger log = LogManager.getLogger(ClassDescriptorHelper.class);
    private static boolean SHOW_LOADING = log.isDebugEnabled();
    private static final Map<String, ClassDescriptor> descriptors = new HashMap<String, ClassDescriptor>();
    private static Map<ResolverType, ClassDescriptorResolver> descriptorResolvers;

    protected static Map<ResolverType, ClassDescriptorResolver> getDescriptorResolvers() {
        if (descriptorResolvers == null) {
            descriptorResolvers = new EnumMap<ResolverType, ClassDescriptorResolver>(ResolverType.class);
            descriptorResolvers.put(ResolverType.JAVA_CLASS, new ClassDescriptorResolverFromJavaClass());
            descriptorResolvers.put(ResolverType.JAVA_FILE, new ClassDescriptorResolverFromJavaFile());
            descriptorResolvers.put(ResolverType.JAXX_FILE, new ClassDescriptorResolverFromJaxxFile());
        }
        return descriptorResolvers;
    }

    private ClassDescriptorHelper() {
    }

    public static boolean isAssignableFrom(ClassDescriptor classDescriptor, Class<?> awareClass) {
        ClassDescriptor awareDescriptor = ClassDescriptorHelper.getClassDescriptor(awareClass);
        return awareDescriptor.isAssignableFrom(classDescriptor);
    }

    public static ClassDescriptor getClassDescriptor(String className) throws ClassNotFoundException {
        return ClassDescriptorHelper.getClassDescriptor(className, Thread.currentThread().getContextClassLoader());
    }

    public static ClassDescriptor getClassDescriptor(Class<?> javaClass) {
        try {
            return ClassDescriptorHelper.getClassDescriptor(javaClass.getName(), javaClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getURL(ClassLoader classLoader, String className, String clasifier) {
        String relativePath = className.replaceAll("\\.", "/");
        String path = relativePath + "." + clasifier;
        if (log.isDebugEnabled()) {
            log.debug("Path to search : " + path);
        }
        return classLoader.getResource(path);
    }

    public static ClassDescriptor getClassDescriptor(String className, ClassLoader classLoader) throws ClassNotFoundException {
        JAXXCompilerFile file;
        ClassDescriptor result;
        if (classLoader == null) {
            classLoader = ClassDescriptorHelper.class.getClassLoader();
        }
        if ((result = descriptors.get(className)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("resolved " + result + " from cache.");
            }
            return result;
        }
        JAXXEngine engine = JAXXFactory.isEngineRegistred() ? JAXXFactory.getEngine() : null;
        String relativePathPattern = ".*";
        if (engine != null && (file = engine.getJAXXCompilerFile(className)) != null) {
            if (SHOW_LOADING) {
                log.info("from JAXXFile " + file.getJaxxFile());
            }
            result = ClassDescriptorHelper.getClassDescriptor0(ResolverType.JAXX_FILE, className, file.getJAXXFileURL(), classLoader);
            if (log.isDebugEnabled()) {
                log.debug("[" + className + "] loaded");
            }
            return result;
        }
        long javaLastModified = -1L;
        URL javaFile = ClassDescriptorHelper.getURL(classLoader, className, "java");
        if (javaFile != null && javaFile.toString().startsWith("file:") && javaFile.toString().matches(relativePathPattern)) {
            javaLastModified = JAXXCompiler.URLtoFile(javaFile).lastModified();
            if (log.isTraceEnabled()) {
                log.trace("[" + className + "] javaFile lastModified " + javaLastModified);
            }
        }
        long classLastModified = -1L;
        URL classFile = ClassDescriptorHelper.getURL(classLoader, className, "class");
        if (classFile != null && classFile.toString().startsWith("file:") && classFile.toString().matches(relativePathPattern)) {
            classLastModified = JAXXCompiler.URLtoFile(classFile).lastModified();
            if (log.isTraceEnabled()) {
                log.trace("[" + className + "] class lastModified " + classLastModified);
            }
        }
        if (javaLastModified != -1L && javaLastModified > classLastModified) {
            if (SHOW_LOADING) {
                log.info("from JavaFile " + javaFile);
            }
            result = ClassDescriptorHelper.getClassDescriptor0(ResolverType.JAVA_FILE, className, javaFile, classLoader);
            if (log.isDebugEnabled()) {
                log.debug("[" + className + "] loaded");
            }
            return result;
        }
        if (SHOW_LOADING) {
            log.info("from class " + className);
        }
        result = ClassDescriptorHelper.getClassDescriptor0(ResolverType.JAVA_CLASS, className, classFile, classLoader);
        if (log.isDebugEnabled()) {
            log.debug("[" + className + "] loaded");
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Can not find descriptor for " + className);
    }

    protected static ClassDescriptor getClassDescriptor0(ResolverType resolverType, String className, URL source, ClassLoader classLoader) throws ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("Loading class descriptor for [" + className + "] with " + (Object)((Object)resolverType));
        }
        Map<ResolverType, ClassDescriptorResolver> resolvers = ClassDescriptorHelper.getDescriptorResolvers();
        ClassDescriptorResolver resolver = resolvers.get((Object)resolverType);
        resolver.setClassLoader(classLoader);
        ClassDescriptor result = resolver.resolvDescriptor(className, source);
        if (result != null) {
            descriptors.put(className, result);
        }
        return result;
    }

    public static Class<?> getPrimitiveBoxedClass(String className) {
        if (className.equals("boolean")) {
            return Boolean.class;
        }
        if (className.equals("byte")) {
            return Byte.class;
        }
        if (className.equals("short")) {
            return Short.class;
        }
        if (className.equals("int")) {
            return Integer.class;
        }
        if (className.equals("long")) {
            return Long.class;
        }
        if (className.equals("float")) {
            return Float.class;
        }
        if (className.equals("double")) {
            return Double.class;
        }
        if (className.equals("char")) {
            return Character.class;
        }
        if (className.equals("void")) {
            return Void.class;
        }
        return null;
    }

    public static Class<?> getPrimitiveClass(String className) throws ClassNotFoundException {
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("void")) {
            return Void.TYPE;
        }
        int arrayCount = 0;
        while (className.endsWith("[]")) {
            ++arrayCount;
            className = className.substring(0, className.length() - 2);
        }
        if (arrayCount > 0) {
            Class<?> klass = ClassDescriptorHelper.getPrimitiveClass(className);
            if (klass == null) {
                return null;
            }
            klass = ClassDescriptorHelper.getPrimitiveBoxedClass(className);
            className = klass.getName();
            className = "L" + className + ";";
            while (arrayCount > 0) {
                className = "[" + className;
                --arrayCount;
            }
            return Class.forName(className);
        }
        return null;
    }

    public static Class<?> getClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> klass = ClassDescriptorHelper.getPrimitiveClass(className);
        if (klass != null) {
            return klass;
        }
        int arrayCount = 0;
        while (className.endsWith("[]")) {
            ++arrayCount;
            className = className.substring(0, className.length() - 2);
        }
        if (arrayCount > 0) {
            className = "L" + className + ";";
            while (arrayCount > 0) {
                className = "[" + className;
                --arrayCount;
            }
        }
        try {
            return classLoader != null ? Class.forName(className, true, classLoader) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            int dotIndex = className.lastIndexOf(".");
            if (dotIndex > -1) {
                String parentFQN = className.substring(0, dotIndex);
                String simpleName = className.substring(dotIndex + 1);
                try {
                    Class<?> parentClass = classLoader != null ? Class.forName(parentFQN, true, classLoader) : Class.forName(parentFQN);
                    for (Class<?> innerClass : parentClass.getClasses()) {
                        if (!simpleName.equals(innerClass.getSimpleName())) continue;
                        return innerClass;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    public static void checkSupportClass(Class<?> handlerClass, ClassDescriptor beanClass, Class<?> ... tagClasses) {
        for (Class<?> tagClass : tagClasses) {
            if (!ClassDescriptorHelper.getClassDescriptor(tagClass).isAssignableFrom(beanClass)) continue;
            return;
        }
        throw new IllegalArgumentException(handlerClass.getName() + " does not support the class " + beanClass.getName());
    }

    public static void reset() {
        descriptors.clear();
    }

    public static MethodDescriptor createMethodDescriptor(Method javaMethod, ClassLoader classLoader) {
        String methodName = javaMethod.getName();
        int modifiers = javaMethod.getModifiers();
        String returnType = javaMethod.getReturnType().getName();
        Class<?>[] javaParameters = javaMethod.getParameterTypes();
        String[] parameters = new String[javaParameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = javaParameters[i].getName();
        }
        return new MethodDescriptor(methodName, modifiers, returnType, parameters, classLoader);
    }

    public static MethodDescriptor createMethodDescriptor(Constructor<?> javaMethod, ClassLoader classLoader) {
        String methodName = javaMethod.getName();
        int modifiers = javaMethod.getModifiers();
        String returnType = null;
        Class<?>[] javaParameters = javaMethod.getParameterTypes();
        String[] parameters = new String[javaParameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = javaParameters[i].getName();
        }
        return new MethodDescriptor(methodName, modifiers, returnType, parameters, classLoader);
    }

    public static FieldDescriptor createFieldDescriptor(Field javaField, ClassLoader classLoader) {
        String fieldName = javaField.getName();
        int modifiers = javaField.getModifiers();
        String type = javaField.getType().getName();
        return new FieldDescriptor(fieldName, modifiers, type, classLoader);
    }

    public static JAXXObjectDescriptor getJAXXObjectDescriptor(Class<?> jaxxClass) {
        if (!JAXXObject.class.isAssignableFrom(jaxxClass) || JAXXObject.class.equals(jaxxClass) || jaxxClass.isInterface()) {
            return null;
        }
        try {
            Method getJAXXObjectDescriptor = jaxxClass.getMethod("$getJAXXObjectDescriptor", new Class[0]);
            return (JAXXObjectDescriptor)getJAXXObjectDescriptor.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("Expected JAXXObject " + jaxxClass.getName() + " to have a static method named $getJAXXObjectDescriptor");
        }
        catch (IllegalAccessException e) {
            throw new CompilerException("Expected JAXXObject " + jaxxClass.getName() + "'s $getJAXXObjectDescriptor method to be public");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setShowLoading(boolean b) {
        SHOW_LOADING = b;
    }

    public static enum ResolverType {
        JAVA_CLASS,
        JAVA_FILE,
        JAXX_FILE;

    }
}

