/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.decorators;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompiledObjectDecorator;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.JavaField;
import org.nuiton.jaxx.compiler.java.JavaFile;
import org.nuiton.jaxx.compiler.java.JavaMethod;
import org.nuiton.jaxx.compiler.script.ScriptInitializer;
import org.nuiton.jaxx.compiler.types.TypeManager;

public class DefaultCompiledObjectDecorator
implements CompiledObjectDecorator {
    protected static final Logger log = LogManager.getLogger(DefaultCompiledObjectDecorator.class);

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) throws ClassNotFoundException {
        String type;
        boolean override;
        if (object instanceof ScriptInitializer) {
            return;
        }
        String fqn = JAXXCompiler.getCanonicalName(object);
        String id = object.getId();
        if (log.isDebugEnabled()) {
            log.debug("finalize " + id);
        }
        if (override = object.isOverride()) {
            if (object.isOverrideType()) {
                String methodName = object.getGetterName();
                type = object.getSimpleType();
                String body = "return (" + type + ") super." + methodName + "();";
                if (log.isDebugEnabled()) {
                    log.debug("Add specialized getter " + methodName + " : " + body);
                }
                JavaMethod getter = JavaElementFactory.newMethod(1, fqn, methodName, body, true, new JavaArgument[0]);
                javaFile.addMethod(getter);
            }
        } else {
            int access;
            int n = access = id.startsWith("$") ? 2 : 4;
            if (root.equals(object)) {
                type = className + root.getGenericTypes();
                JavaField field = JavaElementFactory.newField(access, type, id, false, null, new String[0]);
                javaFile.addSimpleField(field);
            } else {
                JavaField field = JavaElementFactory.newField(access, fqn, id, override);
                javaFile.addField(field, object.isJavaBean());
            }
        }
        if (compiler.inlineCreation(object) || root.equals(object)) {
            return;
        }
        String code = this.getCreationCode(compiler, object);
        if (code != null) {
            JavaMethod javaMethod = JavaElementFactory.newMethod(4, "void", object.getCreationMethodName(), code, override, new JavaArgument[0]);
            javaFile.addMethod(javaMethod);
        }
    }

    @Override
    public String getCreationCode(JAXXCompiler compiler, CompiledObject object) throws CompilerException {
        if (object instanceof ScriptInitializer) {
            throw new IllegalStateException("A script initializer can not come in getCreationCode method!");
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder result = new StringBuilder();
        StringBuilder init = new StringBuilder();
        if (compiler.getRootObject().equals(object) || compiler.inlineCreation(object)) {
            result.append("// inline creation of ").append(object.getId());
        }
        if (object.isJavaBean() && object.getJavaBeanInitCode() != null) {
            init.append(object.getJavaBeanInitCode());
        } else if (object.getInitializer() != null) {
            init.append(object.getInitializer());
        }
        boolean addToObjectMap = true;
        String id = TypeManager.getJavaCode(object.getId());
        String constructorParams = object.getConstructorParams();
        if (object.isOverride() && init.length() == 0 && constructorParams == null) {
            addToObjectMap = false;
        }
        if (addToObjectMap && init.length() == 0) {
            String canonicalName = JAXXCompiler.getCanonicalName(object);
            String impl = compiler.getImportedType(canonicalName);
            init.append("new ").append(impl).append("(");
            if (constructorParams != null) {
                init.append(constructorParams);
            }
            init.append(")");
        }
        String superCall = "super." + object.getCreationMethodName() + "();";
        if (addToObjectMap) {
            result.append(eol);
            result.append("$objectMap.put(");
            result.append(id);
            result.append(", ");
            result.append(object.getId()).append(" = ");
            result.append((CharSequence)init);
            result.append(");");
            result.append(eol);
        } else if (object.isOverride()) {
            result.append(superCall);
        }
        String initCode = object.getInitializationCode(compiler);
        if (StringUtils.isNotEmpty((CharSequence)initCode)) {
            result.append(eol).append(initCode);
        }
        this.addClientProperties(object, result, eol);
        String code = result.toString();
        if (!compiler.inlineCreation(object) && object.isOverride() && superCall.equals(code.trim())) {
            return null;
        }
        return code;
    }

    @Override
    public String createCompleteSetupMethod(JAXXCompiler compiler, CompiledObject object, JavaFile javaFile) {
        StringBuilder code = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        if (object.getId().startsWith("$")) {
            String additionCode = object.getAdditionCode();
            if (!additionCode.isEmpty()) {
                code.append("// inline complete setup of ");
                code.append(object.getId());
                code.append(eol);
                code.append(additionCode);
            }
        } else {
            String additionCode = object.getAdditionCode();
            if (additionCode.length() > 0) {
                code.append(object.getAdditionMethodName()).append("();").append(eol);
                javaFile.addMethod(JavaElementFactory.newMethod(4, "void", object.getAdditionMethodName(), additionCode, false, new JavaArgument[0]));
            }
        }
        return code.toString();
    }

    @Override
    public boolean createInitializer(JAXXCompiler compiler, CompiledObject root, CompiledObject object, StringBuilder code, boolean lastWasMethodCall) {
        String eol = JAXXCompiler.getLineSeparator();
        if (object instanceof ScriptInitializer) {
            code.append(object.getInitializationCode(compiler));
            return lastWasMethodCall;
        }
        if (root.equals(object)) {
            String rootCode = root.getInitializationCode(compiler);
            if (rootCode != null && rootCode.length() > 0) {
                code.append("// inline creation of ");
                code.append(object.getId());
                code.append(eol);
                code.append(rootCode);
                this.addClientProperties(object, code, eol);
                code.append(eol);
            }
        } else if (!object.isOverride()) {
            if (compiler.inlineCreation(object)) {
                if (lastWasMethodCall) {
                    lastWasMethodCall = false;
                }
                code.append(this.getCreationCode(compiler, object));
            } else {
                code.append(object.getCreationMethodName()).append("();");
                code.append(eol);
                lastWasMethodCall = true;
            }
        }
        return lastWasMethodCall;
    }

    protected void addClientProperties(CompiledObject object, StringBuilder code, String eol) {
        if (object.hasClientProperties()) {
            for (Map.Entry<String, String> entry : object.getClientProperties().entrySet()) {
                code.append(object.getJavaCode());
                code.append(".putClientProperty(\"");
                code.append(entry.getKey());
                code.append("\", ");
                code.append(entry.getValue());
                code.append(");");
                code.append(eol);
            }
        }
    }
}

