/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.JAXXCompiler;

public class JAXXCompilerFile {
    private static final Logger log = LogManager.getLogger(JAXXCompilerFile.class);
    protected final File basedir;
    private final String relativePath;
    protected File jaxxFile;
    protected File cssFile;
    protected String className;
    protected JAXXCompiler compiler;
    protected final String cssExtension;

    public JAXXCompilerFile(File basedir, File jaxxFile, String cssExtension) {
        this.basedir = basedir;
        this.jaxxFile = jaxxFile;
        this.cssExtension = cssExtension;
        String absolutePath = jaxxFile.getAbsolutePath();
        String baseAbsolutePath = basedir.getAbsolutePath();
        if (!absolutePath.startsWith(baseAbsolutePath)) {
            throw new IllegalStateException("Jaxx file " + jaxxFile + " is not in basedir " + basedir);
        }
        this.relativePath = absolutePath.substring(baseAbsolutePath.length() + 1);
        if (log.isDebugEnabled()) {
            log.debug("relativePath = " + this.relativePath);
        }
    }

    public JAXXCompilerFile(File jaxxFile, String className, String cssExtension) {
        this.jaxxFile = jaxxFile;
        this.className = className;
        this.cssExtension = cssExtension;
        String extension = FilenameUtils.getExtension((String)jaxxFile.getName());
        String[] paths = className.split("\\.");
        File basedir = jaxxFile;
        for (int i = paths.length - 1; i > -1; --i) {
            if (basedir == null) {
                throw new IllegalStateException("Could not find base dir for " + jaxxFile + " according to fqn " + className);
            }
            String path = paths[i];
            if (basedir.equals(jaxxFile)) {
                path = path + "." + extension;
            }
            if (!path.equals(basedir.getName())) {
                throw new IllegalStateException("Should have found directory " + path + ", but was " + basedir.getName());
            }
            basedir = basedir.getParentFile();
        }
        if (log.isDebugEnabled()) {
            log.debug("basedir = " + basedir);
        }
        String relativePath = jaxxFile.getAbsolutePath().substring(basedir.getAbsolutePath().length() + 1);
        if (log.isDebugEnabled()) {
            log.debug("relative path = " + relativePath);
        }
        this.basedir = basedir;
        this.relativePath = relativePath;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public JAXXCompiler getCompiler() {
        return this.compiler;
    }

    public File getJaxxFile() {
        if (this.jaxxFile == null) {
            this.jaxxFile = new File(this.basedir, this.relativePath);
        }
        return this.jaxxFile;
    }

    public URL getJAXXFileURL() {
        File file = this.getJaxxFile();
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Url of the jaxx file is malformed... " + file);
        }
    }

    public File getCssFile() {
        if (this.cssFile == null) {
            File file = this.getJaxxFile();
            String extension = FilenameUtils.getExtension((String)file.getName());
            String fileName = file.getName();
            int length = fileName.length() - extension.length();
            String identCssFilename = fileName.substring(0, length) + this.cssExtension;
            this.cssFile = new File(file.getParentFile(), identCssFilename);
        }
        return this.cssFile;
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.relativePath.substring(0, this.relativePath.lastIndexOf("."));
            this.className = this.className.replace(File.separatorChar, '.');
            this.className = this.className.replace('/', '.');
            this.className = this.className.replace('\\', '.');
            this.className = this.className.replace(':', '.');
        }
        return this.className;
    }

    public void clear() {
        if (this.compiler != null) {
            this.compiler.clear();
        }
    }

    public void setCompiler(JAXXCompiler compiler) {
        this.compiler = compiler;
    }
}

