/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.validator;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.TagHandler;
import org.nuiton.jaxx.compiler.tags.validator.BeanValidatorHandler;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.w3c.dom.Element;

public class FieldValidatorHandler
implements TagHandler {
    public static final String TAG = "field";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String COMPONENT_ATTRIBUTE = "component";
    private static final Log log = LogFactory.getLog(FieldValidatorHandler.class);

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException {
        if (compiler.getConfiguration().isVerbose()) {
            log.debug((Object)tag);
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException {
        ClassDescriptor descriptor;
        if (compiler.getConfiguration().isVerbose()) {
            log.debug((Object)tag);
        }
        if (!(descriptor = ClassDescriptorHelper.getClassDescriptor(SwingValidator.class)).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError("field tag may only appear within BeanValidator tag but was " + tag);
            return;
        }
        BeanValidatorHandler.CompiledBeanValidator info = (BeanValidatorHandler.CompiledBeanValidator)compiler.getOpenComponent();
        String name = tag.getAttribute(NAME_ATTRIBUTE);
        if (StringUtils.isEmpty((CharSequence)name)) {
            compiler.reportError("field tag requires a name attribute");
            return;
        }
        name = name.trim();
        String component = tag.getAttribute(COMPONENT_ATTRIBUTE);
        if (StringUtils.isEmpty((CharSequence)component)) {
            if (!compiler.checkReference(tag, name, false, name)) {
                compiler.reportError("field tag requires a component attribute, try to use the name attribute [" + name + "] for the component, but no such component found");
                return;
            }
            component = name;
        }
        component = component.trim();
        boolean complexType = false;
        if (component.startsWith("{") && component.endsWith("}")) {
            complexType = true;
            component = compiler.preprocessScript(component.substring(1, component.length() - 1));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check '" + component + "' reference"));
        }
        if (complexType) {
            boolean withBinding;
            String binding = compiler.processDataBindings(component);
            boolean bl = withBinding = binding != null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("apply data binding on [" + component + "] : " + withBinding));
            }
            info.registerField(name, component, compiler);
            return;
        }
        if (compiler.checkReference(tag, component, true, COMPONENT_ATTRIBUTE)) {
            info.registerField(name, component, compiler);
        }
    }
}

