/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.compiler.CompilerConfiguration;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXEngine;
import org.nuiton.jaxx.compiler.spi.Initializer;
import org.nuiton.jaxx.compiler.tags.TagManager;

public class JAXXFactory {
    private static final Log log = LogFactory.getLog(JAXXFactory.class);
    protected static JAXXEngine engine;
    protected static CompilerConfiguration configuration;

    protected JAXXFactory() {
    }

    public static void setConfiguration(CompilerConfiguration configuration) {
        JAXXFactory.configuration = configuration;
    }

    public static JAXXEngine newDummyEngine() {
        return JAXXFactory.newEngine(null, new String[0]);
    }

    public static JAXXEngine newEngine(File basedir, String ... relativePaths) {
        JAXXFactory.checkConfiguration();
        if (engine != null) {
            engine.reset(true);
        }
        engine = new JAXXEngine(configuration, basedir, relativePaths);
        return engine;
    }

    public static JAXXCompiler newDummyCompiler(ClassLoader classLoader) {
        JAXXCompiler compiler = new JAXXCompiler();
        if (classLoader != null) {
            compiler.setClassLoader(classLoader);
        }
        return compiler;
    }

    public static JAXXEngine getEngine() throws NullPointerException {
        JAXXFactory.checkConfiguration();
        JAXXFactory.checkEngine();
        return engine;
    }

    public static boolean isEngineRegistred() {
        return engine != null;
    }

    public static void initFactory() {
        JAXXFactory.checkConfiguration();
        TagManager.reset();
        boolean verbose = configuration.isVerbose();
        for (Initializer initializer : configuration.getInitializers().values()) {
            if (verbose) {
                log.info((Object)("load initializer " + initializer));
            }
            initializer.initialize();
        }
    }

    protected static void checkConfiguration() throws NullPointerException {
        if (configuration == null) {
            throw new NullPointerException("No configuration was registred.");
        }
    }

    protected static void checkEngine() throws NullPointerException {
        if (engine == null) {
            throw new NullPointerException("No engine was registred.");
        }
    }
}

