/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import java.io.IOException;
import java.util.List;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.UnsupportedAttributeException;
import org.nuiton.jaxx.compiler.binding.DataBindingHelper;
import org.nuiton.jaxx.compiler.tags.TagHandler;
import org.nuiton.jaxx.compiler.tags.swing.CompiledItemContainer;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.Item;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ItemHandler
implements TagHandler {
    public static final String TAG_NAME = "item";
    private final String DATA_BINDING = "<data binding has not been processed yet>";
    public static final String ATTRIBUTE_ID = "id";

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        String id = tag.getAttribute(ATTRIBUTE_ID);
        if (id == null || id.length() == 0) {
            id = compiler.getAutoId(Item.class.getSimpleName());
        }
        String label = null;
        String value = null;
        boolean selected = false;
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            Attr attribute = (Attr)children.item(i);
            String name = attribute.getName();
            String attrValue = attribute.getValue();
            if (name.equals(ATTRIBUTE_ID)) continue;
            DataBindingHelper bindingHelper = compiler.getBindingHelper();
            if (name.equals("label")) {
                String labelBinding = compiler.processDataBindings(attrValue);
                if (labelBinding != null) {
                    bindingHelper.registerDataBinding(id + ".label", labelBinding, id + ".setLabel(" + labelBinding + ");");
                    continue;
                }
                label = attrValue;
                continue;
            }
            if (name.equals("value")) {
                String valueBinding = compiler.processDataBindings(attrValue);
                if (valueBinding != null) {
                    value = "<data binding has not been processed yet>";
                    bindingHelper.registerDataBinding(id + ".value", valueBinding, id + ".setValue(" + valueBinding + ");");
                    continue;
                }
                value = attrValue;
                continue;
            }
            if (name.equals("selected")) {
                String selectedBinding = compiler.processDataBindings(attrValue);
                if (selectedBinding != null) {
                    bindingHelper.registerDataBinding(id + ".selected", selectedBinding, id + ".setSelected(" + selectedBinding + ");");
                    continue;
                }
                selected = (Boolean)TypeManager.convertFromString(attrValue, Boolean.class);
                continue;
            }
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            throw new UnsupportedAttributeException(name);
        }
        Item item = new Item(id, label, value, selected);
        CompiledItemContainer list = (CompiledItemContainer)compiler.getOpenComponent();
        if (value == null) {
            compiler.reportError("<item> tag is missing required 'value' attribute");
        } else {
            if (!value.equals("<data binding has not been processed yet>")) {
                List<Item> items = list.getItems();
                for (Item item1 : items) {
                    if (!item1.getValue().equals(value)) continue;
                    compiler.reportError("This container already has an <item> tag with the value '" + value + "'");
                    break;
                }
            }
            list.openItem(item);
            this.compileChildrenSecondPass(tag, compiler);
            list.closeItem(item);
        }
    }

    protected void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagFirstPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }
}

