/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.finalizers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.finalizers.AbstractFinalizer;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaElement;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.JavaField;
import org.nuiton.jaxx.compiler.java.JavaFile;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.FieldDescriptor;
import org.nuiton.jaxx.compiler.tags.swing.TabWithValidatorHandler;
import org.nuiton.jaxx.compiler.tags.validator.BeanValidatorHandler;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorUtil;
import org.nuiton.jaxx.validator.swing.meta.Validator;
import org.nuiton.jaxx.validator.swing.meta.ValidatorField;
import org.nuiton.jaxx.validator.swing.tab.TabInfoWithValidator;

public class ValidatorFinalizer
extends AbstractFinalizer {
    static final Log log = LogFactory.getLog(ValidatorFinalizer.class);
    protected static final JavaField VALIDATOR_IDS_FIELD = JavaElementFactory.newField(4, List.class.getName() + "<String>", "validatorIds", true);

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return BeanValidatorHandler.hasValidator(compiler);
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        for (CompiledObject object : compiler.getObjects().values()) {
            List<CompiledObject.ChildRef> childs = object.getChilds();
            if (childs == null || childs.isEmpty()) continue;
            for (CompiledObject.ChildRef child : childs) {
                String javaCode = child.getChildJavaCode();
                boolean found = BeanValidatorHandler.isComponentUsedByValidator(compiler, child.getChild().getId());
                if (!found) continue;
                String type = compiler.getImportedType(SwingUtil.class);
                child.setChildJavaCode(type + ".boxComponentWithJxLayer(" + javaCode + ")");
            }
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder builder = new StringBuilder();
        List<BeanValidatorHandler.CompiledBeanValidator> validators = BeanValidatorHandler.getValidators(compiler);
        String validatorUtilPrefix = compiler.getImportedType(SwingValidatorUtil.class) + ".";
        compiler.getJavaFile().addMethod(JavaElementFactory.newMethod(1, "void", "registerValidatorFields", validatorUtilPrefix + "detectValidatorFields(this);", true, new JavaArgument[0]));
        builder.append("// register ");
        builder.append(validators.size());
        builder.append(" validator(s)");
        builder.append(eol);
        builder.append("validatorIds = ");
        builder.append(validatorUtilPrefix).append("detectValidators(this);").append(eol);
        builder.append(validatorUtilPrefix).append("installUI(this);").append(eol);
        List<TabInfoWithValidator> tabs = TabWithValidatorHandler.getTabs(compiler);
        if (!tabs.isEmpty()) {
            for (TabInfoWithValidator tab : tabs) {
                CompiledObject compiledObject = compiler.getCompiledObject(tab.getId());
                builder.append(validatorUtilPrefix).append("installTabUI(this, ").append(tab.getId()).append(");").append(eol);
            }
        }
        compiler.appendLateInitializer(builder.toString());
        for (BeanValidatorHandler.CompiledBeanValidator validator : validators) {
            this.registerValidator(validator, compiler, javaFile);
        }
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        ClassDescriptor validatorClass = compiler.getEngine().getValidatorFactoryClass();
        Class<JAXXValidator> validatorInterface = JAXXValidator.class;
        boolean parentIsValidator = compiler.isSuperClassAware(validatorInterface);
        if (parentIsValidator) {
            return;
        }
        javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface));
        this.addField(javaFile, VALIDATOR_IDS_FIELD);
        String type = compiler.getImportedType(validatorClass.getName());
        String initializer = "return (" + type + "<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);";
        javaFile.addMethod(JavaElementFactory.newMethod(1, type + "<?>", "getValidator", initializer, true, JavaElementFactory.newArgument("String", "validatorId")));
    }

    public void registerValidator(BeanValidatorHandler.CompiledBeanValidator validator, JAXXCompiler compiler, JavaFile javaFile) {
        JavaField validatorField = javaFile.getField(validator.getId());
        String validatorId = TypeManager.getJavaCode(validator.getId());
        String type = compiler.getImportedType(Validator.class);
        String fieldType = compiler.getImportedType(ValidatorField.class);
        String validatorAnnotation = type + "( validatorId = " + validatorId + ")";
        validatorField.addAnnotation(validatorAnnotation);
        for (String component : validator.getFieldEditors()) {
            Collection<String> propertyNames = validator.getFieldPropertyNames(component);
            ArrayList keyCodes = Lists.newArrayListWithCapacity((int)propertyNames.size());
            for (String propertyName : propertyNames) {
                if (!validator.checkBeanProperty(compiler, propertyName)) continue;
                String keyCode = TypeManager.getJavaCode(propertyName);
                keyCodes.add(keyCode);
            }
            if (keyCodes.isEmpty()) continue;
            String keyCode = Joiner.on((String)", ").join((Iterable)keyCodes);
            if (keyCodes.size() > 1) {
                keyCode = "{ " + keyCode + " }";
            }
            String editorCode = TypeManager.getJavaCode(component);
            String annotation = fieldType + "( validatorId = " + validatorId + ",  propertyName = " + keyCode + ",  editorName = " + editorCode + ")";
            JavaElement editor = javaFile.getField(component);
            if (editor == null) {
                String fqn;
                CompiledObject compiledObject;
                if (log.isDebugEnabled()) {
                    String message = "Could not find editor [" + component + "] for property(ies) [" + propertyNames + "] for file " + javaFile.getName();
                    log.debug((Object)message);
                }
                if ((compiledObject = compiler.getCompiledObject(component)) == null) {
                    FieldDescriptor fieldDescriptor = null;
                    try {
                        fieldDescriptor = compiler.getRootObject().getObjectClass().getDeclaredFieldDescriptor(component);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    if (fieldDescriptor == null) {
                        String errorMessage = "Could not find editor [" + component + "] for property(ies) [" + propertyNames + "] for file " + javaFile.getName();
                        throw new CompilerException(errorMessage);
                    }
                    try {
                        Class<?> parentClass = compiler.getClassLoader().loadClass(compiler.getRootObject().getObjectClass().getName());
                        Method method = parentClass.getMethod("get" + StringUtils.capitalize((String)component), new Class[0]);
                        if (method != null) {
                            String genericReturnType = method.getGenericReturnType().getTypeName();
                            genericReturnType = javaFile.getImportManager().getType(genericReturnType);
                            editor = javaFile.addOverrideGetterMethod(component, 1, genericReturnType, true);
                            editor.addAnnotation(annotation);
                            continue;
                        }
                    }
                    catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                        // empty catch block
                    }
                    fqn = JAXXCompiler.getCanonicalName(fieldDescriptor.getType());
                } else {
                    fqn = JAXXCompiler.getCanonicalName(compiledObject);
                }
                editor = javaFile.addGetterMethod(component, 1, fqn, true, true);
                editor.addAnnotation(annotation);
                continue;
            }
            editor.addAnnotation(annotation);
        }
    }
}

