/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXEngine;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaConstructor;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.JavaFile;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.tags.TagManager;
import org.nuiton.jaxx.compiler.tasks.JAXXEngineTask;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXUtil;

public class GenerateConstructorsTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(GenerateConstructorsTask.class);
    public static final String TASK_NAME = "PostFinalize";
    private static final String PARAMETER_NAME_PARENT_CONTEXT = "parentContext";

    public GenerateConstructorsTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;
        boolean isVerbose = engine.getConfiguration().isVerbose();
        JAXXCompilerFile[] files = engine.getCompiledFiles();
        ArrayList<JAXXCompiler> compilers = new ArrayList<JAXXCompiler>();
        for (JAXXCompilerFile jaxxFile : files) {
            compilers.add(jaxxFile.getCompiler());
        }
        int round = 0;
        while (!compilers.isEmpty()) {
            if (isVerbose) {
                log.info((Object)("Round " + round++ + ", still " + compilers.size() + " compilers to treat."));
            }
            Iterator itr = compilers.iterator();
            while (itr.hasNext()) {
                JAXXCompiler compiler = (JAXXCompiler)itr.next();
                JavaFile javaFile = compiler.getJavaFile();
                boolean isJAXXObject = javaFile.isSuperclassIsJAXXObject();
                if (!isJAXXObject) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Compute constructor from non super jaxx object file " + javaFile.getName()));
                    }
                    this.addConstructorsForNoneSuperClassJaxx(engine, compiler);
                    itr.remove();
                    continue;
                }
                CompiledObject rootObject = compiler.getRootObject();
                ClassDescriptor parentClassDescriptor = rootObject.getObjectClass();
                if (parentClassDescriptor.getResolverType() != ClassDescriptorHelper.ResolverType.JAXX_FILE) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Compute constructor from outside super jaxx object file " + javaFile.getName()));
                    }
                    this.addConstructorsForSuperClassJaxx(engine, compiler, null);
                    itr.remove();
                    continue;
                }
                JAXXCompiler parentCompiler = engine.getJAXXCompiler(JAXXCompiler.getCanonicalName(parentClassDescriptor));
                if (!compilers.contains(parentCompiler)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Compute constructor from inside super jaxx object file " + javaFile.getName()));
                    }
                    this.addConstructorsForSuperClassJaxx(engine, compiler, parentCompiler);
                    itr.remove();
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Can not compute constructors for " + compiler.getRootObject().getId() + " waits fro his parent to be treated..."));
            }
        }
        return success;
    }

    protected void addConstructorsForNoneSuperClassJaxx(JAXXEngine engine, JAXXCompiler compiler) throws ClassNotFoundException, IllegalStateException {
        JavaFile javaFile = compiler.getJavaFile();
        if (javaFile.isSuperclassIsJAXXObject()) {
            throw new IllegalStateException("This method does not accept compiler that inheritates from a jaxx file.");
        }
        String className = javaFile.getSimpleName();
        if (engine.isVerbose()) {
            log.info((Object)("start " + javaFile.getName()));
        }
        this.addStartProfileTime(engine, compiler);
        List<List<String>> prototypes = this.getDeclaredConstructorPrototypes(compiler, javaFile);
        MethodDescriptor[] constructorDescriptors = compiler.getRootObject().getObjectClass().getConstructorDescriptors();
        if (constructorDescriptors == null || constructorDescriptors.length == 0) {
            List<String> constructorTypes = this.getConstructorTypes(new ClassDescriptor[0]);
            boolean canAddConstructor = this.canAddConstructor(prototypes, constructorTypes);
            if (canAddConstructor) {
                this.addConstructor(compiler, className, constructorTypes);
            }
            constructorTypes.add(0, JAXXCompiler.getCanonicalName(JAXXContext.class));
            canAddConstructor = this.canAddConstructor(prototypes, constructorTypes);
            if (canAddConstructor) {
                this.addConstructorWithInitialContext(compiler, className, constructorTypes, false);
            }
        } else {
            for (MethodDescriptor constructorDescriptor : constructorDescriptors) {
                List<String> constructorTypes = this.getConstructorTypes(constructorDescriptor.getParameterTypes());
                boolean canAddConstructor = this.canAddConstructor(prototypes, constructorTypes);
                if (canAddConstructor) {
                    this.addConstructor(compiler, className, constructorTypes);
                }
                constructorTypes.add(0, JAXXCompiler.getCanonicalName(JAXXContext.class));
                canAddConstructor = this.canAddConstructor(prototypes, constructorTypes);
                if (!canAddConstructor) continue;
                this.addConstructorWithInitialContext(compiler, className, constructorTypes, false);
            }
        }
        this.addEndProfileTime(engine, compiler);
    }

    protected void addConstructorsForSuperClassJaxx(JAXXEngine engine, JAXXCompiler compiler, JAXXCompiler parentCompiler) throws ClassNotFoundException, IllegalStateException {
        MethodDescriptor[] constructorDescriptors;
        JavaFile javaFile = compiler.getJavaFile();
        if (!javaFile.isSuperclassIsJAXXObject()) {
            throw new IllegalStateException("This method does not accept compiler that inheritates not from a jaxx file.");
        }
        String className = javaFile.getSimpleName();
        if (engine.isVerbose()) {
            log.info((Object)("start " + javaFile.getName()));
        }
        this.addStartProfileTime(engine, compiler);
        List<List<String>> prototypes = this.getDeclaredConstructorPrototypes(compiler, javaFile);
        if (parentCompiler == null) {
            constructorDescriptors = compiler.getRootObject().getObjectClass().getConstructorDescriptors();
        } else {
            List<JavaConstructor> constructors = parentCompiler.getJavaFile().getConstructors();
            constructorDescriptors = new MethodDescriptor[constructors.size()];
            int i = 0;
            for (JavaConstructor constructor : constructors) {
                String[] parameters = new String[constructor.getArguments().length];
                int j = 0;
                for (JavaArgument argument : constructor.getArguments()) {
                    String type = argument.getType();
                    parameters[j++] = type;
                }
                constructorDescriptors[i++] = new MethodDescriptor(null, constructor.getModifiers(), null, parameters, compiler.getClassLoader());
            }
        }
        for (MethodDescriptor constructorDescriptor : constructorDescriptors) {
            boolean canAddConstructor;
            List<String> constructorTypes;
            ClassDescriptor[] parameterTypes = constructorDescriptor.getParameterTypes();
            if (parentCompiler == null) {
                constructorTypes = new ArrayList<String>(parameterTypes.length);
                for (ClassDescriptor parameterType : parameterTypes) {
                    constructorTypes.add(parameterType.getName());
                }
            } else {
                constructorTypes = this.getConstructorTypes(parameterTypes);
            }
            if (!(canAddConstructor = this.canAddConstructor(prototypes, constructorTypes))) continue;
            this.addConstructor(compiler, className, constructorTypes);
        }
        this.addEndProfileTime(engine, compiler);
    }

    protected List<List<String>> getDeclaredConstructorPrototypes(JAXXCompiler compiler, JavaFile javaFile) throws ClassNotFoundException {
        List<JavaConstructor> constructors = javaFile.getConstructors();
        ArrayList<List<String>> prototypes = new ArrayList<List<String>>(constructors.size());
        for (JavaConstructor constructor : constructors) {
            ArrayList<String> prototype = new ArrayList<String>();
            for (JavaArgument argument : constructor.getArguments()) {
                String type = argument.getType();
                String fqn = TagManager.resolveClassName(type, compiler);
                ClassDescriptor classDescriptor = ClassDescriptorHelper.getClassDescriptor(fqn);
                String canonicalName = JAXXCompiler.getCanonicalName(classDescriptor);
                prototype.add(canonicalName);
            }
            prototypes.add(prototype);
        }
        return prototypes;
    }

    private boolean canAddConstructor(List<List<String>> prototypes, List<String> constructorTypes) {
        return !prototypes.contains(constructorTypes);
    }

    private List<String> getConstructorTypes(ClassDescriptor ... descriptors) {
        ArrayList<String> result = new ArrayList<String>();
        for (ClassDescriptor descriptor : descriptors) {
            String fqn = JAXXCompiler.getCanonicalName(descriptor);
            result.add(fqn);
        }
        return result;
    }

    protected void addConstructor(JAXXCompiler compiler, String className, List<String> constructorTypes) throws CompilerException {
        StringBuilder code = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        JavaArgument[] arguments = new JavaArgument[constructorTypes.size()];
        if (!constructorTypes.isEmpty()) {
            code.append("        super(");
            int i = 0;
            for (String constructorType : constructorTypes) {
                JavaArgument argument;
                arguments[i] = argument = JavaElementFactory.newArgument(constructorType, "param" + i);
                if (i > 0) {
                    code.append(" ,");
                }
                code.append(argument.getName());
                ++i;
            }
            code.append(");").append(eol);
        }
        if (!compiler.isSuperClassAware(JAXXObject.class)) {
            code.append("$initialize();");
        }
        code.append(eol);
        JavaConstructor constructor = JavaElementFactory.newConstructor(1, className, code.toString(), arguments);
        compiler.getJavaFile().addConstructor(constructor);
    }

    protected void addConstructorWithInitialContext(JAXXCompiler compiler, String className, List<String> constructorTypes, boolean superclassIsJAXXObject) throws CompilerException {
        JavaArgument argument;
        String constructorType;
        int i;
        StringBuilder code = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        JavaArgument firstArgument = JavaElementFactory.newArgument(JAXXContext.class.getName(), PARAMETER_NAME_PARENT_CONTEXT);
        JavaArgument[] arguments = new JavaArgument[constructorTypes.size()];
        arguments[0] = firstArgument;
        int max = constructorTypes.size();
        for (i = 1; i < max; ++i) {
            constructorType = constructorTypes.get(i);
            arguments[i] = argument = JavaElementFactory.newArgument(constructorType, "param" + i);
        }
        if (superclassIsJAXXObject) {
            code.append("        super(");
            code.append(PARAMETER_NAME_PARENT_CONTEXT);
            max = constructorTypes.size();
            for (i = 1; i < max; ++i) {
                constructorType = constructorTypes.get(i);
                arguments[i] = argument = JavaElementFactory.newArgument(constructorType, "param" + i);
                code.append(" ,");
                code.append(argument.getName());
            }
            code.append(");").append(eol);
        } else if (constructorTypes.size() > 1) {
            code.append("        super(");
            max = constructorTypes.size();
            for (i = 1; i < max; ++i) {
                constructorType = constructorTypes.get(i);
                arguments[i] = argument = JavaElementFactory.newArgument(constructorType, "param" + i);
                if (i > 1) {
                    code.append(" ,");
                }
                code.append(argument.getName());
            }
            code.append(");").append(eol);
        }
        if (!superclassIsJAXXObject) {
            String prefix = compiler.getImportedType(JAXXUtil.class);
            code.append(prefix);
            code.append(".initContext(this, parentContext);");
            code.append(eol);
        }
        code.append("$initialize();");
        code.append(eol);
        JavaConstructor constructor = JavaElementFactory.newConstructor(1, className, code.toString(), arguments);
        compiler.getJavaFile().addConstructor(constructor);
    }
}

