/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import java.awt.Color;
import java.awt.event.ContainerListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.I18nHelper;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.DefaultComponentHandler;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import org.nuiton.jaxx.runtime.swing.TabInfoPropertyChangeListener;

public class JTabbedPaneHandler
extends DefaultComponentHandler {
    public static final String ATTRIBUTE_TITLE = "title";
    public static final String ATTRIBUTE_TOOL_TIP_TEXT = "toolTipText";

    public JTabbedPaneHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, JTabbedPane.class);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledTabbedPane(id, this.getBeanClass(), compiler);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("getSelectedIndex", ChangeListener.class);
        this.addProxyEventInfo("getSelectedComponent", ChangeListener.class);
        this.addProxyEventInfo("getTabCount", ContainerListener.class);
    }

    public static class CompiledTabbedPane
    extends CompiledObject {
        private static final TabInfo USED = new TabInfo("ALREADY USED");
        int tabCount;
        TabInfo tabInfo;

        public CompiledTabbedPane(String id, ClassDescriptor objectClass, JAXXCompiler compiler) throws CompilerException {
            super(id, objectClass, compiler);
        }

        @Override
        public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
            String tabComponent;
            Icon disabledIcon;
            Icon icon;
            int displayedMnemonicIndex;
            int mnemonic;
            Color background;
            Color foreground;
            boolean enabled;
            String toolTipText;
            if (constraints != null) {
                compiler.reportError("JTabbedPane tabs may not have constraints");
            }
            super.addChild(child, constraints, compiler);
            if (this.tabInfo == null) {
                compiler.reportError("JTabbedPaneHandler may only have 'tab' tags as children (found " + child.getObjectClass() + ")");
                return;
            }
            if (USED.equals(this.tabInfo)) {
                compiler.reportError("<tab> tags may only have one child component");
                return;
            }
            int tabIndex = ++this.tabCount - 1;
            String type = compiler.getImportedType(TabInfoPropertyChangeListener.class);
            this.appendAdditionCode(this.tabInfo.getId() + ".setTabIndex(" + tabIndex + ");");
            this.appendAdditionCode(this.tabInfo.getId() + ".addPropertyChangeListener(new " + type + "(" + this.getId() + ", " + tabIndex + "));");
            String title = this.tabInfo.getTitle();
            if (title != null) {
                if (I18nHelper.isI18nAttribute(JTabbedPaneHandler.ATTRIBUTE_TITLE)) {
                    if (!title.startsWith("t(\"")) {
                        title = I18nHelper.addI18nInvocation(this.getId(), JTabbedPaneHandler.ATTRIBUTE_TITLE, TypeManager.getJavaCode(title), compiler);
                    }
                } else {
                    title = TypeManager.getJavaCode(title);
                }
                this.appendAdditionCode(this.getId() + ".setTitleAt(" + tabIndex + ", " + title + ");");
            }
            if ((toolTipText = this.tabInfo.getToolTipText()) != null) {
                if (I18nHelper.isI18nAttribute(JTabbedPaneHandler.ATTRIBUTE_TOOL_TIP_TEXT)) {
                    if (!toolTipText.startsWith("t(\"")) {
                        toolTipText = I18nHelper.addI18nInvocation(this.getId(), JTabbedPaneHandler.ATTRIBUTE_TOOL_TIP_TEXT, TypeManager.getJavaCode(toolTipText), compiler);
                    }
                } else {
                    toolTipText = TypeManager.getJavaCode(toolTipText);
                }
                this.appendAdditionCode(this.getId() + ".setToolTipTextAt(" + tabIndex + ", " + toolTipText + ");");
            }
            if (!(enabled = this.tabInfo.isEnabled())) {
                this.appendAdditionCode(this.getId() + ".setEnabledAt(" + tabIndex + ", false);");
            }
            if ((foreground = this.tabInfo.getForeground()) != null) {
                this.appendAdditionCode(this.getId() + ".setForegroundAt(" + tabIndex + ", " + TypeManager.getJavaCode(foreground) + ");");
            }
            if ((background = this.tabInfo.getBackground()) != null) {
                this.appendAdditionCode(this.getId() + ".setBackgroundAt(" + tabIndex + ", " + TypeManager.getJavaCode(background) + ");");
            }
            if ((mnemonic = this.tabInfo.getMnemonic()) != -1) {
                this.appendAdditionCode(this.getId() + ".setMnemonicAt(" + tabIndex + ", " + mnemonic + ");");
            }
            if ((displayedMnemonicIndex = this.tabInfo.getDisplayedMnemonicIndex()) != -1) {
                this.appendAdditionCode(this.getId() + ".setDisplayedMnemonicIndexAt(" + tabIndex + ", " + displayedMnemonicIndex + ");");
            }
            if ((icon = this.tabInfo.getIcon()) != null) {
                this.appendAdditionCode(this.getId() + ".setIconAt(" + tabIndex + ", " + icon + ");");
            }
            if ((disabledIcon = this.tabInfo.getDisabledIcon()) != null) {
                this.appendAdditionCode(this.getId() + ".setDisabledIconAt(" + tabIndex + ", " + disabledIcon + ");");
            }
            if ((tabComponent = this.tabInfo.getTabComponentStr()) != null) {
                this.appendAdditionCode(this.getId() + ".setTabComponentAt(" + tabIndex + ", " + tabComponent + ");");
            }
            this.tabInfo = USED;
        }
    }
}

