/*
 * #%L
 * JAXX :: Compiler
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.jaxx.compiler.tags.swing;

import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.Application;
import org.w3c.dom.Element;

import javax.swing.WindowConstants;

public class ApplicationHandler extends JWindowHandler {

    public static final String ATTRIBUTE_LOOK_AND_FEEL = "lookAndFeel";

    public static final String ATTRIBUTE_DEFAULT_CLOSE_OPERATION = "defaultCloseOperation";

    public ApplicationHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(getClass(),
                                                beanClass,
                                                Application.class
        );
    }

    @Override
    public void setAttribute(CompiledObject object,
                             String propertyName,
                             String stringValue,
                             boolean inline,
                             JAXXCompiler compiler) throws CompilerException {
        if (propertyName.equals(ATTRIBUTE_LOOK_AND_FEEL) &&
                stringValue != null &&
                !stringValue.trim().startsWith("{")) {
            compiler.appendBodyCode("{ " + object.getJavaCode() + ".setLookAndFeel(" + TypeManager.getJavaCode(stringValue) + "); }" + JAXXCompiler.getLineSeparator());
        } else {
            super.setAttribute(object,
                               propertyName,
                               stringValue,
                               inline,
                               compiler
            );
        }
    }

    @Override
    protected void setDefaults(CompiledObject object,
                               Element tag,
                               JAXXCompiler compiler) throws CompilerException {
        super.setDefaults(object, tag, compiler);
        setAttribute(object,
                     ATTRIBUTE_DEFAULT_CLOSE_OPERATION,
                     String.valueOf(WindowConstants.EXIT_ON_CLOSE),
                     false,
                     compiler
        );
    }
}
