/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.compiler.CompiledObjectDecorator;
import org.nuiton.jaxx.compiler.CompilerConfiguration;
import org.nuiton.jaxx.compiler.DefaultCompilerConfiguration;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.JAXXCompilerFile;
import org.nuiton.jaxx.compiler.JAXXProfile;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tasks.CompileFirstPassTask;
import org.nuiton.jaxx.compiler.tasks.CompileSecondPassTask;
import org.nuiton.jaxx.compiler.tasks.FinalizeTask;
import org.nuiton.jaxx.compiler.tasks.GenerateConstructorsTask;
import org.nuiton.jaxx.compiler.tasks.GenerateMissingRulesTask;
import org.nuiton.jaxx.compiler.tasks.GenerateTask;
import org.nuiton.jaxx.compiler.tasks.InitTask;
import org.nuiton.jaxx.compiler.tasks.JAXXEngineTask;
import org.nuiton.jaxx.compiler.tasks.ProfileTask;
import org.nuiton.jaxx.compiler.tasks.StyleSheetTask;
import org.nuiton.jaxx.runtime.util.StringUtil;

public class JAXXEngine {
    private static final Log log = LogFactory.getLog(JAXXEngine.class);
    protected final CompilerConfiguration configuration;
    protected final JAXXCompilerFile[] incomingFiles;
    protected final List<JAXXCompilerFile> compilingFiles;
    protected final List<String> warnings;
    protected final List<String> errors;
    protected JAXXEngineTask[] tasks;
    protected JAXXEngineTask currentTask;
    protected JAXXProfile profiler;

    protected JAXXEngine(CompilerConfiguration configuration, File base, String ... relativePaths) {
        if (configuration == null) {
            configuration = new DefaultCompilerConfiguration();
        }
        this.configuration = configuration;
        this.warnings = new ArrayList<String>();
        this.errors = new ArrayList<String>();
        this.compilingFiles = new ArrayList<JAXXCompilerFile>();
        if (configuration.isShowClassDescriptorLoading()) {
            ClassDescriptorHelper.setShowLoading(true);
        }
        for (String relativePath : relativePaths) {
            JAXXCompilerFile compilerFile = new JAXXCompilerFile(base, new File(base, relativePath), configuration.getCssExtension());
            this.addFileToCompile(compilerFile);
        }
        this.incomingFiles = this.compilingFiles.toArray(new JAXXCompilerFile[this.compilingFiles.size()]);
    }

    public JAXXEngineTask[] getTasks() {
        if (this.tasks == null) {
            ArrayList<JAXXEngineTask> tasks = new ArrayList<JAXXEngineTask>();
            tasks.add(new InitTask());
            tasks.add(new CompileFirstPassTask());
            tasks.add(new CompileSecondPassTask());
            tasks.add(new StyleSheetTask());
            tasks.add(new FinalizeTask());
            tasks.add(new GenerateConstructorsTask());
            tasks.add(new GenerateTask());
            if (this.getConfiguration().isGenerateMissingIdsAndStyleClassesInCss()) {
                tasks.add(new GenerateMissingRulesTask());
            }
            if (this.getConfiguration().isProfile()) {
                tasks.add(new ProfileTask());
            }
            this.tasks = tasks.toArray(new JAXXEngineTask[tasks.size()]);
        }
        return this.tasks;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public JAXXProfile getProfiler() {
        if (this.profiler == null && this.getConfiguration().isProfile()) {
            this.profiler = new JAXXProfile();
        }
        return this.profiler;
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public JAXXCompilerFile[] getFilesToCompile() {
        ArrayList<JAXXCompilerFile> files = new ArrayList<JAXXCompilerFile>();
        for (JAXXCompilerFile file : this.compilingFiles) {
            if (file.getCompiler() != null) continue;
            files.add(file);
        }
        return files.toArray(new JAXXCompilerFile[files.size()]);
    }

    public JAXXCompilerFile[] getCompiledFiles() {
        ArrayList<JAXXCompilerFile> files = new ArrayList<JAXXCompilerFile>();
        for (JAXXCompilerFile file : this.compilingFiles) {
            if (file.getCompiler() == null) continue;
            files.add(file);
        }
        return files.toArray(new JAXXCompilerFile[files.size()]);
    }

    public boolean containsJaxxFileClassName(String className) {
        for (JAXXCompilerFile file : this.compilingFiles) {
            if (!className.equals(file.getClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean isCompileFirstPassTask() {
        return this.currentTask != null && "CompileFirstPass".equals(this.currentTask.getName());
    }

    protected void reset(boolean cleanReports) {
        for (JAXXCompilerFile compilerFile : this.compilingFiles) {
            compilerFile.clear();
        }
        this.compilingFiles.clear();
        if (this.profiler != null) {
            this.profiler.clear();
            this.profiler = null;
        }
        if (cleanReports) {
            this.clearReports();
        }
        ClassDescriptorHelper.setShowLoading(false);
    }

    public void clearReports() {
        this.getWarnings().clear();
        this.getErrors().clear();
    }

    public String getVersion() {
        return "2.4";
    }

    public JAXXCompilerFile getJAXXCompilerFile(String className) {
        for (JAXXCompilerFile compilingFile : this.compilingFiles) {
            if (!className.equals(compilingFile.getClassName())) continue;
            return compilingFile;
        }
        return null;
    }

    public JAXXCompiler getJAXXCompiler(String className) {
        JAXXCompilerFile compilerFile = this.getJAXXCompilerFile(className);
        if (compilerFile == null) {
            return null;
        }
        return compilerFile.getCompiler();
    }

    public CompiledObjectDecorator getDecorator(String name) throws IllegalArgumentException {
        Map<String, CompiledObjectDecorator> decorators = this.getConfiguration().getDecorators();
        CompiledObjectDecorator decorator = decorators.get(name);
        if (decorator == null) {
            throw new IllegalArgumentException("could not find decorator with key " + name + " (known decorators : " + decorators.keySet() + ")");
        }
        return decorator;
    }

    public CompiledObjectDecorator getDecorator(Class<?> type) {
        Map<String, CompiledObjectDecorator> decorators = this.getConfiguration().getDecorators();
        for (CompiledObjectDecorator decorator : decorators.values()) {
            if (!decorator.getClass().equals(type)) continue;
            return decorator;
        }
        return null;
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        try {
            boolean success = true;
            for (JAXXEngineTask task : this.getTasks()) {
                if (!success) break;
                this.currentTask = task;
                long t0 = System.nanoTime();
                if (this.isVerbose()) {
                    log.info((Object)("Start task '" + task.getName() + "' on " + this.compilingFiles.size() + " file(s)"));
                }
                success = task.perform(this);
                if (!this.isVerbose()) continue;
                log.info((Object)("task '" + task.getName() + "' done in " + StringUtil.convertTime((long)(System.nanoTime() - t0))));
            }
            int n = success ? this.compilingFiles.size() : -1;
            return n;
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            int n = -1;
            return n;
        }
        finally {
            if (this.configuration.isResetAfterCompile()) {
                this.reset(false);
            }
        }
    }

    public void addFileToCompile(JAXXCompilerFile file) {
        if (this.isVerbose()) {
            log.info((Object)("register jaxx file " + file.getJaxxFile()));
        }
        this.compilingFiles.add(file);
    }

    public void addFileToCompile(File jaxxFile, String jaxxClassName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("file = " + jaxxFile + ", fqn = " + jaxxClassName));
        }
        JAXXCompilerFile file = new JAXXCompilerFile(jaxxFile, jaxxClassName, this.configuration.getCssExtension());
        this.addFileToCompile(file);
    }

    public JAXXCompiler newCompiler(JAXXCompilerFile jaxxFile) throws Exception {
        Class<? extends JAXXCompiler> compilerClass = this.getConfiguration().getCompilerClass();
        if (compilerClass == null) {
            throw new NullPointerException("Configuration compilerClass is null");
        }
        Constructor<? extends JAXXCompiler> cons = compilerClass.getConstructor(JAXXEngine.class, JAXXCompilerFile.class, List.class);
        JAXXCompiler jaxxCompiler = cons.newInstance(this, jaxxFile, Arrays.asList("java.awt.*", "java.lang.*", "javax.swing.*", "javax.swing.border.*", "org.nuiton.jaxx.runtime.swing.*"));
        jaxxFile.setCompiler(jaxxCompiler);
        return jaxxCompiler;
    }

    public boolean isVerbose() {
        return this.getConfiguration().isVerbose();
    }

    public void addProfileTime(JAXXCompiler compiler, String key) {
        JAXXProfile profiler = this.getProfiler();
        if (profiler != null) {
            profiler.addTime(compiler, key);
        }
    }
}

