/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.ui;

import io.ultreia.java4all.i18n.editor.action.ExitAction;
import io.ultreia.java4all.i18n.editor.action.ExportAction;
import io.ultreia.java4all.i18n.editor.action.GoTemplatesAction;
import io.ultreia.java4all.i18n.editor.action.GoTranslationsAction;
import io.ultreia.java4all.i18n.editor.model.Project;
import io.ultreia.java4all.i18n.editor.ui.ItemComponent;
import io.ultreia.java4all.i18n.editor.ui.LocalizedItemUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class ProjectUI
extends JDialog {
    private final ItemComponent translations;
    private final ItemComponent templates;
    private final JButton export;
    private final Project model;
    private final JTabbedPane navigationTabbedPane;
    private ItemComponent selectedItem;
    private final JButton exit;

    public ProjectUI(Frame owner, Project model) {
        super(owner, true);
        this.model = model;
        this.setDefaultCloseOperation(2);
        this.setTitle(String.format("I18n editor for %s v%s", model.getName(), model.getVersion()));
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setResizeWeight(0.8f);
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)splitPane, "Center");
        JPanel actions = new JPanel();
        this.getRootPane().add((Component)actions, "South");
        actions.setLayout(new GridLayout(1, 0));
        this.exit = new JButton(new ExitAction(this));
        this.exit.setDisplayedMnemonicIndex(this.exit.getText().length() - 2);
        actions.add(this.exit);
        this.export = new JButton(new ExportAction(this));
        this.export.setEnabled(false);
        this.export.setDisplayedMnemonicIndex(this.export.getText().length() - 2);
        actions.add(this.export);
        this.navigationTabbedPane = new JTabbedPane();
        this.navigationTabbedPane.setMinimumSize(new Dimension(550, 500));
        splitPane.setLeftComponent(this.navigationTabbedPane);
        JPanel editor = new JPanel();
        editor.setLayout(new BorderLayout());
        splitPane.setRightComponent(editor);
        PropertyChangeListener saneChanged = e -> this.saneChanged();
        PropertyChangeListener modifiedChanged = e -> this.modifiedChanged();
        PropertyChangeListener globalModifiedChanged = e -> this.globalModifiedChanged();
        this.translations = new ItemComponent(model, 0, this.navigationTabbedPane, LocalizedItemUI::createTranslation, model::getTranslation, String.format("Translations (%s)", GoTranslationsAction.KEY_STROKE.toString().replace("pressed", "+")), model.getTranslationKeys(), modifiedChanged, globalModifiedChanged, saneChanged, model.getLanguageProvider().getApplicationDefinition().getKeyCategories());
        this.templates = new ItemComponent(model, 1, this.navigationTabbedPane, LocalizedItemUI::createTemplate, model::getTemplate, String.format("Templates (%s)", GoTemplatesAction.KEY_STROKE.toString().replace("pressed", "+")), model.getTemplateNames(), modifiedChanged, globalModifiedChanged, saneChanged, Collections.emptyMap());
        this.navigationTabbedPane.getModel().addChangeListener(e -> {
            editor.removeAll();
            int selectedIndex = this.navigationTabbedPane.getSelectedIndex();
            switch (selectedIndex) {
                case 0: {
                    this.selectedItem = this.translations;
                    break;
                }
                case 1: {
                    this.selectedItem = this.templates;
                }
            }
            editor.add((Component)this.selectedItem.getPanel(), "Center");
            SwingUtilities.invokeLater(editor::repaint);
            this.selectedItem.getPanel().getFocus().ifPresent(i -> i.getEditor().requestFocusInWindow());
        });
        InputMap inputMap = splitPane.getInputMap(1);
        ActionMap actionMap = splitPane.getActionMap();
        actionMap.put(GoTranslationsAction.ACTION_NAME, new GoTranslationsAction(this));
        inputMap.put(GoTranslationsAction.KEY_STROKE, GoTranslationsAction.ACTION_NAME);
        actionMap.put(GoTemplatesAction.ACTION_NAME, new GoTemplatesAction(this));
        inputMap.put(GoTemplatesAction.KEY_STROKE, GoTemplatesAction.ACTION_NAME);
        this.navigationTabbedPane.setSelectedIndex(1);
        this.navigationTabbedPane.setSelectedIndex(0);
        if (owner != null) {
            Dimension size = owner.getSize();
            Dimension thisSize = new Dimension((int)size.getWidth() - 20, (int)size.getHeight() - 20);
            this.setMinimumSize(thisSize);
            this.setSize(thisSize);
        } else {
            this.setMinimumSize(new Dimension(1024, 800));
            this.pack();
        }
        SwingUtil.center((Component)owner, (Component)this);
        SwingUtilities.invokeLater(() -> this.setVisible(true));
    }

    private void globalModifiedChanged() {
        this.selectedItem.repaintList();
        this.export.setEnabled(this.model.isModified());
    }

    private void modifiedChanged() {
        this.selectedItem.repaintList();
    }

    private void saneChanged() {
        this.selectedItem.repaintList();
    }

    public Project getModel() {
        return this.model;
    }

    public void toggleFilter() {
        this.templates.toggleFilter();
        this.translations.toggleFilter();
    }

    public JTabbedPane getNavigationTabbedPane() {
        return this.navigationTabbedPane;
    }

    public ItemComponent getSelectedItem() {
        return this.selectedItem;
    }

    public JButton getExit() {
        return this.exit;
    }

    public JButton getExport() {
        return this.export;
    }
}

