/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.ui;

import io.ultreia.java4all.i18n.editor.model.LocalizedItem;
import io.ultreia.java4all.i18n.editor.ui.ItemUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public abstract class LocalizedItemUI
extends JXTitledPanel {
    private static Border focusBorder = new LineBorder(new Color(64, 64, 64), 3, true);
    private static Border noFocusBorder = new LineBorder(new Color(192, 192, 192), 3, true);
    private final JLabel rightDecoration;
    private final Locale locale;
    private final JTextComponent editor;
    private final PropertyChangeListener modifiedChanged;
    private final PropertyChangeListener globalModifiedChanged;
    private final PropertyChangeListener lastValidaValueChanged;
    private final PropertyChangeListener saneChanged;
    private LocalizedItem model;
    private Color titleColor;
    private Font titleFont;
    private String titleText;
    private Color editorColor;
    private Font editorFont;

    static LocalizedItemUI createTranslation(Locale locale) {
        return new LocalizedItemUI(locale){

            @Override
            public JTextComponent createEditor() {
                return new JTextField();
            }
        };
    }

    static LocalizedItemUI createTemplate(Locale locale) {
        return new LocalizedItemUI(locale){

            @Override
            public JTextComponent createEditor() {
                return new JTextArea();
            }
        };
    }

    public abstract JTextComponent createEditor();

    private LocalizedItemUI(Locale locale) {
        this.locale = locale;
        this.editor = this.createEditor();
        JLabel leftDecoration = new JLabel(SwingUtil.createActionIcon((String)("i18n-" + locale.getLanguage())));
        this.rightDecoration = new JLabel(SwingUtil.createActionIcon((String)"save"));
        this.setLeftDecoration(leftDecoration);
        JScrollPane scrollPane = new JScrollPane(this.editor);
        this.setContentContainer(scrollPane);
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                LocalizedItemUI.this.valueChanged();
            }
        });
        this.editor.setBorder(noFocusBorder);
        this.globalModifiedChanged = e2 -> this.modifiedChanged();
        this.modifiedChanged = e1 -> this.modifiedChanged();
        this.lastValidaValueChanged = e -> this.lastValidValueChanged();
        this.saneChanged = e -> this.modifiedChanged();
        this.editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                LocalizedItemUI.this.editor.setBorder(focusBorder);
                ItemUI parent = (ItemUI)LocalizedItemUI.this.getParent().getParent();
                parent.focus(LocalizedItemUI.this);
            }

            @Override
            public void focusLost(FocusEvent e) {
                LocalizedItemUI.this.editor.setBorder(noFocusBorder);
            }
        });
    }

    public Locale getLocale() {
        return this.locale;
    }

    void setModel(LocalizedItem model) {
        Objects.requireNonNull(model);
        if (this.model != null) {
            this.model.removePropertyChangeListener("modified", this.modifiedChanged);
            this.model.removePropertyChangeListener("globalModified", this.globalModifiedChanged);
            this.model.removePropertyChangeListener("lastValidValue", this.lastValidaValueChanged);
        }
        this.model = model;
        this.model.addPropertyChangeListener("modified", this.modifiedChanged);
        this.model.addPropertyChangeListener("globalModified", this.globalModifiedChanged);
        this.model.addPropertyChangeListener("lastValidValue", this.lastValidaValueChanged);
        this.model.addPropertyChangeListener("sane", this.saneChanged);
        this.modifiedChanged();
        this.lastValidValueChanged();
        if (Objects.equals((Object)this, ((ItemUI)this.getParent().getParent()).getFocus().orElse(null))) {
            this.editor.setBorder(focusBorder);
            if (!this.editor.hasFocus()) {
                this.editor.requestFocusInWindow();
            }
        }
    }

    Optional<LocalizedItem> getModel() {
        return Optional.ofNullable(this.model);
    }

    private String getValue() {
        return this.editor.getText().trim();
    }

    private void valueChanged() {
        if (this.model == null) {
            return;
        }
        this.model.setValue(this.getValue());
        this.modifiedChanged();
    }

    private void lastValidValueChanged() {
        if (this.model == null) {
            return;
        }
        this.editor.setText(this.model.getLastValidValue());
    }

    private void modifiedChanged() {
        if (this.model == null) {
            return;
        }
        if (this.model.isModified()) {
            this.editorColor = Color.BLUE;
            this.editorFont = this.getFont().deriveFont(2);
        } else {
            this.editorColor = Color.BLACK;
            this.editorFont = this.getFont();
        }
        int fontStyle = 0;
        this.titleColor = Color.BLACK;
        this.titleText = this.locale.getDisplayName();
        if (!this.model.isSane()) {
            fontStyle |= 1;
        } else if (this.model.isGlobalModified()) {
            this.titleColor = Color.BLUE;
        }
        if (this.model.isModified()) {
            fontStyle |= 2;
            this.titleText = this.titleText + " *";
        }
        if (this.model.isGlobalModified()) {
            fontStyle |= 3;
        }
        this.titleFont = fontStyle == 0 ? this.getFont() : this.getFont().deriveFont(fontStyle);
        if (this.model.isModified() && !this.model.isValueSane()) {
            this.editorColor = Color.RED;
        }
        if (!this.model.isModified() && !this.model.isSane()) {
            this.editorColor = Color.RED;
        }
        if (!this.model.isValueSane() || !this.model.isSane()) {
            this.titleColor = Color.RED;
        }
        this.updateTitle();
    }

    private void updateTitle() {
        this.editor.setFont(this.editorFont);
        this.editor.setForeground(this.editorColor);
        this.setTitleFont(this.titleFont);
        this.setTitleForeground(this.titleColor);
        this.setTitle(this.titleText);
        this.setRightDecoration(this.model.isGlobalModified() ? this.rightDecoration : null);
    }

    public JTextComponent getEditor() {
        return this.editor;
    }
}

