/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.ui;

import com.google.common.collect.ImmutableMap;
import io.ultreia.java4all.i18n.editor.action.ResetAction;
import io.ultreia.java4all.i18n.editor.action.RevertAction;
import io.ultreia.java4all.i18n.editor.action.SaveAction;
import io.ultreia.java4all.i18n.editor.action.SaveAndNextAction;
import io.ultreia.java4all.i18n.editor.model.Item;
import io.ultreia.java4all.i18n.editor.model.LocalizedItem;
import io.ultreia.java4all.i18n.editor.model.Project;
import io.ultreia.java4all.i18n.editor.ui.ItemComponent;
import io.ultreia.java4all.i18n.editor.ui.LocalizedItemUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemUI
extends JPanel {
    public static final String PROPERTY_SAVED = "saved";
    private static final Logger log = LogManager.getLogger(ItemUI.class);
    private final PropertyChangeListener modifiedChanged;
    private final PropertyChangeListener modifiedGlobalChanged;
    private final Map<Locale, LocalizedItemUI> editors;
    private final JButton resetGlobal;
    private final JButton reset;
    private final JButton save;
    private final JButton saveAndNext;
    private final JPanel emptyPanel;
    private final JPanel fillPanel;
    private final ItemComponent itemComponent;
    private Item model;
    private LocalizedItemUI focus;

    ItemUI(ItemComponent itemComponent, Project project, Function<Locale, LocalizedItemUI> generator) {
        this.itemComponent = itemComponent;
        this.setLayout(new BorderLayout());
        this.fillPanel = new JPanel();
        this.fillPanel.setLayout(new GridLayout(0, 1));
        this.emptyPanel = new JPanel();
        this.emptyPanel.setLayout(new BorderLayout());
        this.add((Component)this.emptyPanel, "Center");
        JLabel label = new JLabel("< Select an item >");
        label.setHorizontalAlignment(0);
        label.setEnabled(false);
        this.emptyPanel.add((Component)label, "Center");
        ImmutableMap.Builder editorsBuilder = ImmutableMap.builder();
        for (Locale locale : project.getLocales()) {
            LocalizedItemUI localEditor = generator.apply(locale);
            editorsBuilder.put((Object)locale, (Object)localEditor);
            this.fillPanel.add((Component)((Object)localEditor));
        }
        this.editors = editorsBuilder.build();
        JPanel actions = new JPanel();
        actions.setLayout(new GridLayout(1, 0));
        this.resetGlobal = this.addAction(actions, new RevertAction(itemComponent));
        this.reset = this.addAction(actions, new ResetAction(itemComponent));
        this.save = this.addAction(actions, new SaveAction(itemComponent));
        this.saveAndNext = this.addAction(actions, new SaveAndNextAction(itemComponent));
        this.modifiedChanged = e1 -> this.modifiedChanged();
        this.modifiedGlobalChanged = e -> this.modifiedGlobalChanged();
        this.add((Component)actions, "South");
        this.setMinimumSize(new Dimension(400, 30));
    }

    private JButton addAction(JPanel actions, Action action) {
        JButton result = new JButton(action);
        actions.add(result);
        result.setEnabled(false);
        result.setDisplayedMnemonicIndex(result.getText().length() - 2);
        return result;
    }

    private void modifiedGlobalChanged() {
        if (this.model == null) {
            return;
        }
        this.resetGlobal.setEnabled(!this.model.isModified() && this.model.isGlobalModified());
    }

    private void modifiedChanged() {
        if (this.model == null) {
            return;
        }
        boolean modified = this.model.isModified();
        this.save.setEnabled(modified);
        this.saveAndNext.setEnabled(modified && !this.itemComponent.isLast());
        this.reset.setEnabled(modified);
        this.resetGlobal.setEnabled(!modified && this.model.isGlobalModified());
    }

    public LocalizedItemUI getLocalizedItemUI(Locale locale) {
        return Optional.ofNullable(this.editors.get(locale)).orElseThrow(IllegalStateException::new);
    }

    public Optional<Item> getModel() {
        return Optional.ofNullable(this.model);
    }

    public void setModel(Item model) {
        if (this.model != null) {
            this.model.removePropertyChangeListener("globalModified", this.modifiedGlobalChanged);
            this.model.removePropertyChangeListener("modified", this.modifiedChanged);
        }
        this.model = model;
        if (model == null) {
            this.remove(this.fillPanel);
            this.remove(this.emptyPanel);
            this.add((Component)this.emptyPanel, "Center");
            SwingUtilities.invokeLater(this::revalidate);
            return;
        }
        this.remove(this.fillPanel);
        this.remove(this.emptyPanel);
        this.add((Component)this.fillPanel, "Center");
        if (this.focus == null) {
            Locale locale = this.editors.keySet().iterator().next();
            JTextComponent editor = this.editors.get(locale).getEditor();
            log.info("Set focus to " + editor);
            this.focus(this.editors.get(locale));
        }
        for (LocalizedItem localizedItem : model) {
            this.getLocalizedItemUI(localizedItem.getLocale()).setModel(localizedItem);
        }
        this.model.addPropertyChangeListener("globalModified", this.modifiedGlobalChanged);
        this.model.addPropertyChangeListener("modified", this.modifiedChanged);
        this.modifiedGlobalChanged();
        this.modifiedChanged();
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void focus(LocalizedItemUI focus) {
        this.focus = focus;
    }

    public Optional<LocalizedItemUI> getFocus() {
        return Optional.ofNullable(this.focus);
    }
}

