/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.ui;

import com.google.common.collect.ImmutableList;
import io.ultreia.java4all.i18n.editor.action.GoFirstAction;
import io.ultreia.java4all.i18n.editor.action.GoLastAction;
import io.ultreia.java4all.i18n.editor.action.GoNextAction;
import io.ultreia.java4all.i18n.editor.action.GoPreviousAction;
import io.ultreia.java4all.i18n.editor.action.GoTemplatesAction;
import io.ultreia.java4all.i18n.editor.action.GoTranslationsAction;
import io.ultreia.java4all.i18n.editor.model.Item;
import io.ultreia.java4all.i18n.editor.ui.ItemComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Set;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowFilter;
import org.jdesktop.swingx.JXList;

public class ItemComponentTab {
    private final int tabIndex;
    private final ItemComponent parent;
    private final Function<String, Item> itemGetter;
    private final JXList list;
    private final JButton first;
    private final JButton previous;
    private final JButton next;
    private final JButton last;
    private final JScrollPane scrollPane;
    private final StringDefaultListModel listModel;
    private String title;
    private RowFilter<ListModel, Integer> filter;

    ItemComponentTab(int tabIndex, ItemComponent parent, Function<String, Item> itemGetter, String title, Set<String> items) {
        this.tabIndex = tabIndex;
        this.parent = parent;
        this.itemGetter = itemGetter;
        this.title = title;
        this.listModel = new StringDefaultListModel();
        items.forEach(this.listModel::addElement);
        this.list = new JXList((ListModel)this.listModel);
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.setAutoCreateRowSorter(true);
        this.list.setCellRenderer((ListCellRenderer)new ItemListCellRenderer(itemGetter));
        this.list.getInputMap(1).put(GoTranslationsAction.KEY_STROKE, "none");
        this.list.getInputMap(1).put(GoTemplatesAction.KEY_STROKE, "none");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView((Component)this.list);
        JToolBar navigationActionsPane = new JToolBar();
        navigationActionsPane.setFloatable(false);
        navigationActionsPane.setBorderPainted(false);
        this.first = new JButton(new GoFirstAction(parent));
        navigationActionsPane.add(this.first);
        this.previous = new JButton(new GoPreviousAction(parent));
        navigationActionsPane.add(this.previous);
        this.next = new JButton(new GoNextAction(parent));
        navigationActionsPane.add(this.next);
        this.last = new JButton(new GoLastAction(parent));
        navigationActionsPane.add(this.last);
        JPanel header = new JPanel();
        header.setLayout(new BorderLayout());
        header.add((Component)navigationActionsPane, "Center");
        this.scrollPane.setColumnHeaderView(header);
        this.first.setFocusPainted(false);
        this.first.setFocusable(false);
        this.previous.setFocusPainted(false);
        this.previous.setFocusable(false);
        this.next.setFocusPainted(false);
        this.next.setFocusable(false);
        this.last.setFocusPainted(false);
        this.last.setFocusable(false);
        this.last.setDisplayedMnemonicIndex(this.last.getText().length() - 2);
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean isFirst() {
        return this.getSelectedIndex() == 0;
    }

    public boolean isLast() {
        return this.getSelectedIndex() + 1 == this.getItemCount();
    }

    public JXList getList() {
        return this.list;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int selectedIndex) {
        this.list.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        this.list.scrollRectToVisible(this.list.getCellBounds(selectedIndex, selectedIndex));
    }

    public void clearSelection() {
        this.list.getSelectionModel().clearSelection();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public int getItemCount() {
        return this.list.getRowSorter().getViewRowCount();
    }

    public Item get(String itemKey) {
        return itemKey == null ? null : this.itemGetter.apply(itemKey);
    }

    public String getTitle() {
        return this.title;
    }

    public StringDefaultListModel getListModel() {
        return this.listModel;
    }

    public void refreshActions() {
        boolean notEmpty = this.isNotEmpty();
        boolean notFirst = !this.isFirst();
        boolean notLast = !this.isLast();
        this.previous.setEnabled(notEmpty && notFirst);
        this.first.setEnabled(notEmpty && notFirst);
        this.next.setEnabled(notEmpty && notLast);
        this.last.setEnabled(notEmpty && notLast);
    }

    void repaintList() {
        this.list.repaint(this.list.getCellBounds(this.list.getSelectedIndex(), this.list.getSelectedIndex()));
    }

    public void updateListFromUserFilter(final String text) {
        RowFilter<ListModel, Integer> rowFilter = new RowFilter<ListModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListModel, ? extends Integer> entry) {
                if (text == null) {
                    return true;
                }
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    boolean match;
                    String itemKey = entry.getStringValue(i);
                    Item item = ItemComponentTab.this.get(itemKey);
                    boolean bl = match = itemKey.contains(text) || item.getItems().stream().anyMatch(e -> e.getLastValidValue().contains(text));
                    if (!match) continue;
                    return true;
                }
                return false;
            }
        };
        if (this.filter == null) {
            this.list.setRowFilter((RowFilter)rowFilter);
        } else {
            this.list.setRowFilter(RowFilter.andFilter(ImmutableList.of(this.filter, (Object)rowFilter)));
        }
        this.updateTabTitle();
        this.refreshActions();
    }

    public void updateListFromFilter(boolean add) {
        if (add) {
            this.filter = new RowFilter<ListModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends ListModel, ? extends Integer> entry) {
                    for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                        String itemKey = entry.getStringValue(i);
                        Item item = ItemComponentTab.this.get(itemKey);
                        if (!item.isGlobalModified() && item.isSane()) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.list.setRowFilter(this.filter);
        } else {
            this.filter = null;
            this.list.setRowFilter(null);
        }
        this.updateTabTitle();
        this.refreshActions();
    }

    public void updateTabTitle() {
        int itemCount = this.getItemCount();
        String title = String.format("%s (%d/%s)", this.title, itemCount, this.listModel.size());
        JComponent navigationContent = this.parent.getNavigationContent();
        if (navigationContent instanceof JTabbedPane) {
            ((JTabbedPane)navigationContent).setTitleAt(this.tabIndex, title);
        }
    }

    static class StringDefaultListModel
    extends DefaultListModel<String> {
        StringDefaultListModel() {
        }

        @Override
        public void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }
    }

    static class ItemListCellRenderer
    extends DefaultListCellRenderer {
        private final Function<String, Item> generator;
        private Font font;

        ItemListCellRenderer(Function<String, Item> generator) {
            this.generator = generator;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color color;
            Item item = this.generator.apply((String)value);
            if (item.isGlobalModified()) {
                value = value + " *";
            }
            JComponent component = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (this.font == null) {
                this.font = this.getFont();
            }
            if (!item.isSane()) {
                color = Color.RED;
            } else {
                Color color2 = color = item.isGlobalModified() ? Color.BLUE : Color.BLACK;
            }
            Font font = item.isGlobalModified() ? this.font.deriveFont(3) : (!item.isSane() ? this.font : this.font.deriveFont(-2));
            component.setForeground(color);
            component.setFont(font);
            return component;
        }
    }
}

