/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.ui;

import com.google.common.collect.ImmutableList;
import io.ultreia.java4all.i18n.editor.action.FilterKeysAction;
import io.ultreia.java4all.i18n.editor.action.ResetUserFilterAction;
import io.ultreia.java4all.i18n.editor.model.Item;
import io.ultreia.java4all.i18n.editor.model.Project;
import io.ultreia.java4all.i18n.editor.ui.ItemComponentTab;
import io.ultreia.java4all.i18n.editor.ui.ItemUI;
import io.ultreia.java4all.i18n.editor.ui.LocalizedItemUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXList;

public class ItemComponent {
    private final ItemUI panel;
    private final int mainIndex;
    private final JTabbedPane navigationPane;
    private final Function<String, Item> itemGetter;
    private final String title;
    private final JToggleButton filter;
    private final JTextField searchField;
    private ItemComponentTab currentTab;
    private Map<JXList, ItemComponentTab> tabs;
    private JComponent navigationContent;

    ItemComponent(Project model, int mainIndex, JTabbedPane navigationPane, Function<Locale, LocalizedItemUI> uiGenerator, Function<String, Item> itemGetter, String title, Set<String> items, PropertyChangeListener modifiedChanged, PropertyChangeListener globalModifiedChanged, PropertyChangeListener saneChanged, Map<String, String> tabs) {
        ImmutableList tabsUI;
        this.mainIndex = mainIndex;
        this.navigationPane = navigationPane;
        this.itemGetter = itemGetter;
        this.title = title;
        this.tabs = new LinkedHashMap<JXList, ItemComponentTab>();
        ImmutableList.Builder tabsUIBuilder = ImmutableList.builder();
        LinkedHashSet<String> allItems = new LinkedHashSet<String>(items);
        boolean noTab = tabs.isEmpty();
        if (noTab) {
            ItemComponentTab tab = new ItemComponentTab(0, this, itemGetter, "", items);
            this.navigationContent = tab.getScrollPane();
            tabsUIBuilder.add((Object)tab);
            this.currentTab = tab;
            tabsUI = ImmutableList.of((Object)this.currentTab);
            this.tabs.put(tab.getList(), tab);
        } else {
            this.navigationContent = new JTabbedPane();
            ((JTabbedPane)this.navigationContent).setTabPlacement(2);
            int index = 0;
            for (Map.Entry<String, String> entry : tabs.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Predicate<String> p = e -> false;
                if (value.contains("|")) {
                    for (String s : value.split("\\|")) {
                        p = p.or(s1 -> s1.startsWith(s));
                    }
                } else {
                    p = s1 -> s1.startsWith(value);
                }
                Set collect = allItems.stream().filter(p).collect(Collectors.toCollection(LinkedHashSet::new));
                allItems.removeAll(collect);
                ItemComponentTab tab = new ItemComponentTab(index++, this, itemGetter, key, collect);
                ((JTabbedPane)this.navigationContent).addTab(tab.getTitle(), tab.getScrollPane());
                tabsUIBuilder.add((Object)tab);
            }
            if (!allItems.isEmpty()) {
                ItemComponentTab tab = new ItemComponentTab(index, this, itemGetter, "others", allItems);
                ((JTabbedPane)this.navigationContent).addTab(tab.getTitle(), tab.getScrollPane());
                tabsUIBuilder.add((Object)tab);
            }
            ((JTabbedPane)this.navigationContent).addChangeListener(e -> {
                JTabbedPane source = (JTabbedPane)e.getSource();
                JScrollPane selectedComponent = (JScrollPane)source.getSelectedComponent();
                ItemComponentTab itemComponentTab = this.currentTab = selectedComponent == null ? null : this.tabs.get(selectedComponent.getViewport().getView());
                if (this.currentTab != null) {
                    this.currentTab.clearSelection();
                    if (this.isEmpty()) {
                        this.panel.setModel(null);
                        SwingUtilities.invokeLater(this.panel::repaint);
                    } else {
                        this.setSelectedIndex(0);
                    }
                }
            });
            tabsUI = tabsUIBuilder.build();
            tabsUI.forEach(e -> this.tabs.put(e.getList(), (ItemComponentTab)e));
            ((JTabbedPane)this.navigationContent).setSelectedIndex(-1);
            ((JTabbedPane)this.navigationContent).setSelectedIndex(0);
        }
        this.panel = new ItemUI(this, model, uiGenerator);
        JPanel scrollPane = new JPanel(new BorderLayout());
        navigationPane.add(scrollPane);
        this.updateTabTitle();
        scrollPane.add((Component)this.navigationContent, "Center");
        JPanel header = new JPanel();
        scrollPane.add((Component)header, "North");
        header.setLayout(new BorderLayout());
        JToolBar filterActionsPane = new JToolBar();
        filterActionsPane.setFloatable(false);
        filterActionsPane.setBorderPainted(false);
        this.filter = new JToggleButton(new FilterKeysAction(this));
        filterActionsPane.add(this.filter);
        filterActionsPane.add(new JButton(new ResetUserFilterAction(this)));
        this.searchField = new JTextField();
        this.searchField.addActionListener(e -> this.updateListFromUserFilter(this.searchField.getText()));
        header.add((Component)this.searchField, "Center");
        header.add((Component)filterActionsPane, "West");
        int index = 0;
        for (ItemComponentTab itemComponentTab : tabsUI) {
            int finalIndex = index++;
            itemComponentTab.getList().addListSelectionListener(e -> {
                if (this.currentTab != itemComponentTab) {
                    return;
                }
                JXList list = itemComponentTab.getList();
                Optional<LocalizedItemUI> focus = this.panel.getFocus();
                this.panel.getModel().ifPresent(itemModel -> {
                    itemModel.removePropertyChangeListener("modified", modifiedChanged);
                    itemModel.removePropertyChangeListener("globalModified", globalModifiedChanged);
                    itemModel.removePropertyChangeListener("sane", saneChanged);
                });
                String selectedKey = (String)list.getSelectedValue();
                Item itemModel2 = this.get(selectedKey);
                if (itemModel2 != null) {
                    itemModel2.addPropertyChangeListener("modified", modifiedChanged);
                    itemModel2.addPropertyChangeListener("globalModified", globalModifiedChanged);
                    itemModel2.addPropertyChangeListener("sane", saneChanged);
                }
                itemComponentTab.refreshActions();
                this.panel.setModel(itemModel2);
                SwingUtilities.invokeLater(this.panel::repaint);
                focus.ifPresent(f -> SwingUtilities.invokeLater(f.getEditor()::requestFocusInWindow));
            });
            this.panel.addPropertyChangeListener("saved", e -> {
                JTabbedPane navigationContent1;
                if (this.navigationContent instanceof JTabbedPane && finalIndex != (navigationContent1 = (JTabbedPane)this.navigationContent).getSelectedIndex()) {
                    return;
                }
                JXList list = this.currentTab.getList();
                ItemComponentTab.StringDefaultListModel listModel = (ItemComponentTab.StringDefaultListModel)list.getModel();
                listModel.fireContentsChanged(listModel, list.getSelectedIndex(), list.getSelectedIndex());
                list.resetSortOrder();
                SwingUtilities.invokeLater(this.panel::repaint);
            });
            itemComponentTab.updateTabTitle();
        }
        if (this.isNotEmpty()) {
            this.currentTab.setSelectedIndex(0);
        }
        ((ItemComponentTab)tabsUI.get(0)).refreshActions();
    }

    protected String getTitle() {
        return String.format("%s (%d/%d)", this.title, this.getTotalFilteredCount(), this.getTotalItemCount());
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    public JToggleButton getFilter() {
        return this.filter;
    }

    public void toggleFilter() {
        this.filter.doClick();
    }

    public void updateListFromUserFilter(String text) {
        for (ItemComponentTab value : this.tabs.values()) {
            value.updateListFromUserFilter(text);
        }
        if (this.currentTab != null) {
            this.currentTab.clearSelection();
            if (this.currentTab.isNotEmpty()) {
                this.currentTab.setSelectedIndex(0);
            }
        }
        this.updateTabTitle();
        SwingUtilities.invokeLater(this.searchField::requestFocusInWindow);
    }

    protected void updateTabTitle() {
        this.navigationPane.setTitleAt(this.mainIndex, this.getTitle());
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean isFirst() {
        return this.currentTab.getSelectedIndex() == 0;
    }

    public boolean isLast() {
        return this.currentTab.getSelectedIndex() + 1 == this.getItemCount();
    }

    public ItemUI getPanel() {
        return this.panel;
    }

    public JXList getList() {
        return this.currentTab == null ? null : this.currentTab.getList();
    }

    void repaintList() {
        this.currentTab.repaintList();
    }

    public int getSelectedIndex() {
        return this.currentTab.getSelectedIndex();
    }

    public void setSelectedIndex(int selectedIndex) {
        this.currentTab.setSelectedIndex(selectedIndex);
    }

    public int getItemCount() {
        return this.currentTab.getList().getRowSorter().getViewRowCount();
    }

    public int getTotalFilteredCount() {
        return this.tabs.values().stream().map(ItemComponentTab::getList).map(JXList::getRowSorter).mapToInt(RowSorter::getViewRowCount).sum();
    }

    public int getTotalItemCount() {
        return this.tabs.values().stream().map(ItemComponentTab::getListModel).mapToInt(DefaultListModel::size).sum();
    }

    public Item get(String itemKey) {
        return itemKey == null ? null : this.itemGetter.apply(itemKey);
    }

    public Collection<ItemComponentTab> getTabs() {
        return this.tabs.values();
    }

    public ItemComponentTab getCurrentTab() {
        return this.currentTab;
    }

    public JComponent getNavigationContent() {
        return this.navigationContent;
    }

    public void updateListFromFilter(boolean add) {
        for (ItemComponentTab tab : this.getTabs()) {
            tab.updateListFromFilter(add);
        }
        this.updateTabTitle();
    }
}

