/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.i18n.editor.model.Item;
import io.ultreia.java4all.i18n.runtime.I18nLanguage;
import io.ultreia.java4all.i18n.runtime.I18nLanguageProvider;
import io.ultreia.java4all.util.Version;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Project {
    private static final Logger log = LogManager.getLogger(Project.class);
    private final I18nLanguageProvider languageProvider;
    private final SortedSet<String> translationKeys;
    private final SortedSet<String> templateNames;
    private final SortedSet<Item> translations;
    private final SortedSet<Item> templates;
    private final Path i18nDirectory;
    private final String sessionId;
    private Date lastExportDate;
    private boolean askToQuit;

    public static HashMultimap<Locale, String> getTranslationKeys(I18nLanguageProvider languageProvider) {
        HashMultimap translationKeys = HashMultimap.create();
        for (Locale locale : languageProvider.getLocales()) {
            Properties properties = languageProvider.getLanguage(locale).getTranslations();
            properties.keySet().forEach(o -> {
                translationKeys.put(null, (Object)((String)o));
                translationKeys.put((Object)locale, (Object)((String)o));
            });
        }
        return translationKeys;
    }

    public Project(I18nLanguageProvider languageProvider, Path i18nDirectory) {
        this.languageProvider = Objects.requireNonNull(languageProvider);
        this.i18nDirectory = Objects.requireNonNull(i18nDirectory);
        this.sessionId = String.format("%s-%s-%s", this.getName(), this.getVersion(), new SimpleDateFormat("dd-MM-yyy-HH-mm").format(new Date()));
        ImmutableSet.Builder translationItemsBuilder = ImmutableSet.builder();
        Set locales = this.languageProvider.getLocales();
        LinkedHashMap<Locale, Properties> bundles = new LinkedHashMap<Locale, Properties>();
        for (Locale locale : locales) {
            bundles.put(locale, this.languageProvider.getLanguage(locale).getTranslations());
        }
        HashMultimap<Locale, String> translationKeys = Project.getTranslationKeys(this.languageProvider);
        this.translationKeys = new TreeSet<String>(translationKeys.get(null));
        Iterator iterator = this.translationKeys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            LinkedHashSet<Locale> missingLocales = new LinkedHashSet<Locale>();
            LinkedList<String> translations = new LinkedList<String>();
            for (Locale locale : locales) {
                if (translationKeys.containsEntry((Object)locale, (Object)key)) {
                    translations.add(((Properties)bundles.get(locale)).getProperty(key));
                    continue;
                }
                missingLocales.add(locale);
            }
            if (!missingLocales.isEmpty()) {
                log.warn(String.format("Key [%s] is missing for locale(s): %s", key, missingLocales));
                iterator.remove();
                continue;
            }
            translationItemsBuilder.add((Object)new Item(key, locales, translations.toArray(new String[0])));
        }
        this.translations = new TreeSet<Item>((Collection<Item>)translationItemsBuilder.build());
        ImmutableSet.Builder templateItemsBuilder = ImmutableSet.builder();
        this.templateNames = new TreeSet<String>(this.languageProvider.getApplicationDefinition().getTemplateList());
        Iterator iterator1 = this.templateNames.iterator();
        while (iterator1.hasNext()) {
            String templateName = (String)iterator1.next();
            LinkedHashSet<Locale> missingLocales = new LinkedHashSet<Locale>();
            LinkedList<String> templateContents = new LinkedList<String>();
            for (Locale locale : locales) {
                I18nLanguage language = this.languageProvider.getLanguage(locale);
                String templateContent = language.getTemplate(templateName);
                if (templateContent == null) {
                    missingLocales.add(locale);
                    continue;
                }
                templateContents.add(templateContent);
            }
            if (!missingLocales.isEmpty()) {
                log.warn(String.format("Template [%s] is missing for locale(s): %s", templateName, missingLocales));
                iterator1.remove();
                continue;
            }
            templateItemsBuilder.add((Object)new Item(templateName, locales, templateContents.toArray(new String[0])));
        }
        this.templates = new TreeSet<Item>((Collection<Item>)templateItemsBuilder.build());
    }

    public Path getI18nDirectory() {
        return this.i18nDirectory;
    }

    public Path getI18nUserTranslationsDirectory() {
        return this.getI18nDirectory().resolve("translations");
    }

    public Path getI18nUserTemplatesDirectory() {
        return this.getI18nDirectory().resolve("templates");
    }

    public Path getI18nEditorDirectory() {
        return this.getI18nDirectory().resolve("i18n-editor");
    }

    public Item getTemplate(String templateName) {
        return this.templates.stream().filter(i -> Objects.equals(templateName, i.getKey())).findFirst().orElseThrow(IllegalStateException::new);
    }

    public Item getTranslation(String key) {
        return this.translations.stream().filter(i -> Objects.equals(key, i.getKey())).findFirst().orElse(null);
    }

    public Set<Locale> getLocales() {
        return this.languageProvider.getLocales();
    }

    public Set<String> getTranslationKeys() {
        return this.translationKeys;
    }

    public Set<String> getTemplateNames() {
        return this.templateNames;
    }

    public boolean isModified() {
        return this.translations.stream().anyMatch(Item::isGlobalModified) || this.templates.stream().anyMatch(Item::isGlobalModified);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Path getExportFile() {
        return this.getI18nEditorDirectory().resolve(String.format("%s.zip", this.getSessionId()));
    }

    public String getName() {
        return this.languageProvider.getApplicationDefinition().getName();
    }

    public Version getVersion() {
        return Version.valueOf((String)this.languageProvider.getApplicationDefinition().getVersion());
    }

    public I18nLanguageProvider getLanguageProvider() {
        return this.languageProvider;
    }

    public Set<Item> getModifiedTranslations() {
        return this.translations.stream().filter(Item::isGlobalModified).collect(Collectors.toSet());
    }

    public Set<Item> getModifiedTemplates() {
        return this.templates.stream().filter(Item::isGlobalModified).collect(Collectors.toSet());
    }

    public void setLastExportDate(Date lastExportDate) {
        this.lastExportDate = lastExportDate;
    }

    public Date getLastExportDate() {
        return this.lastExportDate;
    }

    public void setAskToQuit(boolean askToQuit) {
        this.askToQuit = askToQuit;
    }

    public boolean isAskToQuit() {
        return this.askToQuit;
    }
}

