/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.model;

import io.ultreia.java4all.i18n.editor.model.ItemSupport;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LocalizedItem
extends ItemSupport {
    public static final String PROPERTY_LAST_VALID_VALUE = "lastValidValue";
    private final Locale locale;
    private final String originalValue;
    private String lastValidValue;
    private String value;

    LocalizedItem(Locale locale, String originalValue) {
        this.locale = locale;
        this.originalValue = originalValue.trim();
        this.lastValidValue = originalValue.trim();
        this.value = originalValue.trim();
    }

    public void setValue(String value) {
        boolean sane = this.isSane();
        boolean modified = this.isModified();
        this.value = value;
        this.fireModified(modified);
        this.fireSane(sane);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLastValidValue() {
        return this.lastValidValue;
    }

    @Override
    public boolean isGlobalModified() {
        return !Objects.equals(this.originalValue, this.lastValidValue);
    }

    @Override
    public boolean isModified() {
        return !Objects.equals(this.lastValidValue, this.value);
    }

    @Override
    public boolean isSane() {
        return StringUtils.isNotEmpty((CharSequence)this.lastValidValue) && !this.lastValidValue.contains("#TODO");
    }

    public boolean isValueSane() {
        return StringUtils.isNotEmpty((CharSequence)this.value) && !this.value.contains("#TODO");
    }

    @Override
    public void reset() {
        String value = this.value;
        boolean modified = this.isModified();
        this.value = this.lastValidValue;
        this.fireModified(modified);
        this.fireLastValidValue(value);
    }

    @Override
    public void resetGlobal() {
        boolean sane = this.isSane();
        boolean modified = this.isModified();
        boolean globalModified = this.isGlobalModified();
        String lastValidValue = this.lastValidValue;
        this.lastValidValue = this.originalValue;
        this.value = this.originalValue;
        this.fireModified(modified);
        this.fireGlobalModified(globalModified);
        this.fireLastValidValue(lastValidValue);
        this.fireSane(sane);
    }

    @Override
    public void save() {
        boolean sane = this.isSane();
        boolean modified = this.isModified();
        boolean globalModified = this.isGlobalModified();
        String oldLastValidValue = this.lastValidValue;
        this.lastValidValue = this.value;
        this.fireModified(modified);
        this.fireGlobalModified(globalModified);
        this.fireLastValidValue(oldLastValidValue);
        this.fireSane(sane);
    }

    private void fireLastValidValue(String oldValue) {
        this.firePropertyChange(PROPERTY_LAST_VALID_VALUE, oldValue, this.lastValidValue);
    }
}

