/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.model;

import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.i18n.editor.model.ItemSupport;
import io.ultreia.java4all.i18n.editor.model.LocalizedItem;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Item
extends ItemSupport
implements Comparable<Item>,
Iterable<LocalizedItem> {
    private final String key;
    private final ImmutableSet<LocalizedItem> items;
    private boolean adjusting;

    public Item(String key, Set<Locale> locales, String ... values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(locales);
        Objects.requireNonNull(values);
        if (locales.size() != values.length) {
            throw new IllegalStateException("Mismatch lengths!!!!");
        }
        this.key = key;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int i = 0;
        for (Locale locale : locales) {
            LocalizedItem item = new LocalizedItem(locale, values[i++]);
            item.addPropertyChangeListener("modified", evt -> this.fireModified(null));
            item.addPropertyChangeListener("globalModified", evt -> this.fireGlobalModified(null));
            builder.add((Object)item);
        }
        this.items = builder.build();
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isModified() {
        return this.items.stream().anyMatch(LocalizedItem::isModified);
    }

    @Override
    public boolean isGlobalModified() {
        return this.items.stream().anyMatch(LocalizedItem::isGlobalModified);
    }

    public Set<LocalizedItem> getGlobalModifiedItems() {
        return this.items.stream().filter(LocalizedItem::isGlobalModified).collect(Collectors.toSet());
    }

    public ImmutableSet<LocalizedItem> getItems() {
        return this.items;
    }

    @Override
    public boolean isSane() {
        for (LocalizedItem item : this.items) {
            if (item.isSane()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        boolean sane = this.isSane();
        boolean modified = this.isModified();
        this.adjusting = true;
        try {
            this.items.forEach(LocalizedItem::reset);
        }
        finally {
            this.adjusting = false;
        }
        this.fireModified(modified);
        this.fireSane(sane);
    }

    @Override
    public void resetGlobal() {
        boolean sane = this.isSane();
        boolean globalModified = this.isGlobalModified();
        this.adjusting = true;
        try {
            this.items.forEach(LocalizedItem::resetGlobal);
        }
        finally {
            this.adjusting = false;
        }
        this.fireGlobalModified(globalModified);
        this.fireSane(sane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        boolean modified = this.isModified();
        boolean globalModified = this.isGlobalModified();
        boolean sane = this.isSane();
        this.adjusting = true;
        try {
            this.items.stream().filter(LocalizedItem::isModified).forEach(LocalizedItem::save);
        }
        finally {
            this.adjusting = false;
        }
        this.fireModified(modified);
        this.fireGlobalModified(globalModified);
        this.fireSane(sane);
    }

    @Override
    public int compareTo(Item o) {
        return this.key.compareTo(o.getKey());
    }

    @Override
    public Iterator<LocalizedItem> iterator() {
        return this.items.iterator();
    }

    @Override
    void fireGlobalModified(Boolean oldValue) {
        if (!this.adjusting) {
            super.fireGlobalModified(oldValue);
        }
    }

    @Override
    void fireModified(Boolean oldValue) {
        if (!this.adjusting) {
            super.fireModified(oldValue);
        }
    }

    @Override
    void fireSane(Boolean oldValue) {
        if (!this.adjusting) {
            super.fireSane(oldValue);
        }
    }

    Set<? extends Locale> getModifiedLocales() {
        return this.items.stream().filter(LocalizedItem::isGlobalModified).map(LocalizedItem::getLocale).collect(Collectors.toSet());
    }
}

