/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.editor.action;

import com.google.common.collect.HashMultimap;
import io.ultreia.java4all.i18n.editor.action.ProjectActionSupport;
import io.ultreia.java4all.i18n.editor.model.Item;
import io.ultreia.java4all.i18n.editor.model.LocalizedItem;
import io.ultreia.java4all.i18n.editor.model.Project;
import io.ultreia.java4all.i18n.editor.ui.ProjectUI;
import io.ultreia.java4all.i18n.runtime.I18nLanguage;
import io.ultreia.java4all.i18n.runtime.I18nLanguageProvider;
import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import io.ultreia.java4all.i18n.spi.I18nTemplateDefinition;
import io.ultreia.java4all.i18n.spi.I18nTranslationSetDefinition;
import io.ultreia.java4all.i18n.spi.io.I18nTranslationSetClassPathReader;
import io.ultreia.java4all.util.SortedProperties;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.JOptionPanes;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class ExportAction
extends ProjectActionSupport {
    private static final Logger log = LogManager.getLogger(ExportAction.class);

    public ExportAction(ProjectUI ui) {
        super(ui, "Export", "Export modified translation(s) and templates", 69, "export");
    }

    private static String exportProject(Project project) throws IOException, I18nResourceInitializationException {
        StringBuilder report = new StringBuilder("<html><body>");
        String filename = project.getSessionId();
        project.setLastExportDate(new Date());
        Path path = project.getI18nEditorDirectory().resolve(filename);
        log.info("Will store modifications at: " + path);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        Set<Item> modifiedTranslations = project.getModifiedTranslations();
        log.info(String.format("Found %d modified translation(s).", modifiedTranslations.size()));
        I18nLanguageProvider languageProvider = project.getLanguageProvider();
        Charset encoding = languageProvider.getConfiguration().getEncoding();
        report.append("<h2>Summary</h2>");
        if (!modifiedTranslations.isEmpty()) {
            report.append(String.format("<h3>%d translation(s) modified</h2><ul>", modifiedTranslations.size()));
            HashMultimap translations = HashMultimap.create();
            for (Item item : modifiedTranslations) {
                for (LocalizedItem localizedItem : item.getGlobalModifiedItems()) {
                    translations.put((Object)localizedItem.getLocale(), (Object)Pair.of((Object)item.getKey(), (Object)localizedItem.getLastValidValue()));
                }
            }
            Path translationsPath = path.resolve("translations");
            Path i18nUserTranslationsDirectory = project.getI18nUserTranslationsDirectory();
            for (Map.Entry entry : translations.asMap().entrySet()) {
                Locale locale = (Locale)entry.getKey();
                I18nLanguage language = languageProvider.getLanguage(locale);
                I18nTranslationSetDefinition translationSetDefinition = language.getTranslationSetDefinition();
                Collection value = (Collection)entry.getValue();
                Properties modifiedTranslationProperties = ExportAction.toProperties(value);
                Path applicationTarget = I18nTranslationSetDefinition.write((I18nTranslationSetDefinition)translationSetDefinition, (Charset)encoding, (boolean)false, (Path)translationsPath, (Properties)modifiedTranslationProperties, (boolean)true);
                report.append(String.format("<li>Store %d translation(s) to file: %s</li>", modifiedTranslationProperties.size(), applicationTarget.toFile().getName()));
                if (Files.exists(i18nUserTranslationsDirectory, new LinkOption[0])) {
                    Properties languageTranslations = language.getTranslations();
                    languageTranslations.putAll((Map<?, ?>)modifiedTranslationProperties);
                    Path write = I18nTranslationSetDefinition.write((I18nTranslationSetDefinition)translationSetDefinition, (Charset)encoding, (boolean)false, (Path)i18nUserTranslationsDirectory, (Properties)languageTranslations, (boolean)true);
                    report.append(String.format("<li>Merge %d translation(s) to application file: %s</li>", modifiedTranslationProperties.size(), write.toFile().getName()));
                }
                I18nTranslationSetClassPathReader reader = new I18nTranslationSetClassPathReader(languageProvider.getConfiguration().getClassLoader(), true);
                for (I18nTranslationSetDefinition i18nTranslationSetDefinition : language.getDependenciesTranslationSetDefinition()) {
                    Properties pp = reader.read(i18nTranslationSetDefinition, encoding);
                    Collection valueForThisBundle = value.stream().filter(p -> pp.containsKey(p.getKey())).collect(Collectors.toSet());
                    Properties properties = ExportAction.toProperties(valueForThisBundle);
                    if (valueForThisBundle.isEmpty()) continue;
                    Path dependencyTarget = I18nTranslationSetDefinition.write((I18nTranslationSetDefinition)i18nTranslationSetDefinition, (Charset)encoding, (boolean)true, (Path)translationsPath, (Properties)properties, (boolean)true);
                    report.append(String.format("<li>Store %d translation(s) to file: %s</li>", valueForThisBundle.size(), dependencyTarget.toFile().getName()));
                }
            }
            report.append("</ul>");
        }
        Set<Item> modifiedTemplates = project.getModifiedTemplates();
        log.info(String.format("Found %d modified template(s).", modifiedTemplates.size()));
        if (!modifiedTemplates.isEmpty()) {
            report.append(String.format("<h3>%d templates modified</h3><ul>", modifiedTranslations.size()));
            Path templatesPath = path.resolve("templates");
            Path i18nUserTemplatesDirectory = project.getI18nUserTemplatesDirectory();
            for (Item item : modifiedTemplates) {
                for (LocalizedItem localizedItem : item.getGlobalModifiedItems()) {
                    I18nLanguage language = languageProvider.getLanguage(localizedItem.getLocale());
                    I18nTemplateDefinition templateDefinition = language.getTemplateDefinition(item.getKey());
                    String template = localizedItem.getLastValidValue();
                    Path write = I18nTemplateDefinition.write((I18nTemplateDefinition)templateDefinition, (Path)templatesPath, (Charset)encoding, (boolean)false, (String)template, (boolean)true);
                    report.append(String.format("<li>Store template %s to file: %s</li>", templateDefinition.getId(), write.toFile().getName()));
                    if (!Files.exists(i18nUserTemplatesDirectory, new LinkOption[0])) continue;
                    Path write1 = I18nTemplateDefinition.write((I18nTemplateDefinition)templateDefinition, (Path)i18nUserTemplatesDirectory, (Charset)encoding, (boolean)false, (String)template, (boolean)true);
                    report.append(String.format("<li>Merge template %s to application file: %s</li>", templateDefinition.getId(), write1.toFile().getName()));
                }
            }
            report.append("</ul>");
        }
        Path zipFile = project.getExportFile();
        log.info("Store modifications to zip file: " + zipFile);
        report.append("<h2>Export</h2>");
        report.append(String.format("<p>Store modifications to <a href=\"file://%1$s\">%1$s</a></p>", path));
        report.append(String.format("<p>Archive created at <a href=\"file://%s\">%s</a></p>", zipFile.getParent(), zipFile));
        report.append("<h2>Note</h2>");
        report.append("<p><i>Please click on archive or directory to open it on your system.</i></p>");
        try (ZipOutputStream zipFileOut = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));
             Stream<Path> paths = Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            for (Path p2 : paths.collect(Collectors.toList())) {
                ExportAction.addToZip(zipFileOut, path, p2, encoding);
            }
        }
        return report.toString();
    }

    private static void addToZip(ZipOutputStream zipFile, Path path, Path file, Charset encoding) throws IOException {
        String filename = path.relativize(file).toString();
        log.info(String.format("Add zip entry: %s", filename));
        zipFile.putNextEntry(new ZipEntry(new String(filename.getBytes(), StandardCharsets.UTF_8)));
        List<String> lines = Files.readAllLines(file, encoding);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));){
                for (String line : lines) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            zipFile.write(out.toByteArray());
        }
    }

    private static Properties toProperties(Collection<Pair<String, String>> value) {
        SortedProperties pp = new SortedProperties();
        value.forEach(p -> pp.put(p.getLeft(), p.getRight()));
        return pp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String exportResult;
        Project project = this.ui.getModel();
        try {
            exportResult = ExportAction.exportProject(project);
        }
        catch (Exception ee) {
            throw new RuntimeException("Could not export", ee);
        }
        JEditorPane label = new JEditorPane("text/html; charset=UTF8", exportResult);
        label.addHyperlinkListener(SwingUtil::openLink);
        label.setEditable(false);
        JScrollPane pane = new JScrollPane(label, 20, 31);
        if (this.ui.getModel().isAskToQuit()) {
            JOptionPanes.askUser((Component)this.ui, (String)"Export done (before quitting)", (Object)pane, (int)1, (Object[])new Object[]{"Quit"}, (int)0);
            this.ui.dispose();
            return;
        }
        int response = JOptionPanes.askUser((Component)this.ui, (String)"Export done", (Object)pane, (int)1, (Object[])new Object[]{"Quit", "Continue editing"}, (int)1);
        switch (response) {
            case -1: 
            case 1: {
                break;
            }
            case 0: {
                this.ui.dispose();
            }
        }
    }
}

